/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets.controller;

import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.riena.core.RienaStatus;
import org.eclipse.riena.ui.core.context.IContext;
import org.eclipse.riena.ui.ridgets.ClassRidgetMapper;
import org.eclipse.riena.ui.ridgets.IActionListener;
import org.eclipse.riena.ui.ridgets.IActionRidget;
import org.eclipse.riena.ui.ridgets.IDefaultActionManager;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.IWindowRidget;
import org.eclipse.riena.ui.ridgets.controller.IController;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractWindowController
implements IController,
IContext {
    public static final String RIDGET_ID_OK = "dialogOkButton";
    public static final String RIDGET_ID_CANCEL = "dialogCancelButton";
    public static final String RIDGET_ID_WINDOW = "windowRidget";
    public static final int OK = 0;
    public static final int CANCEL = 1;
    private final Map<String, IRidget> ridgets = new HashMap<String, IRidget>();
    private final Map<String, Object> context = new HashMap<String, Object>();
    private IWindowRidget windowRidget;
    private boolean blocked;
    private int returnCode;
    private IDefaultActionManager actionManager;

    public void addDefaultAction(IRidget focusRidget, IActionRidget action) {
        this.actionManager = this.getWindowRidget().addDefaultAction(focusRidget, action);
    }

    @Override
    public void addRidget(String id, IRidget ridget) {
        this.ridgets.put(id, ridget);
    }

    @Override
    public void afterBind() {
        this.returnCode = 0;
        this.getWindowRidget().updateFromModel();
        if (this.actionManager != null) {
            this.actionManager.activate();
        }
    }

    @Override
    public void configureRidgets() {
        this.setWindowRidget((IWindowRidget)this.getRidget(RIDGET_ID_WINDOW));
        this.configureOkCancelButtons();
    }

    protected void configureOkCancelButtons() {
        IActionRidget cancelAction;
        IActionRidget okAction = this.getRidget(IActionRidget.class, RIDGET_ID_OK);
        if (okAction != null) {
            okAction.setText("&Okay");
            okAction.addListener(new IActionListener(){

                public void callback() {
                    AbstractWindowController.this.close(0);
                }
            });
        }
        if ((cancelAction = this.getRidget(IActionRidget.class, RIDGET_ID_CANCEL)) != null) {
            cancelAction.addListener(new IActionListener(){

                public void callback() {
                    AbstractWindowController.this.close(1);
                }
            });
        }
    }

    public Object getContext(String key) {
        return this.context.get(key);
    }

    @Override
    public <R extends IRidget> R getRidget(String id) {
        return (R)this.ridgets.get(id);
    }

    @Override
    public <R extends IRidget> R getRidget(Class<R> ridgetClazz, String id) {
        Object ridget = this.getRidget(id);
        if (ridget != null) {
            return ridget;
        }
        if (RienaStatus.isTest()) {
            try {
                if (ridgetClazz.isInterface() || Modifier.isAbstract(ridgetClazz.getModifiers())) {
                    Class<? extends IRidget> mappedRidgetClazz = ClassRidgetMapper.getInstance().getRidgetClass(ridgetClazz);
                    if (mappedRidgetClazz != null) {
                        ridget = mappedRidgetClazz.newInstance();
                    }
                    Assert.isNotNull(ridget, (String)("Could not find a corresponding implementation for " + ridgetClazz.getName() + " in " + ClassRidgetMapper.class.getName()));
                } else {
                    ridget = (IRidget)ridgetClazz.newInstance();
                }
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            this.addRidget(id, (IRidget)ridget);
        }
        return ridget;
    }

    @Override
    public Collection<? extends IRidget> getRidgets() {
        return this.ridgets.values();
    }

    public IWindowRidget getWindowRidget() {
        if (RienaStatus.isTest() && this.windowRidget == null) {
            Class<? extends IRidget> mappedRidgetClazz = ClassRidgetMapper.getInstance().getRidgetClass(IWindowRidget.class);
            try {
                if (mappedRidgetClazz != null) {
                    this.windowRidget = (IWindowRidget)mappedRidgetClazz.newInstance();
                }
                Assert.isNotNull((Object)this.windowRidget, (String)("Could not find a corresponding implementation for IWindowRidget in " + ClassRidgetMapper.class.getName()));
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        return this.windowRidget;
    }

    public int getReturnCode() {
        return this.returnCode;
    }

    @Override
    public boolean isBlocked() {
        return this.blocked;
    }

    @Override
    public void setBlocked(boolean blocked) {
        this.blocked = blocked;
    }

    public void setContext(String key, Object value) {
        this.context.put(key, value);
    }

    public void setReturnCode(int returnCode) {
        this.returnCode = returnCode;
    }

    public void setWindowRidget(IWindowRidget windowRidget) {
        this.windowRidget = windowRidget;
    }

    public void close(int returnCode) {
        this.setReturnCode(returnCode);
        this.getWindowRidget().dispose();
    }
}

