/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.swt;

import org.eclipse.core.runtime.Assert;
import org.eclipse.riena.ui.swt.EventForwarder;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class ChoiceComposite
extends Composite
implements SelectionListener {
    private final boolean isMulti;
    private int marginHeight;
    private int marginWidth;
    private int vSpacing;
    private int hSpacing = 3;
    private int orientation;
    private boolean isEditable;
    private Color bgColor;

    public ChoiceComposite(Composite parent, int style) {
        this(parent, style, true);
    }

    public ChoiceComposite(Composite parent, int style, boolean multipleSelection) {
        super(parent, style);
        this.isMulti = multipleSelection;
        this.orientation = 512;
        this.isEditable = true;
        this.applyLayout();
    }

    public Button createChild(String caption) {
        int style = this.isMulti ? 32 : 16;
        Button result = new Button((Composite)this, style);
        result.setText(caption);
        result.setForeground(this.getForeground());
        result.setBackground(this.getBackground());
        result.addSelectionListener((SelectionListener)this);
        new EventForwarder((Control)result, (Control)this);
        this.updateEnabled((Control)result, this.isEnabled());
        return result;
    }

    public final boolean getEditable() {
        this.checkWidget();
        return this.isEditable;
    }

    public final Point getMargins() {
        return new Point(this.marginHeight, this.marginWidth);
    }

    public int getOrientation() {
        return this.orientation;
    }

    public final Point getSpacing() {
        return new Point(this.hSpacing, this.vSpacing);
    }

    public final boolean isMultipleSelection() {
        return this.isMulti;
    }

    public final void setBackground(Color color) {
        this.setRedraw(false);
        try {
            this.bgColor = color;
            this.updateBgColor();
        }
        finally {
            this.setRedraw(true);
        }
    }

    public final void setEditable(boolean editable) {
        this.isEditable = editable;
        this.updateEnabled(this.getEnabled());
    }

    public final void setEnabled(boolean enabled) {
        this.setRedraw(false);
        try {
            super.setEnabled(enabled);
            this.updateEnabled(enabled);
            this.updateBgColor();
        }
        finally {
            this.setRedraw(true);
        }
    }

    public final void setForeground(Color color) {
        this.setRedraw(false);
        try {
            super.setForeground(color);
            Control[] controlArray = this.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                child.setForeground(color);
                ++n2;
            }
        }
        finally {
            this.setRedraw(true);
        }
    }

    public final void setMargins(int marginHeight, int marginWidth) {
        Assert.isLegal((marginHeight >= 0 ? 1 : 0) != 0, (String)("marginHeight must be greater or equal to zero: " + marginHeight));
        Assert.isLegal((marginWidth >= 0 ? 1 : 0) != 0, (String)("marginWidth must be greater or equal to zero: " + marginWidth));
        this.marginHeight = marginHeight;
        this.marginWidth = marginWidth;
        this.applyLayout();
    }

    public final void setOrientation(int orientation) {
        Assert.isLegal((orientation == 512 || orientation == 256 ? 1 : 0) != 0);
        if (this.orientation != orientation) {
            this.orientation = orientation;
            this.applyLayout();
        }
    }

    public final void setSpacing(int hSpacing, int vSpacing) {
        Assert.isLegal((hSpacing >= 0 ? 1 : 0) != 0, (String)("hSpacing must be greater or equal to zero: " + hSpacing));
        Assert.isLegal((vSpacing >= 0 ? 1 : 0) != 0, (String)("vSpacing must be greater or equal to zero: " + vSpacing));
        this.hSpacing = hSpacing;
        this.vSpacing = vSpacing;
        this.applyLayout();
    }

    public void widgetSelected(SelectionEvent e) {
        if (!this.isEditable) {
            Button button = (Button)e.widget;
            button.setSelection(button.isEnabled());
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    private void applyLayout() {
        if (this.orientation == 512) {
            FillLayout layout = new FillLayout(512);
            layout.marginHeight = this.marginHeight;
            layout.marginWidth = this.marginWidth;
            layout.spacing = this.vSpacing;
            this.setLayout((Layout)layout);
        } else {
            RowLayout layout = new RowLayout(256);
            layout.marginHeight = this.marginHeight;
            layout.marginWidth = this.marginWidth;
            layout.marginLeft = 0;
            layout.marginRight = 0;
            layout.marginTop = 0;
            layout.marginBottom = 0;
            layout.spacing = this.hSpacing;
            layout.wrap = false;
            this.setLayout((Layout)layout);
        }
    }

    private void updateBgColor() {
        this.updateBgColor(this.isEnabled() && this.bgColor != null ? this.bgColor : this.getParent().getBackground());
    }

    private void updateBgColor(Color color) {
        super.setBackground(color);
        Control[] controlArray = this.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.setBackground(color);
            ++n2;
        }
    }

    private void updateEnabled(boolean isEnabled) {
        Control[] controlArray = this.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            this.updateEnabled(child, isEnabled);
            ++n2;
        }
    }

    private void updateEnabled(Control child, boolean isEnabled) {
        if (!this.isEditable && isEnabled) {
            Button button = (Button)child;
            child.setEnabled(button.getSelection());
        } else {
            child.setEnabled(isEnabled);
        }
    }
}

