/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.communication.core.progressmonitor;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.riena.communication.core.progressmonitor.IRemoteProgressMonitor;
import org.eclipse.riena.communication.core.progressmonitor.IRemoteProgressMonitorList;
import org.eclipse.riena.communication.core.progressmonitor.IRemoteProgressMonitorRegistry;
import org.eclipse.riena.communication.core.progressmonitor.ProgressMonitorListImpl;
import org.eclipse.riena.internal.communication.core.factory.CallHooksProxy;

public class ProgressMonitorRegistryImpl
implements IRemoteProgressMonitorRegistry {
    private final HashMap<Object, List<IRemoteProgressMonitor>> remoteProgressMonitors = new HashMap();

    public void addProgressMonitor(Object callProxy, IRemoteProgressMonitor monitor, IRemoteProgressMonitorRegistry.RemovalPolicy removalPolicy) {
        List<IRemoteProgressMonitor> pmList;
        InvocationHandler invocationHandler;
        if (Proxy.isProxyClass(callProxy.getClass()) && (invocationHandler = Proxy.getInvocationHandler(callProxy)) instanceof CallHooksProxy) {
            callProxy = ((CallHooksProxy)invocationHandler).getCallProxy();
        }
        if ((pmList = this.remoteProgressMonitors.get(callProxy)) == null) {
            pmList = new ArrayList<IRemoteProgressMonitor>();
            this.remoteProgressMonitors.put(callProxy, pmList);
        }
        pmList.add(monitor);
    }

    public IRemoteProgressMonitorList getProgressMonitors(Object callProxy) {
        List<IRemoteProgressMonitor> pmList = this.remoteProgressMonitors.get(callProxy);
        if (pmList == null) {
            return null;
        }
        return new ProgressMonitorListImpl(pmList.toArray(new IRemoteProgressMonitor[pmList.size()]));
    }

    public void removeAllProgressMonitors(Object callProxy) {
        this.remoteProgressMonitors.remove(callProxy);
    }

    public void removeProgressMonitor(IRemoteProgressMonitor monitor) {
        for (List<IRemoteProgressMonitor> pmList : this.remoteProgressMonitors.values()) {
            pmList.remove(monitor);
        }
    }
}

