/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core.logging.log4j;

import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.MDC;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.riena.core.exception.Failure;
import org.eclipse.riena.core.logging.log4j.ILog4jDiagnosticContext;
import org.eclipse.riena.core.util.PropertiesUtils;
import org.eclipse.riena.core.util.VariableManagerUtil;

public class Log4jMDCDiagnosticContext
implements ILog4jDiagnosticContext,
IExecutableExtension {
    private final Map<String, String> staticContextInfo = new HashMap<String, String>();
    private final Map<String, String> dynamicContextInfo = new HashMap<String, String>();

    public void push() {
        for (Map.Entry<String, String> entry : this.staticContextInfo.entrySet()) {
            MDC.put((String)entry.getKey(), (Object)entry.getValue());
        }
        for (Map.Entry<String, String> entry : this.dynamicContextInfo.entrySet()) {
            try {
                MDC.put((String)entry.getKey(), (Object)VariableManagerUtil.substitute(entry.getValue()));
            }
            catch (CoreException e) {
                throw new Log4jMDCDiagnosticContextFailure("Could not perform string substitution for: " + entry.getValue(), e);
            }
        }
    }

    public void pop() {
        for (String key : this.staticContextInfo.keySet()) {
            MDC.remove((String)key);
        }
        for (String key : this.dynamicContextInfo.keySet()) {
            MDC.remove((String)key);
        }
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        try {
            for (Map.Entry<String, String> entry : PropertiesUtils.asMap(data, new String[0]).entrySet()) {
                String key = entry.getKey();
                if (key.startsWith("*") && key.length() > 1) {
                    this.dynamicContextInfo.put(key.substring(1), entry.getValue());
                    continue;
                }
                this.staticContextInfo.put(key, VariableManagerUtil.substitute(entry.getValue()));
            }
        }
        catch (IllegalArgumentException e) {
            throw this.configurationException("Bad configuration.", e);
        }
    }

    private CoreException configurationException(String message, Exception e) {
        return new CoreException((IStatus)new Status(4, "org.eclipse.riena.core", message, (Throwable)e));
    }

    private static class Log4jMDCDiagnosticContextFailure
    extends Failure {
        private static final long serialVersionUID = 6386788702002693828L;

        public Log4jMDCDiagnosticContextFailure(String msg, Throwable cause) {
            super(msg, cause);
        }
    }
}

