/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core.singleton;

import java.lang.reflect.Constructor;
import org.eclipse.riena.core.singleton.SingletonFailure;
import org.eclipse.riena.core.wire.Wire;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingletonProvider<S> {
    protected final Class<S> singletonClass;
    private volatile S singleton;

    public SingletonProvider(Class<S> singletonClass) {
        this.singletonClass = singletonClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public S getInstance() {
        S result = this.singleton;
        if (result == null) {
            SingletonProvider singletonProvider = this;
            synchronized (singletonProvider) {
                result = this.singleton;
                if (result == null) {
                    this.singleton = result = this.newWiredInstance();
                }
            }
        }
        return result;
    }

    private S newWiredInstance() {
        boolean isAccessible = true;
        Constructor<S> constructor = null;
        try {
            constructor = this.singletonClass.getDeclaredConstructor(new Class[0]);
            isAccessible = constructor.isAccessible();
            if (!isAccessible) {
                constructor.setAccessible(true);
            }
            S result = constructor.newInstance(new Object[0]);
            Wire.instance(result).andStart();
            S s = result;
            return s;
        }
        catch (Exception e) {
            throw new SingletonFailure("Could not instantiate RCP controlled singleton.", e);
        }
        finally {
            if (!isAccessible && constructor != null) {
                constructor.setAccessible(false);
            }
        }
    }
}

