/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core.util;

import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.IDynamicVariable;
import org.eclipse.core.variables.IDynamicVariableResolver;
import org.osgi.framework.FrameworkUtil;

public class FunctionResolver
implements IDynamicVariableResolver {
    private final Map<String, IFun> funs = new HashMap<String, IFun>();

    public FunctionResolver() {
        this.funs.put("toFile", new ToFile());
    }

    public String resolveValue(IDynamicVariable variable, String argument) throws CoreException {
        if (argument == null) {
            throw this.createCoreException("expects at least one argument (the function name)", null);
        }
        String[] arguments = argument.split(",");
        if (arguments.length == 0) {
            throw this.createCoreException("expects at least one argument (the function name)", null);
        }
        IFun fun = this.funs.get(arguments[0]);
        if (fun == null) {
            throw this.createCoreException("called with unknown function '" + arguments[0] + "'", null);
        }
        try {
            String[] funArgs = new String[arguments.length - 1];
            System.arraycopy(arguments, 1, funArgs, 0, arguments.length - 1);
            return fun.apply(funArgs);
        }
        catch (Throwable t) {
            throw this.createCoreException(" failed calling '" + arguments[0] + "'", t);
        }
    }

    private CoreException createCoreException(String message, Throwable t) {
        return new CoreException((IStatus)new Status(4, FrameworkUtil.getBundle(FunctionResolver.class).getSymbolicName(), String.valueOf(FunctionResolver.class.getSimpleName()) + " " + message, t));
    }

    private static interface IFun {
        public String apply(String[] var1) throws Exception;
    }

    private static class ToFile
    implements IFun {
        private ToFile() {
        }

        public String apply(String[] arguments) throws Exception {
            Assert.isLegal((arguments.length == 1 ? 1 : 0) != 0, (String)"exactly one argument expected (a file URL)");
            URL url = new URL(arguments[0]);
            return new File(url.getPath()).getAbsolutePath().replace('\\', '/');
        }
    }
}

