/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets.swt;

import org.eclipse.equinox.log.Logger;
import org.eclipse.riena.core.IRienaActivator;
import org.eclipse.riena.core.Log4r;
import org.eclipse.riena.internal.ui.ridgets.swt.Activator;
import org.eclipse.riena.ui.core.resource.IIconManager;
import org.eclipse.riena.ui.core.resource.IconManagerProvider;
import org.eclipse.riena.ui.core.resource.IconSize;
import org.eclipse.riena.ui.core.resource.IconState;
import org.eclipse.riena.ui.ridgets.swt.AbstractActionRidget;
import org.eclipse.riena.ui.swt.ImageButton;
import org.eclipse.riena.ui.swt.utils.ImageStore;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;

public class ImageButtonRidget
extends AbstractActionRidget {
    private static final Logger LOGGER = Log4r.getLogger((IRienaActivator)Activator.getDefault(), ImageButtonRidget.class);
    private ImageButton button;

    public ImageButton getUIControl() {
        return (ImageButton)super.getUIControl();
    }

    protected void checkUIControl(Object uiControl) {
        ImageButtonRidget.assertType(uiControl, ImageButton.class);
    }

    protected String getUIControlText() {
        LOGGER.log(2, "The " + ImageButton.class.getSimpleName() + " does not support the property \"text\"");
        return "";
    }

    protected void setUIControlText(String text) {
        LOGGER.log(2, "The " + ImageButton.class.getSimpleName() + " does not support the property \"text\"");
    }

    protected void bindUIControl() {
        ImageButton control = this.getUIControl();
        if (control != null) {
            this.button = control;
            this.button.addSelectionListener((SelectionListener)this.actionObserver);
            this.updateUIIcon();
        }
    }

    protected void unbindUIControl() {
        super.unbindUIControl();
        if (this.button != null) {
            this.button.removeSelectionListener((SelectionListener)this.actionObserver);
            this.button = null;
        }
    }

    protected void setUIControlImage(Image image) {
        this.getUIControl().setImage(image);
    }

    protected void updateUIIcon() {
        super.updateUIIcon();
        ImageButton control = this.getUIControl();
        if (control != null) {
            IIconManager manager = IconManagerProvider.getInstance().getIconManager();
            String iconName = null;
            String iconId = this.getIcon();
            if (iconId != null) {
                iconName = manager.getName(iconId);
            }
            if (iconName != null) {
                IconSize size = manager.getSize(iconId);
                iconId = manager.getIconID(iconName, size, IconState.DISABLED);
                control.setDisabledImage(ImageStore.getInstance().getImage(iconId));
                iconId = manager.getIconID(iconName, size, IconState.HOVER);
                control.setHoverImage(ImageStore.getInstance().getImage(iconId));
                iconId = manager.getIconID(iconName, size, IconState.PRESSED);
                control.setPressedImage(ImageStore.getInstance().getImage(iconId));
                iconId = manager.getIconID(iconName, size, IconState.HAS_FOCUS);
                control.setFocusedImage(ImageStore.getInstance().getImage(iconId));
                iconId = manager.getIconID(iconName, size, IconState.HOVER_HAS_FOCUS);
                control.setHoverFocusedImage(ImageStore.getInstance().getImage(iconId));
            } else {
                control.setDisabledImage(null);
                control.setHoverImage(null);
                control.setPressedImage(null);
                control.setFocusedImage(null);
                control.setHoverFocusedImage(null);
            }
        }
    }
}

