/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets.tree2;

import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.riena.ui.ridgets.tree2.ITreeNode;

public final class TreeNodeUtils {
    private TreeNodeUtils() {
    }

    public static boolean isLeaf(ITreeNode node) {
        List<ITreeNode> children = node.getChildren();
        return children.size() == 0;
    }

    public static int getLevel(ITreeNode node) {
        int result = 0;
        ITreeNode parent = node.getParent();
        while (parent != null) {
            ++result;
            parent = parent.getParent();
        }
        return result;
    }

    public static int getChildCount(ITreeNode node) {
        return node.getChildren().size();
    }

    public static int getIndex(ITreeNode parent, ITreeNode child) {
        List<ITreeNode> children = parent.getChildren();
        return children.indexOf(child);
    }

    public static ITreeNode getChild(ITreeNode parent, int index) {
        Assert.isLegal((index >= 0 ? 1 : 0) != 0);
        ITreeNode result = null;
        List<ITreeNode> children = parent.getChildren();
        if (index < children.size()) {
            result = children.get(index);
        }
        return result;
    }

    public static ITreeNode getRoot(ITreeNode node) {
        ITreeNode result = node;
        while (result.getParent() != null) {
            result = result.getParent();
        }
        return result;
    }
}

