/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.swt;

import org.eclipse.riena.internal.ui.swt.utils.ShellHelper;
import org.eclipse.riena.ui.swt.facades.SWTFacade;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.riena.ui.swt.lnf.renderer.AbstractTitleBarRenderer;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public abstract class AbstractTitleBarMouseListener
implements MouseListener,
MouseTrackListener,
MouseMoveListener {
    private static final ShellHelper SHELL_HELPER = new ShellHelper();
    private Cursor handCursor;
    private Cursor grabCursor;
    private Cursor defaultCursor;
    private static final int BTN_COUNT = 3;
    private static final int CLOSE_BTN_INDEX = 0;
    private static final int MAX_BTN_INDEX = 1;
    private static final int MIN_BTN_INDEX = 2;
    private final BtnState[] btnStates = new BtnState[3];
    private boolean mouseDownOnButton;
    private boolean moveInside;
    private boolean move;
    private Point moveStartPoint;

    public AbstractTitleBarMouseListener() {
        this.resetBtnStates();
        this.mouseDownOnButton = false;
        this.move = false;
        this.updateRenderer();
    }

    protected abstract AbstractTitleBarRenderer getTitleBarRenderer();

    private void resetBtnStates() {
        int i = 0;
        while (i < this.btnStates.length) {
            this.changeBtnState(BtnState.NONE, i);
            ++i;
        }
    }

    private void changeBtnState(BtnState newState, int btnIndex) {
        if (newState != BtnState.NONE) {
            this.resetBtnStates();
        }
        this.btnStates[btnIndex] = newState;
    }

    private void updateButtonStates(MouseEvent e) {
        boolean redraw;
        Point pointer = new Point(e.x, e.y);
        boolean insideAButton = false;
        this.resetBtnStates();
        if (this.getTitleBarRenderer().isInsideCloseButton(pointer)) {
            if (this.mouseDownOnButton) {
                this.changeBtnState(BtnState.HOVER_SELECTED, 0);
            } else {
                this.changeBtnState(BtnState.HOVER, 0);
            }
            insideAButton = true;
        } else if (this.getTitleBarRenderer().isInsideMaximizeButton(pointer)) {
            if (this.mouseDownOnButton) {
                this.changeBtnState(BtnState.HOVER_SELECTED, 1);
            } else {
                this.changeBtnState(BtnState.HOVER, 1);
            }
            insideAButton = true;
        } else if (this.getTitleBarRenderer().isInsideMinimizeButton(pointer)) {
            if (this.mouseDownOnButton) {
                this.changeBtnState(BtnState.HOVER_SELECTED, 2);
            } else {
                this.changeBtnState(BtnState.HOVER, 2);
            }
            insideAButton = true;
        }
        if (!insideAButton) {
            this.mouseDownOnButton = false;
        }
        if (redraw = this.updateRenderer()) {
            this.redrawButtons(e);
        }
    }

    private void redrawButtons(MouseEvent e) {
        Control control = (Control)e.getSource();
        if (!control.isDisposed()) {
            Rectangle buttonBounds = this.getTitleBarRenderer().getAllButtonsBounds();
            control.redraw(buttonBounds.x, buttonBounds.y, buttonBounds.width, buttonBounds.height, false);
        }
    }

    private boolean updateRenderer() {
        boolean changed = false;
        int i = 0;
        while (i < this.btnStates.length) {
            boolean hover = this.btnStates[i] == BtnState.HOVER;
            boolean pressed = this.btnStates[i] == BtnState.HOVER_SELECTED && this.mouseDownOnButton;
            switch (i) {
                case 0: {
                    if (this.getTitleBarRenderer().isCloseButtonHover() != hover) {
                        this.getTitleBarRenderer().setCloseButtonHover(hover);
                        changed = true;
                    }
                    if (this.getTitleBarRenderer().isCloseButtonPressed() == pressed) break;
                    this.getTitleBarRenderer().setCloseButtonPressed(pressed);
                    changed = true;
                    break;
                }
                case 1: {
                    if (this.getTitleBarRenderer().isMaximizedButtonHover() != hover) {
                        this.getTitleBarRenderer().setMaximizedButtonHover(hover);
                        changed = true;
                    }
                    if (this.getTitleBarRenderer().isMaximizedButtonPressed() == pressed) break;
                    this.getTitleBarRenderer().setMaximizedButtonPressed(pressed);
                    changed = true;
                    break;
                }
                case 2: {
                    if (this.getTitleBarRenderer().isMinimizedButtonHover() != hover) {
                        this.getTitleBarRenderer().setMinimizedButtonHover(hover);
                        changed = true;
                    }
                    if (this.getTitleBarRenderer().isMinimizedButtonPressed() == pressed) break;
                    this.getTitleBarRenderer().setMinimizedButtonPressed(pressed);
                    changed = true;
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Illegal button index: " + i));
                }
            }
            ++i;
        }
        return changed;
    }

    private void updateCursor(MouseEvent e) {
        Control control = (Control)e.getSource();
        if (!control.isDisposed()) {
            Point pointer = new Point(e.x, e.y);
            if (this.moveInside && this.getTitleBarRenderer().isInsideMoveArea(pointer)) {
                if (this.move) {
                    this.showGrabCursor(control);
                } else {
                    this.showHandCursor(control);
                }
            } else if (!this.move) {
                this.showDefaultCursor(control);
            }
        }
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
        this.mouseDownOnButton = true;
        this.updateButtonStates(e);
        if (!this.mouseDownOnButton) {
            Point pointer = new Point(e.x, e.y);
            if (this.getTitleBarRenderer().isInsideMoveArea(pointer)) {
                this.move = true;
                this.moveStartPoint = pointer;
            } else {
                this.move = false;
            }
        }
        this.updateCursor(e);
    }

    public void mouseUp(MouseEvent e) {
        Control control;
        Shell shell;
        Point pointer = new Point(e.x, e.y);
        if (this.mouseDownOnButton && e.getSource() instanceof Control && (shell = this.getShell(control = (Control)e.getSource())) != null) {
            if (this.getTitleBarRenderer().isInsideCloseButton(pointer)) {
                if (this.btnStates[0] == BtnState.HOVER_SELECTED) {
                    shell.close();
                }
            } else if (this.getTitleBarRenderer().isInsideMaximizeButton(pointer)) {
                if (this.btnStates[1] == BtnState.HOVER_SELECTED) {
                    SHELL_HELPER.maximizeRestore();
                }
            } else if (this.getTitleBarRenderer().isInsideMinimizeButton(pointer) && this.btnStates[2] == BtnState.HOVER_SELECTED) {
                shell.setMinimized(true);
            }
        }
        this.mouseDownOnButton = false;
        this.updateButtonStates(e);
        this.move = false;
        this.updateCursor(e);
    }

    public void mouseEnter(MouseEvent e) {
        this.updateButtonStates(e);
        this.moveInside = true;
        this.move = false;
        this.updateCursor(e);
    }

    public void mouseExit(MouseEvent e) {
        this.updateButtonStates(e);
        this.moveInside = false;
        this.move = false;
        this.updateCursor(e);
    }

    public void mouseHover(MouseEvent e) {
    }

    public void mouseMove(MouseEvent e) {
        this.updateButtonStates(e);
        if (this.move) {
            this.move(e);
        }
        this.updateCursor(e);
    }

    private void move(MouseEvent e) {
        boolean wasMaximized = ShellHelper.isShellMaximzed();
        Point moveEndPoint = new Point(e.x, e.y);
        Control control = (Control)e.getSource();
        Shell shell = this.getShell(control);
        int xMove = this.moveStartPoint.x - moveEndPoint.x;
        int yMove = this.moveStartPoint.y - moveEndPoint.y;
        int x = shell.getLocation().x - xMove;
        int y = shell.getLocation().y - yMove;
        shell.setLocation(x, y);
        if (wasMaximized != ShellHelper.isShellMaximzed()) {
            this.redrawButtons(e);
        }
    }

    private Shell getShell(Control control) {
        Shell result = null;
        while (control != null && result == null) {
            if (control instanceof Shell) {
                result = (Shell)control;
                continue;
            }
            control = control.getParent();
        }
        return result;
    }

    private void showHandCursor(Control control) {
        if (this.handCursor == null) {
            this.handCursor = this.createHandCursor(control.getDisplay());
        }
        this.setCursor(control, this.handCursor);
    }

    private void showGrabCursor(Control control) {
        if (this.grabCursor == null) {
            this.grabCursor = this.createGrabCursor(control.getDisplay());
        }
        this.setCursor(control, this.grabCursor);
    }

    private void showDefaultCursor(Control control) {
        if (this.defaultCursor == null) {
            this.defaultCursor = new Cursor((Device)control.getDisplay(), 0);
        }
        this.setCursor(control, this.defaultCursor);
    }

    private void setCursor(Control control, Cursor cursor) {
        if (!SwtUtilities.isDisposed((Widget)control) && cursor != null && control.getCursor() != cursor) {
            control.setCursor(cursor);
        }
    }

    private Cursor createHandCursor(Display display) {
        Image image = LnfManager.getLnf().getImage("TitlelessShell.handImage");
        return SWTFacade.getDefault().createCursor(display, image, 21);
    }

    private Cursor createGrabCursor(Display display) {
        Image image = LnfManager.getLnf().getImage("TitlelessShell.grabImage");
        return SWTFacade.getDefault().createCursor(display, image, 21);
    }

    public void dispose() {
        SwtUtilities.dispose((Resource)this.handCursor);
        SwtUtilities.dispose((Resource)this.grabCursor);
        SwtUtilities.dispose((Resource)this.defaultCursor);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum BtnState {
        NONE,
        HOVER,
        HOVER_SELECTED;

    }
}

