/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.swt;

import org.eclipse.core.runtime.Assert;
import org.eclipse.riena.ui.swt.facades.SWTFacade;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

class EventForwarder
implements Listener {
    private static final SWTFacade SWT_FACADE = SWTFacade.getDefault();
    private final Control source;
    private final Control target;

    EventForwarder(Control source, Control target) {
        int[] eventTypes;
        Assert.isNotNull((Object)target);
        int[] nArray = eventTypes = new int[]{15, 16, 35, 29, 8, 5, 6, 7, 32, 37, 3, 31};
        int n = eventTypes.length;
        int n2 = 0;
        while (n2 < n) {
            int type = nArray[n2];
            source.addListener(type, (Listener)this);
            ++n2;
        }
        this.source = source;
        this.target = target;
    }

    public void handleEvent(Event event) {
        if (this.target.isDisposed()) {
            return;
        }
        switch (event.type) {
            case 15: 
            case 16: 
            case 35: {
                this.notifyTarget(this.createEvent(event));
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 29: 
            case 32: 
            case 37: {
                this.notifyTarget(this.createEvent(event));
                event.type = 0;
                break;
            }
            case 3: {
                Event e = this.createEvent(event);
                this.notifyTarget(e);
                event.doit = e.doit;
                break;
            }
            case 31: {
                Event e = this.createEvent(event);
                this.notifyTarget(e);
                event.doit = e.doit;
                event.detail = e.detail;
            }
        }
    }

    private Event createEvent(Event event) {
        Event result = new Event();
        result.display = event.display;
        result.widget = this.target;
        result.type = event.type;
        result.detail = event.detail;
        Point pt = this.getDisplay().map(this.source, this.target, event.x, event.y);
        event.x = pt.x;
        event.y = pt.y;
        result.count = event.count;
        result.time = event.time;
        result.button = event.button;
        result.character = event.character;
        result.keyCode = event.keyCode;
        SWT_FACADE.copyEventKeyLocation(event, result);
        result.stateMask = event.stateMask;
        result.doit = event.doit;
        result.data = event.data;
        return result;
    }

    private Display getDisplay() {
        return this.source.getDisplay();
    }

    private void notifyTarget(Event event) {
        this.target.notifyListeners(event.type, event);
    }
}

