/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.communication.core.progressmonitor;

import org.eclipse.riena.communication.core.progressmonitor.IRemoteProgressMonitor;
import org.eclipse.riena.communication.core.progressmonitor.IRemoteProgressMonitorList;
import org.eclipse.riena.communication.core.progressmonitor.RemoteProgressMonitorEvent;
import org.eclipse.riena.core.util.ListenerList;

public class ProgressMonitorListImpl
implements IRemoteProgressMonitorList {
    private final ListenerList<IRemoteProgressMonitor> progressMonitorList = new ListenerList(ListenerList.Mode.IDENTITY, IRemoteProgressMonitor.class);

    public ProgressMonitorListImpl(IRemoteProgressMonitor[] progressMonitors) {
        IRemoteProgressMonitor[] iRemoteProgressMonitorArray = progressMonitors;
        int n = progressMonitors.length;
        int n2 = 0;
        while (n2 < n) {
            IRemoteProgressMonitor listener = iRemoteProgressMonitorArray[n2];
            this.progressMonitorList.add((Object)listener);
            ++n2;
        }
    }

    public void fireReadEvent(int totalBytes, int bytesRead) {
        RemoteProgressMonitorEvent remoteProgressMonitorEvent = new RemoteProgressMonitorEvent(totalBytes, bytesRead);
        IRemoteProgressMonitor[] iRemoteProgressMonitorArray = (IRemoteProgressMonitor[])this.progressMonitorList.getListeners();
        int n = iRemoteProgressMonitorArray.length;
        int n2 = 0;
        while (n2 < n) {
            IRemoteProgressMonitor listener = iRemoteProgressMonitorArray[n2];
            listener.response(remoteProgressMonitorEvent);
            ++n2;
        }
    }

    public void fireWriteEvent(int totalBytes, int bytesSent) {
        RemoteProgressMonitorEvent remoteProgressMonitorEvent = new RemoteProgressMonitorEvent(totalBytes, bytesSent);
        IRemoteProgressMonitor[] iRemoteProgressMonitorArray = (IRemoteProgressMonitor[])this.progressMonitorList.getListeners();
        int n = iRemoteProgressMonitorArray.length;
        int n2 = 0;
        while (n2 < n) {
            IRemoteProgressMonitor listener = iRemoteProgressMonitorArray[n2];
            listener.request(remoteProgressMonitorEvent);
            ++n2;
        }
    }

    public void fireStartEvent() {
        IRemoteProgressMonitor[] iRemoteProgressMonitorArray = (IRemoteProgressMonitor[])this.progressMonitorList.getListeners();
        int n = iRemoteProgressMonitorArray.length;
        int n2 = 0;
        while (n2 < n) {
            IRemoteProgressMonitor listener = iRemoteProgressMonitorArray[n2];
            listener.start();
            ++n2;
        }
    }

    public void fireEndEvent(int totalBytes) {
        IRemoteProgressMonitor[] iRemoteProgressMonitorArray = (IRemoteProgressMonitor[])this.progressMonitorList.getListeners();
        int n = iRemoteProgressMonitorArray.length;
        int n2 = 0;
        while (n2 < n) {
            IRemoteProgressMonitor listener = iRemoteProgressMonitorArray[n2];
            listener.end();
            ++n2;
        }
    }
}

