/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.communication.core.proxyselector;

import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.SocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Scanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProxySelectorUtils {
    private static final int PROXY_DEFAULT_PORT = 80;
    private static final int HTTPPROXY_DEFAULT_PORT = 80;
    private static final int HTTPSPROXY_DEFAULT_PORT = 443;
    private static final int SOCKSPROXY_DEFAULT_PORT = 1080;
    public static final List<Proxy> NO_PROXY_LIST = Collections.singletonList(Proxy.NO_PROXY);
    public static final List<Proxy> EMPTY_PROXY_LIST = Collections.emptyList();

    private ProxySelectorUtils() {
    }

    public static void fillProxies(String proxyDefinitions, List<Proxy> universalProxies, Map<String, List<Proxy>> protocolSpecificProxies) {
        Scanner scanner = new Scanner(proxyDefinitions);
        scanner.useDelimiter(",");
        while (scanner.hasNext()) {
            ProxySelectorUtils.fillProxy(scanner.next(), universalProxies, protocolSpecificProxies);
        }
    }

    public static void fillProxy(String proxyDefinition, List<Proxy> universalProxies, Map<String, List<Proxy>> protocolSpecificProxies) {
        String protocol = null;
        String host = null;
        int port = 0;
        int urlStart = 0;
        if (proxyDefinition.indexOf("=") != -1) {
            protocol = proxyDefinition.substring(0, proxyDefinition.indexOf("="));
            urlStart = proxyDefinition.indexOf("=") + 1;
        }
        try {
            String augmentedURI = proxyDefinition.substring(urlStart);
            if (augmentedURI.indexOf("://") == -1) {
                augmentedURI = "http://" + augmentedURI;
            }
            URI uri = new URI(augmentedURI);
            host = uri.getHost();
            port = uri.getPort() > 0 ? uri.getPort() : ProxySelectorUtils.getProxyDefaultPort(protocol);
        }
        catch (Exception ex) {
            throw new IllegalFormatException("not a valid proxy definition: '" + proxyDefinition + "'.", ex);
        }
        if (host == null) {
            throw new IllegalFormatException("not a valid proxy definition: '" + proxyDefinition + "'.");
        }
        if (protocol == null) {
            universalProxies.add(ProxySelectorUtils.createProxy(Proxy.Type.HTTP, host, port));
        } else {
            ProxySelectorUtils.addProtocolSpecificProxy(protocolSpecificProxies, protocol, ProxySelectorUtils.createProxy(ProxySelectorUtils.resolveProxyType(protocol), host, port));
        }
    }

    public static void resort(Collection<Proxy> proxies, Collection<Proxy> failedProxies) {
        if (failedProxies.isEmpty()) {
            return;
        }
        ArrayList<Proxy> moveToTheEnd = new ArrayList<Proxy>(failedProxies.size());
        for (Proxy badProxy : failedProxies) {
            if (!proxies.remove(badProxy)) continue;
            moveToTheEnd.add(badProxy);
        }
        proxies.addAll(moveToTheEnd);
    }

    private static int getProxyDefaultPort(String protocol) {
        if (protocol == null) {
            return 80;
        }
        if ("http".equalsIgnoreCase(protocol)) {
            return 80;
        }
        if ("https".equalsIgnoreCase(protocol)) {
            return 443;
        }
        if ("socks".equalsIgnoreCase(protocol)) {
            return 1080;
        }
        if ("socket".equalsIgnoreCase(protocol)) {
            return 1080;
        }
        return 80;
    }

    private static void addProtocolSpecificProxy(Map<String, List<Proxy>> protocolSpecificProxies, String protocol, Proxy proxy) {
        List<Proxy> list = protocolSpecificProxies.get(protocol);
        if (list == null) {
            list = new ArrayList<Proxy>();
            protocolSpecificProxies.put(protocol, list);
        }
        list.add(proxy);
    }

    public static Proxy createProxy(Proxy.Type type, String host, int port) {
        return new Proxy(type, InetSocketAddress.createUnresolved(host, port));
    }

    public static Proxy.Type resolveProxyType(String protocol) {
        if (protocol != null && (protocol.equalsIgnoreCase("socks") || protocol.equalsIgnoreCase("socket"))) {
            return Proxy.Type.SOCKS;
        }
        return Proxy.Type.HTTP;
    }

    public static Proxy createProxy(String scheme, SocketAddress sa) {
        Proxy.Type type = ProxySelectorUtils.resolveProxyType(scheme);
        return new Proxy(type, sa);
    }

    public static class IllegalFormatException
    extends IllegalArgumentException {
        private static final long serialVersionUID = 3597432896264559897L;

        public IllegalFormatException(String message, Throwable throwable) {
            super(message, throwable);
        }

        public IllegalFormatException(String message) {
            super(message);
        }
    }
}

