/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core;

import java.io.File;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.log.Logger;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.riena.core.Log4r;
import org.eclipse.riena.core.util.StringUtils;
import org.osgi.framework.Bundle;

public final class RienaLocations {
    @Deprecated
    public static final String RIENA_NAME = "riena";
    private static final Logger LOGGER = Log4r.getLogger(RienaLocations.class);

    private RienaLocations() {
    }

    public static File getDataArea() {
        Location instanceAreaLocation = Platform.getInstanceLocation();
        if (instanceAreaLocation != null && instanceAreaLocation.getURL() != null) {
            LOGGER.log(4, "Platform Instance Location: " + instanceAreaLocation.getURL().toString());
            return RienaLocations.existingOrNewDirectory(new File(instanceAreaLocation.getURL().getFile()));
        }
        throw new RuntimeException("No instance area could be found! Only set osgi.instance.area to @noDefault if you specify one explicitly!");
    }

    public static File getDataArea(Bundle bundle) {
        Assert.isLegal((bundle != null ? 1 : 0) != 0, (String)"bundle must not be null.");
        String symbolicName = bundle.getSymbolicName();
        Assert.isLegal((boolean)StringUtils.isGiven(symbolicName), (String)"no symbolic name for bundle.");
        return RienaLocations.existingOrNewDirectory(new File(RienaLocations.getDataArea(), symbolicName));
    }

    public static File getUserArea() {
        return new File(System.getProperty("user.home"));
    }

    private static File existingOrNewDirectory(File location) {
        if (location.isDirectory()) {
            LOGGER.log(4, "Found directory at " + location.getAbsolutePath());
            return location;
        }
        LOGGER.log(4, String.valueOf(location.getAbsolutePath()) + " is not a directory.");
        File tempFile = location;
        while (tempFile.getParentFile() != null) {
            if (!(tempFile = tempFile.getParentFile()).canWrite()) break;
        }
        String fallbackLocation = String.valueOf(System.getProperty("user.home")) + "/." + System.getProperty("eclipse.product");
        boolean created = location.mkdirs();
        if (!created) {
            LOGGER.log(4, "Could not create; using ${user.home}/.${eclipse.product} as fallback");
            location = new File(fallbackLocation);
            created = location.mkdirs();
            if (!created) {
                throw new RuntimeException("Could not create fallback instance area at '" + location.getAbsolutePath() + "'. Giving up.");
            }
        }
        Assert.isLegal((boolean)created, (String)"Missing instance area could not be created.");
        LOGGER.log(4, "Created instance area directory at " + location.getAbsolutePath());
        return location;
    }
}

