/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core.cache;

import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.equinox.log.Logger;
import org.eclipse.riena.core.IRienaActivator;
import org.eclipse.riena.core.Log4r;
import org.eclipse.riena.core.cache.GenericObjectCache;
import org.eclipse.riena.core.cache.IGenericObjectCache;
import org.eclipse.riena.internal.core.Activator;
import org.eclipse.riena.internal.core.cache.ICacheEntry;
import org.eclipse.riena.internal.core.cache.SimpleCacheEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LRUCache<K, V>
implements IGenericObjectCache<K, V> {
    private static final Logger LOGGER = Log4r.getLogger((IRienaActivator)Activator.getDefault(), GenericObjectCache.class);
    private LinkedHashMap<K, ICacheEntry<K, V>> lruMap = null;
    private long timeout;
    private int minimumSize;
    private int statHit;
    private int statNotFound;
    private int statTimeout;
    private static int statDisplayCount;
    private String name = "LRUCache : ";

    public LRUCache() {
        LOGGER.log(3, "creating new LRUCache instance");
        this.lruMap = new LinkedHashMap();
        this.setTimeout(60000);
    }

    @Override
    public void setName(String name) {
        this.name = String.valueOf(name) + " : ";
    }

    @Override
    public void setTimeout(int milliseconds) {
        LOGGER.log(3, "setTimeout = " + milliseconds);
        this.timeout = milliseconds;
    }

    @Override
    public int getTimeout() {
        return (int)this.timeout;
    }

    @Override
    public synchronized V get(K key) {
        LOGGER.log(4, "get = " + key);
        ICacheEntry<K, V> entry = this.lruMap.get(key);
        if (entry == null) {
            ++this.statNotFound;
            this.printStat();
            return null;
        }
        long timePassed = System.currentTimeMillis() - entry.getTimestamp();
        if (timePassed < this.timeout) {
            ++this.statHit;
            this.printStat();
            return entry.getValue();
        }
        this.remove(key);
        ++this.statTimeout;
        this.printStat();
        return null;
    }

    private void printStat() {
        if (++statDisplayCount > 100) {
            LOGGER.log(3, String.valueOf(this.name) + "Hit / NotFound / Timeout " + this.statHit + " / " + this.statNotFound + " / " + this.statTimeout);
            statDisplayCount = 0;
        }
    }

    @Override
    public String getStatistic() {
        return String.valueOf(this.name) + "Hit / NotFound / Miss / Timeout " + this.statHit + " / " + this.statNotFound + " / " + this.statTimeout;
    }

    @Override
    public synchronized void put(K key, V value) {
        LOGGER.log(4, "put = " + key + ", " + value);
        this.lruMap.put(key, new SimpleCacheEntry<K, V>(value, key));
    }

    @Override
    public synchronized void clear() {
        LOGGER.log(4, "clear");
        this.lruMap.clear();
    }

    @Override
    public synchronized void remove(K key) {
        LOGGER.log(4, "remove = " + key);
        this.lruMap.remove(key);
    }

    @Override
    public synchronized int size() {
        LOGGER.log(4, "size <= " + this.lruMap.size());
        return this.lruMap.size();
    }

    @Override
    public int getSize() {
        return this.size();
    }

    @Override
    public synchronized void setMinimumSize(int minSize) {
        LOGGER.log(3, "setMinSize = " + minSize);
        this.minimumSize = minSize;
        this.lruMap = new LRUHashMap(minSize);
    }

    @Override
    public synchronized int getMinimumSize() {
        return this.minimumSize;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LRUHashMap<K, V>
    extends LinkedHashMap<K, ICacheEntry<K, V>> {
        private final int minSize;
        private static final long serialVersionUID = 6499327049035525641L;

        public LRUHashMap(int minSize) {
            super(minSize, 0.75f, true);
            this.minSize = minSize;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, ICacheEntry<K, V>> eldest) {
            return this.size() > this.minSize;
        }
    }
}

