/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.model.NavigationModelFailure;

public abstract class NodePositioner {
    public static final String POSITIONING_ORDINALITY_KEY = String.valueOf(NodePositioner.class.getName()) + "positioning-ordinality-key";
    protected Map<String, Object> context = new HashMap<String, Object>();
    public static final NodePositioner ADD_BEGINNING = new NodePositioner(){
        private final NodePositioner delegate = 1.indexed(0);

        public void addChildToParent(INavigationNode parent, INavigationNode child) {
            this.delegate.addChildToParent(parent, child);
        }
    };
    public static final NodePositioner ADD_END = new NodePositioner(){

        public void addChildToParent(INavigationNode parent, INavigationNode child) {
            NodePositioner.assertMode(parent, Mode.FIXED);
            parent.addChild(child);
        }
    };

    public static final NodePositioner indexed(final int index) {
        return new NodePositioner(){

            public void addChildToParent(INavigationNode parent, INavigationNode child) {
                NodePositioner.assertMode(parent, Mode.FIXED);
                if (index < 0) {
                    throw new NavigationModelFailure("Cannot add child " + child + " to parent " + parent + " at index " + index + ". Index must be >= 0");
                }
                if (index >= parent.getChildren().size()) {
                    ADD_END.addChildToParent(parent, child);
                    return;
                }
                parent.addChild(index, child);
            }
        };
    }

    public static final NodePositioner ordinal(final int ordinality) {
        return new NodePositioner(){

            public void addChildToParent(INavigationNode parent, INavigationNode child) {
                NodePositioner.assertMode(parent, Mode.ORDINAL);
                child.setContext(POSITIONING_ORDINALITY_KEY, ordinality);
                if (parent.getChildren().size() == 0) {
                    parent.addChild(child);
                    return;
                }
                List oldChildren = parent.getChildren();
                int ix = 0;
                while (ix < oldChildren.size() && ordinality >= (Integer)((INavigationNode)oldChildren.get(ix)).getContext(POSITIONING_ORDINALITY_KEY)) {
                    ++ix;
                }
                if (ix == oldChildren.size()) {
                    parent.addChild(child);
                } else {
                    parent.addChild(ix, child);
                }
            }
        };
    }

    private static void assertMode(INavigationNode node, Mode expected) {
        Mode currentMode;
        if (node.getChildren().size() == 0) {
            return;
        }
        INavigationNode firstChild = (INavigationNode)node.getChildren().get(0);
        Mode mode = currentMode = firstChild.getContext(POSITIONING_ORDINALITY_KEY) != null ? Mode.ORDINAL : Mode.FIXED;
        if (!currentMode.equals((Object)expected)) {
            throw new NavigationModelFailure("Node " + node + " cannot be added with NodePositioningMode " + (Object)((Object)expected) + " as the current mode is " + (Object)((Object)currentMode));
        }
    }

    public abstract void addChildToParent(INavigationNode var1, INavigationNode var2);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Mode {
        FIXED,
        ORDINAL;

    }
}

