/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.listener;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.riena.core.marker.IMarker;
import org.eclipse.riena.navigation.IApplicationNode;
import org.eclipse.riena.navigation.IModuleGroupNode;
import org.eclipse.riena.navigation.IModuleNode;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.ISubApplicationNode;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.NavigationNodeId;
import org.eclipse.riena.navigation.listener.ApplicationNodeListener;
import org.eclipse.riena.navigation.listener.IApplicationNodeListener;
import org.eclipse.riena.navigation.listener.IModuleGroupNodeListener;
import org.eclipse.riena.navigation.listener.IModuleNodeListener;
import org.eclipse.riena.navigation.listener.ISubApplicationNodeListener;
import org.eclipse.riena.navigation.listener.ISubModuleNodeListener;
import org.eclipse.riena.navigation.listener.ModuleGroupNodeListener;
import org.eclipse.riena.navigation.listener.ModuleNodeListener;
import org.eclipse.riena.navigation.listener.SubApplicationNodeListener;
import org.eclipse.riena.navigation.listener.SubModuleNodeListener;
import org.eclipse.riena.ui.filter.IUIFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NavigationTreeObserver {
    private final IApplicationNodeListener applicationNodeListener = new MyApplicationNodeListener();
    private final Set<IApplicationNodeListener> applicationNodeListeners = new HashSet<IApplicationNodeListener>();
    private final ISubApplicationNodeListener subApplicationListener = new MySubApplicationNodeListener();
    private final Set<ISubApplicationNodeListener> subApplicationListeners = new HashSet<ISubApplicationNodeListener>();
    private final IModuleGroupNodeListener moduleGroupNodeListener = new MyModuleGroupNodeListener();
    private final Set<IModuleGroupNodeListener> moduleGroupNodeListeners = new HashSet<IModuleGroupNodeListener>();
    private final IModuleNodeListener moduleNodeListener = new MyModuleNodeListener();
    private final Set<IModuleNodeListener> moduleNodeListeners = new HashSet<IModuleNodeListener>();
    private final ISubModuleNodeListener subModuleNodeListener = new MySubModuleNodeListener();
    private final Set<ISubModuleNodeListener> subModuleNodeListeners = new HashSet<ISubModuleNodeListener>();

    public void addListener(IApplicationNodeListener pListener) {
        this.applicationNodeListeners.add(pListener);
    }

    public void removeListener(IApplicationNodeListener pListener) {
        this.applicationNodeListeners.remove(pListener);
    }

    public void addListener(ISubApplicationNodeListener pListener) {
        this.subApplicationListeners.add(pListener);
    }

    public void removeListener(ISubApplicationNodeListener pListener) {
        this.subApplicationListeners.remove(pListener);
    }

    public void addListener(IModuleGroupNodeListener pListener) {
        this.moduleGroupNodeListeners.add(pListener);
    }

    public void removeListener(IModuleGroupNodeListener pListener) {
        this.moduleGroupNodeListeners.remove(pListener);
    }

    public void addListener(IModuleNodeListener pListener) {
        this.moduleNodeListeners.add(pListener);
    }

    public void removeListener(IModuleNodeListener pListener) {
        this.moduleNodeListeners.remove(pListener);
    }

    public void addListener(ISubModuleNodeListener pListener) {
        this.subModuleNodeListeners.add(pListener);
    }

    public void removeListener(ISubModuleNodeListener pListener) {
        this.subModuleNodeListeners.remove(pListener);
    }

    private Set<IApplicationNodeListener> getApplicationNodeListeners() {
        return this.applicationNodeListeners;
    }

    private Set<ISubApplicationNodeListener> getSubApplicationListeners() {
        return this.subApplicationListeners;
    }

    private Set<IModuleGroupNodeListener> getModuleGroupNodeListeners() {
        return this.moduleGroupNodeListeners;
    }

    private Set<IModuleNodeListener> getModuleNodeListeners() {
        return this.moduleNodeListeners;
    }

    private Set<ISubModuleNodeListener> getSubModuleNodeListeners() {
        return this.subModuleNodeListeners;
    }

    public void addListenerTo(IApplicationNode pApplicationNode) {
        pApplicationNode.addListener(this.applicationNodeListener);
        for (ISubApplicationNode next : pApplicationNode.getChildren()) {
            this.addListenerTo(next);
        }
    }

    public void addListenerTo(ISubApplicationNode pSubApplication) {
        pSubApplication.addListener(this.subApplicationListener);
        for (IModuleGroupNode next : pSubApplication.getChildren()) {
            this.addListenerTo(next);
        }
    }

    public void addListenerTo(IModuleGroupNode pModuleGroupNode) {
        pModuleGroupNode.addListener(this.moduleGroupNodeListener);
        for (IModuleNode next : pModuleGroupNode.getChildren()) {
            this.addListenerTo(next);
        }
    }

    public void addListenerTo(IModuleNode pModuleNode) {
        pModuleNode.addListener(this.moduleNodeListener);
        for (ISubModuleNode next : pModuleNode.getChildren()) {
            this.addListenerTo(next);
        }
    }

    public void addListenerTo(ISubModuleNode pSubModuleNode) {
        pSubModuleNode.addListener(this.subModuleNodeListener);
        for (ISubModuleNode next : pSubModuleNode.getChildren()) {
            this.addListenerTo(next);
        }
    }

    public void removeListenerFrom(IApplicationNode pApplicationNode) {
        for (ISubApplicationNode next : pApplicationNode.getChildren()) {
            this.removeListenerFrom(next);
        }
        pApplicationNode.removeListener(this.applicationNodeListener);
    }

    public void removeListenerFrom(ISubApplicationNode pSubApplication) {
        for (IModuleGroupNode next : pSubApplication.getChildren()) {
            this.removeListenerFrom(next);
        }
        pSubApplication.removeListener(this.subApplicationListener);
    }

    public void removeListenerFrom(IModuleGroupNode pModuleGroupNode) {
        for (IModuleNode next : pModuleGroupNode.getChildren()) {
            this.removeListenerFrom(next);
        }
        pModuleGroupNode.removeListener(this.moduleGroupNodeListener);
    }

    public void removeListenerFrom(IModuleNode pModuleNode) {
        for (ISubModuleNode next : pModuleNode.getChildren()) {
            this.removeListenerFrom(next);
        }
        pModuleNode.removeListener(this.moduleNodeListener);
    }

    public void removeListenerFrom(ISubModuleNode pSubModuleNode) {
        for (ISubModuleNode next : pSubModuleNode.getChildren()) {
            this.removeListenerFrom(next);
        }
        pSubModuleNode.removeListener(this.subModuleNodeListener);
    }

    private class MyApplicationNodeListener
    extends ApplicationNodeListener {
        private MyApplicationNodeListener() {
        }

        public void filterAdded(IApplicationNode source, IUIFilter filter) {
            super.filterAdded(source, filter);
            for (IApplicationNodeListener next : NavigationTreeObserver.this.getApplicationNodeListeners()) {
                next.filterAdded(source, filter);
            }
        }

        public void filterRemoved(IApplicationNode source, IUIFilter filter) {
            super.filterRemoved(source, filter);
            for (IApplicationNodeListener next : NavigationTreeObserver.this.getApplicationNodeListeners()) {
                next.filterRemoved(source, filter);
            }
        }

        public void activated(IApplicationNode source) {
            super.activated(source);
            for (IApplicationNodeListener next : NavigationTreeObserver.this.getApplicationNodeListeners()) {
                next.activated(source);
            }
        }

        public void beforeActivated(IApplicationNode source) {
            super.beforeActivated(source);
            for (IApplicationNodeListener next : NavigationTreeObserver.this.getApplicationNodeListeners()) {
                next.beforeActivated(source);
            }
        }

        public void block(IApplicationNode source, boolean block) {
            super.block(source, block);
            for (IApplicationNodeListener next : NavigationTreeObserver.this.getApplicationNodeListeners()) {
                next.block(source, block);
            }
        }

        public void afterActivated(IApplicationNode source) {
            super.afterActivated(source);
            for (IApplicationNodeListener next : NavigationTreeObserver.this.getApplicationNodeListeners()) {
                next.afterActivated(source);
            }
        }

        public void deactivated(IApplicationNode source) {
            super.deactivated(source);
            for (IApplicationNodeListener next : NavigationTreeObserver.this.getApplicationNodeListeners()) {
                next.deactivated(source);
            }
        }

        public void beforeDeactivated(IApplicationNode source) {
            super.beforeDeactivated(source);
            for (IApplicationNodeListener next : NavigationTreeObserver.this.getApplicationNodeListeners()) {
                next.beforeDeactivated(source);
            }
        }

        public void afterDeactivated(IApplicationNode source) {
            super.afterDeactivated(source);
            for (IApplicationNodeListener next : NavigationTreeObserver.this.getApplicationNodeListeners()) {
                next.afterDeactivated(source);
            }
        }

        public void disposed(IApplicationNode source) {
            super.disposed(source);
            for (IApplicationNodeListener next : NavigationTreeObserver.this.getApplicationNodeListeners()) {
                next.disposed(source);
            }
        }

        public void beforeDisposed(IApplicationNode source) {
            super.beforeDisposed(source);
            for (IApplicationNodeListener next : NavigationTreeObserver.this.getApplicationNodeListeners()) {
                next.beforeDisposed(source);
            }
        }

        public void afterDisposed(IApplicationNode source) {
            super.afterDisposed(source);
            for (IApplicationNodeListener next : NavigationTreeObserver.this.getApplicationNodeListeners()) {
                next.afterDisposed(source);
            }
        }

        public void childAdded(IApplicationNode source, ISubApplicationNode childAdded) {
            super.childAdded(source, childAdded);
            NavigationTreeObserver.this.addListenerTo(childAdded);
            for (IApplicationNodeListener next : NavigationTreeObserver.this.getApplicationNodeListeners()) {
                next.childAdded(source, childAdded);
            }
        }

        public void childRemoved(IApplicationNode source, ISubApplicationNode childRemoved) {
            super.childRemoved(source, childRemoved);
            NavigationTreeObserver.this.removeListenerFrom(childRemoved);
            for (IApplicationNodeListener next : NavigationTreeObserver.this.getApplicationNodeListeners()) {
                next.childRemoved(source, childRemoved);
            }
        }

        public void expandedChanged(IApplicationNode source) {
            super.expandedChanged(source);
            for (IApplicationNodeListener next : NavigationTreeObserver.this.getApplicationNodeListeners()) {
                next.expandedChanged(source);
            }
        }

        public void labelChanged(IApplicationNode source) {
            super.labelChanged(source);
            for (IApplicationNodeListener next : NavigationTreeObserver.this.getApplicationNodeListeners()) {
                next.labelChanged(source);
            }
        }

        public void markerChanged(IApplicationNode source, IMarker marker) {
            super.markerChanged(source, marker);
            for (IApplicationNodeListener next : NavigationTreeObserver.this.getApplicationNodeListeners()) {
                next.markerChanged(source, marker);
            }
        }

        public void parentChanged(IApplicationNode source) {
            super.parentChanged(source);
            for (IApplicationNodeListener next : NavigationTreeObserver.this.getApplicationNodeListeners()) {
                next.parentChanged(source);
            }
        }

        public void presentationChanged(IApplicationNode source) {
            super.presentationChanged(source);
            for (IApplicationNodeListener next : NavigationTreeObserver.this.getApplicationNodeListeners()) {
                next.presentationChanged(source);
            }
        }

        public void selectedChanged(IApplicationNode source) {
            super.selectedChanged(source);
            for (IApplicationNodeListener next : NavigationTreeObserver.this.getApplicationNodeListeners()) {
                next.selectedChanged(source);
            }
        }

        public void stateChanged(IApplicationNode source, INavigationNode.State oldState, INavigationNode.State newState) {
            super.stateChanged(source, oldState, newState);
            for (IApplicationNodeListener next : NavigationTreeObserver.this.getApplicationNodeListeners()) {
                next.stateChanged(source, oldState, newState);
            }
        }

        public void nodeIdChange(IApplicationNode source, NavigationNodeId oldId, NavigationNodeId newId) {
            super.nodeIdChange(source, oldId, newId);
            for (IApplicationNodeListener next : NavigationTreeObserver.this.getApplicationNodeListeners()) {
                next.nodeIdChange(source, oldId, newId);
            }
        }
    }

    private class MyModuleGroupNodeListener
    extends ModuleGroupNodeListener {
        private MyModuleGroupNodeListener() {
        }

        public void filterAdded(IModuleGroupNode source, IUIFilter filter) {
            super.filterAdded(source, filter);
            for (IModuleGroupNodeListener next : NavigationTreeObserver.this.getModuleGroupNodeListeners()) {
                next.filterAdded(source, filter);
            }
        }

        public void filterRemoved(IModuleGroupNode source, IUIFilter filter) {
            super.filterRemoved(source, filter);
            for (IModuleGroupNodeListener next : NavigationTreeObserver.this.getModuleGroupNodeListeners()) {
                next.filterRemoved(source, filter);
            }
        }

        public void activated(IModuleGroupNode source) {
            super.activated(source);
            for (IModuleGroupNodeListener next : NavigationTreeObserver.this.getModuleGroupNodeListeners()) {
                next.activated(source);
            }
        }

        public void block(IModuleGroupNode source, boolean block) {
            super.block(source, block);
            for (IModuleGroupNodeListener next : NavigationTreeObserver.this.getModuleGroupNodeListeners()) {
                next.block(source, block);
            }
        }

        public void beforeActivated(IModuleGroupNode source) {
            super.beforeActivated(source);
            for (IModuleGroupNodeListener next : NavigationTreeObserver.this.getModuleGroupNodeListeners()) {
                next.beforeActivated(source);
            }
        }

        public void afterActivated(IModuleGroupNode source) {
            super.afterActivated(source);
            for (IModuleGroupNodeListener next : NavigationTreeObserver.this.getModuleGroupNodeListeners()) {
                next.afterActivated(source);
            }
        }

        public void deactivated(IModuleGroupNode source) {
            super.deactivated(source);
            for (IModuleGroupNodeListener next : NavigationTreeObserver.this.getModuleGroupNodeListeners()) {
                next.deactivated(source);
            }
        }

        public void beforeDeactivated(IModuleGroupNode source) {
            super.beforeDeactivated(source);
            for (IModuleGroupNodeListener next : NavigationTreeObserver.this.getModuleGroupNodeListeners()) {
                next.beforeDeactivated(source);
            }
        }

        public void afterDeactivated(IModuleGroupNode source) {
            super.afterDeactivated(source);
            for (IModuleGroupNodeListener next : NavigationTreeObserver.this.getModuleGroupNodeListeners()) {
                next.afterDeactivated(source);
            }
        }

        public void disposed(IModuleGroupNode source) {
            super.disposed(source);
            for (IModuleGroupNodeListener next : NavigationTreeObserver.this.getModuleGroupNodeListeners()) {
                next.disposed(source);
            }
        }

        public void beforeDisposed(IModuleGroupNode source) {
            super.beforeDisposed(source);
            for (IModuleGroupNodeListener next : NavigationTreeObserver.this.getModuleGroupNodeListeners()) {
                next.beforeDisposed(source);
            }
        }

        public void afterDisposed(IModuleGroupNode source) {
            super.afterDisposed(source);
            for (IModuleGroupNodeListener next : NavigationTreeObserver.this.getModuleGroupNodeListeners()) {
                next.afterDisposed(source);
            }
        }

        public void childAdded(IModuleGroupNode source, IModuleNode childAdded) {
            super.childAdded(source, childAdded);
            NavigationTreeObserver.this.addListenerTo(childAdded);
            for (IModuleGroupNodeListener next : NavigationTreeObserver.this.getModuleGroupNodeListeners()) {
                next.childAdded(source, childAdded);
            }
        }

        public void childRemoved(IModuleGroupNode source, IModuleNode childRemoved) {
            super.childRemoved(source, childRemoved);
            NavigationTreeObserver.this.removeListenerFrom(childRemoved);
            for (IModuleGroupNodeListener next : NavigationTreeObserver.this.getModuleGroupNodeListeners()) {
                next.childRemoved(source, childRemoved);
            }
        }

        public void expandedChanged(IModuleGroupNode source) {
            super.expandedChanged(source);
            for (IModuleGroupNodeListener next : NavigationTreeObserver.this.getModuleGroupNodeListeners()) {
                next.expandedChanged(source);
            }
        }

        public void labelChanged(IModuleGroupNode source) {
            super.labelChanged(source);
            for (IModuleGroupNodeListener next : NavigationTreeObserver.this.getModuleGroupNodeListeners()) {
                next.labelChanged(source);
            }
        }

        public void markerChanged(IModuleGroupNode source, IMarker marker) {
            super.markerChanged(source, marker);
            for (IModuleGroupNodeListener next : NavigationTreeObserver.this.getModuleGroupNodeListeners()) {
                next.markerChanged(source, marker);
            }
        }

        public void parentChanged(IModuleGroupNode source) {
            super.parentChanged(source);
            for (IModuleGroupNodeListener next : NavigationTreeObserver.this.getModuleGroupNodeListeners()) {
                next.parentChanged(source);
            }
        }

        public void presentationChanged(IModuleGroupNode source) {
            super.presentationChanged(source);
            for (IModuleGroupNodeListener next : NavigationTreeObserver.this.getModuleGroupNodeListeners()) {
                next.presentationChanged(source);
            }
        }

        public void selectedChanged(IModuleGroupNode source) {
            super.selectedChanged(source);
            for (IModuleGroupNodeListener next : NavigationTreeObserver.this.getModuleGroupNodeListeners()) {
                next.selectedChanged(source);
            }
        }

        public void stateChanged(IModuleGroupNode source, INavigationNode.State oldState, INavigationNode.State newState) {
            super.stateChanged(source, oldState, newState);
            for (IModuleGroupNodeListener next : NavigationTreeObserver.this.getModuleGroupNodeListeners()) {
                next.stateChanged(source, oldState, newState);
            }
        }

        public void nodeIdChange(IModuleGroupNode source, NavigationNodeId oldId, NavigationNodeId newId) {
            super.nodeIdChange(source, oldId, newId);
            for (IModuleGroupNodeListener next : NavigationTreeObserver.this.getModuleGroupNodeListeners()) {
                next.nodeIdChange(source, oldId, newId);
            }
        }
    }

    private class MyModuleNodeListener
    extends ModuleNodeListener {
        private MyModuleNodeListener() {
        }

        public void filterAdded(IModuleNode source, IUIFilter filter) {
            super.filterAdded(source, filter);
            for (IModuleNodeListener next : NavigationTreeObserver.this.getModuleNodeListeners()) {
                next.filterAdded(source, filter);
            }
        }

        public void filterRemoved(IModuleNode source, IUIFilter filter) {
            super.filterRemoved(source, filter);
            for (IModuleNodeListener next : NavigationTreeObserver.this.getModuleNodeListeners()) {
                next.filterRemoved(source, filter);
            }
        }

        public void activated(IModuleNode source) {
            super.activated(source);
            for (IModuleNodeListener next : NavigationTreeObserver.this.getModuleNodeListeners()) {
                next.activated(source);
            }
        }

        public void block(IModuleNode source, boolean block) {
            super.block(source, block);
            for (IModuleNodeListener next : NavigationTreeObserver.this.getModuleNodeListeners()) {
                next.block(source, block);
            }
        }

        public void beforeActivated(IModuleNode source) {
            super.beforeActivated(source);
            for (IModuleNodeListener next : NavigationTreeObserver.this.getModuleNodeListeners()) {
                next.beforeActivated(source);
            }
        }

        public void afterActivated(IModuleNode source) {
            super.afterActivated(source);
            for (IModuleNodeListener next : NavigationTreeObserver.this.getModuleNodeListeners()) {
                next.afterActivated(source);
            }
        }

        public void deactivated(IModuleNode source) {
            super.deactivated(source);
            for (IModuleNodeListener next : NavigationTreeObserver.this.getModuleNodeListeners()) {
                next.deactivated(source);
            }
        }

        public void beforeDeactivated(IModuleNode source) {
            super.beforeDeactivated(source);
            for (IModuleNodeListener next : NavigationTreeObserver.this.getModuleNodeListeners()) {
                next.beforeDeactivated(source);
            }
        }

        public void afterDeactivated(IModuleNode source) {
            super.afterDeactivated(source);
            for (IModuleNodeListener next : NavigationTreeObserver.this.getModuleNodeListeners()) {
                next.afterDeactivated(source);
            }
        }

        public void disposed(IModuleNode source) {
            super.disposed(source);
            for (IModuleNodeListener next : NavigationTreeObserver.this.getModuleNodeListeners()) {
                next.disposed(source);
            }
        }

        public void beforeDisposed(IModuleNode source) {
            super.beforeDisposed(source);
            for (IModuleNodeListener next : NavigationTreeObserver.this.getModuleNodeListeners()) {
                next.beforeDisposed(source);
            }
        }

        public void afterDisposed(IModuleNode source) {
            super.afterDisposed(source);
            for (IModuleNodeListener next : NavigationTreeObserver.this.getModuleNodeListeners()) {
                next.afterDisposed(source);
            }
        }

        public void childAdded(IModuleNode source, ISubModuleNode childAdded) {
            super.childAdded(source, childAdded);
            NavigationTreeObserver.this.addListenerTo(childAdded);
            for (IModuleNodeListener next : NavigationTreeObserver.this.getModuleNodeListeners()) {
                next.childAdded(source, childAdded);
            }
        }

        public void childRemoved(IModuleNode source, ISubModuleNode childRemoved) {
            super.childRemoved(source, childRemoved);
            NavigationTreeObserver.this.removeListenerFrom(childRemoved);
            for (IModuleNodeListener next : NavigationTreeObserver.this.getModuleNodeListeners()) {
                next.childRemoved(source, childRemoved);
            }
        }

        public void expandedChanged(IModuleNode source) {
            super.expandedChanged(source);
            for (IModuleNodeListener next : NavigationTreeObserver.this.getModuleNodeListeners()) {
                next.expandedChanged(source);
            }
        }

        public void labelChanged(IModuleNode source) {
            super.labelChanged(source);
            for (IModuleNodeListener next : NavigationTreeObserver.this.getModuleNodeListeners()) {
                next.labelChanged(source);
            }
        }

        public void markerChanged(IModuleNode source, IMarker marker) {
            super.markerChanged(source, marker);
            for (IModuleNodeListener next : NavigationTreeObserver.this.getModuleNodeListeners()) {
                next.markerChanged(source, marker);
            }
        }

        public void parentChanged(IModuleNode source) {
            super.parentChanged(source);
            for (IModuleNodeListener next : NavigationTreeObserver.this.getModuleNodeListeners()) {
                next.parentChanged(source);
            }
        }

        public void presentationChanged(IModuleNode source) {
            super.presentationChanged(source);
            for (IModuleNodeListener next : NavigationTreeObserver.this.getModuleNodeListeners()) {
                next.presentationChanged(source);
            }
        }

        public void selectedChanged(IModuleNode source) {
            super.selectedChanged(source);
            for (IModuleNodeListener next : NavigationTreeObserver.this.getModuleNodeListeners()) {
                next.selectedChanged(source);
            }
        }

        public void stateChanged(IModuleNode source, INavigationNode.State oldState, INavigationNode.State newState) {
            super.stateChanged(source, oldState, newState);
            for (IModuleNodeListener next : NavigationTreeObserver.this.getModuleNodeListeners()) {
                next.stateChanged(source, oldState, newState);
            }
        }

        public void nodeIdChange(IModuleNode source, NavigationNodeId oldId, NavigationNodeId newId) {
            super.nodeIdChange(source, oldId, newId);
            for (IModuleNodeListener next : NavigationTreeObserver.this.getModuleNodeListeners()) {
                next.nodeIdChange(source, oldId, newId);
            }
        }
    }

    private class MySubApplicationNodeListener
    extends SubApplicationNodeListener {
        private MySubApplicationNodeListener() {
        }

        public void activated(ISubApplicationNode source) {
            super.activated(source);
            for (ISubApplicationNodeListener next : NavigationTreeObserver.this.getSubApplicationListeners()) {
                next.activated(source);
            }
        }

        public void filterAdded(ISubApplicationNode source, IUIFilter filter) {
            super.filterAdded(source, filter);
            for (ISubApplicationNodeListener next : NavigationTreeObserver.this.getSubApplicationListeners()) {
                next.filterAdded(source, filter);
            }
        }

        public void filterRemoved(ISubApplicationNode source, IUIFilter filter) {
            super.filterRemoved(source, filter);
            for (ISubApplicationNodeListener next : NavigationTreeObserver.this.getSubApplicationListeners()) {
                next.filterRemoved(source, filter);
            }
        }

        public void block(ISubApplicationNode source, boolean block) {
            super.block(source, block);
            for (ISubApplicationNodeListener next : NavigationTreeObserver.this.getSubApplicationListeners()) {
                next.block(source, block);
            }
        }

        public void beforeActivated(ISubApplicationNode source) {
            super.beforeActivated(source);
            for (ISubApplicationNodeListener next : NavigationTreeObserver.this.getSubApplicationListeners()) {
                next.beforeActivated(source);
            }
        }

        public void afterActivated(ISubApplicationNode source) {
            super.afterActivated(source);
            for (ISubApplicationNodeListener next : NavigationTreeObserver.this.getSubApplicationListeners()) {
                next.afterActivated(source);
            }
        }

        public void deactivated(ISubApplicationNode source) {
            super.deactivated(source);
            for (ISubApplicationNodeListener next : NavigationTreeObserver.this.getSubApplicationListeners()) {
                next.deactivated(source);
            }
        }

        public void beforeDeactivated(ISubApplicationNode source) {
            super.beforeDeactivated(source);
            for (ISubApplicationNodeListener next : NavigationTreeObserver.this.getSubApplicationListeners()) {
                next.beforeDeactivated(source);
            }
        }

        public void afterDeactivated(ISubApplicationNode source) {
            super.afterDeactivated(source);
            for (ISubApplicationNodeListener next : NavigationTreeObserver.this.getSubApplicationListeners()) {
                next.afterDeactivated(source);
            }
        }

        public void disposed(ISubApplicationNode source) {
            super.disposed(source);
            for (ISubApplicationNodeListener next : NavigationTreeObserver.this.getSubApplicationListeners()) {
                next.disposed(source);
            }
        }

        public void beforeDisposed(ISubApplicationNode source) {
            super.beforeDisposed(source);
            for (ISubApplicationNodeListener next : NavigationTreeObserver.this.getSubApplicationListeners()) {
                next.beforeDisposed(source);
            }
        }

        public void afterDisposed(ISubApplicationNode source) {
            super.afterDisposed(source);
            for (ISubApplicationNodeListener next : NavigationTreeObserver.this.getSubApplicationListeners()) {
                next.afterDisposed(source);
            }
        }

        public void childAdded(ISubApplicationNode source, IModuleGroupNode childAdded) {
            super.childAdded(source, childAdded);
            NavigationTreeObserver.this.addListenerTo(childAdded);
            for (ISubApplicationNodeListener next : NavigationTreeObserver.this.getSubApplicationListeners()) {
                next.childAdded(source, childAdded);
            }
        }

        public void childRemoved(ISubApplicationNode source, IModuleGroupNode childRemoved) {
            super.childRemoved(source, childRemoved);
            NavigationTreeObserver.this.removeListenerFrom(childRemoved);
            for (ISubApplicationNodeListener next : NavigationTreeObserver.this.getSubApplicationListeners()) {
                next.childRemoved(source, childRemoved);
            }
        }

        public void expandedChanged(ISubApplicationNode source) {
            super.expandedChanged(source);
            for (ISubApplicationNodeListener next : NavigationTreeObserver.this.getSubApplicationListeners()) {
                next.expandedChanged(source);
            }
        }

        public void labelChanged(ISubApplicationNode source) {
            super.labelChanged(source);
            for (ISubApplicationNodeListener next : NavigationTreeObserver.this.getSubApplicationListeners()) {
                next.labelChanged(source);
            }
        }

        public void markerChanged(ISubApplicationNode source, IMarker marker) {
            super.markerChanged(source, marker);
            for (ISubApplicationNodeListener next : NavigationTreeObserver.this.getSubApplicationListeners()) {
                next.markerChanged(source, marker);
            }
        }

        public void parentChanged(ISubApplicationNode source) {
            super.parentChanged(source);
            for (ISubApplicationNodeListener next : NavigationTreeObserver.this.getSubApplicationListeners()) {
                next.parentChanged(source);
            }
        }

        public void presentationChanged(ISubApplicationNode source) {
            super.presentationChanged(source);
            for (ISubApplicationNodeListener next : NavigationTreeObserver.this.getSubApplicationListeners()) {
                next.presentationChanged(source);
            }
        }

        public void selectedChanged(ISubApplicationNode source) {
            super.selectedChanged(source);
            for (ISubApplicationNodeListener next : NavigationTreeObserver.this.getSubApplicationListeners()) {
                next.selectedChanged(source);
            }
        }

        public void stateChanged(ISubApplicationNode source, INavigationNode.State oldState, INavigationNode.State newState) {
            super.stateChanged(source, oldState, newState);
            for (ISubApplicationNodeListener next : NavigationTreeObserver.this.getSubApplicationListeners()) {
                next.stateChanged(source, oldState, newState);
            }
        }

        public void nodeIdChange(ISubApplicationNode source, NavigationNodeId oldId, NavigationNodeId newId) {
            super.nodeIdChange(source, oldId, newId);
            for (ISubApplicationNodeListener next : NavigationTreeObserver.this.getSubApplicationListeners()) {
                next.nodeIdChange(source, oldId, newId);
            }
        }
    }

    private class MySubModuleNodeListener
    extends SubModuleNodeListener {
        private MySubModuleNodeListener() {
        }

        public void filterAdded(ISubModuleNode source, IUIFilter filter) {
            super.filterAdded(source, filter);
            for (ISubModuleNodeListener next : NavigationTreeObserver.this.getSubModuleNodeListeners()) {
                next.filterAdded(source, filter);
            }
        }

        public void filterRemoved(ISubModuleNode source, IUIFilter filter) {
            super.filterRemoved(source, filter);
            for (ISubModuleNodeListener next : NavigationTreeObserver.this.getSubModuleNodeListeners()) {
                next.filterRemoved(source, filter);
            }
        }

        public void block(ISubModuleNode source, boolean block) {
            super.block(source, block);
            for (ISubModuleNodeListener next : NavigationTreeObserver.this.getSubModuleNodeListeners()) {
                next.block(source, block);
            }
        }

        public void activated(ISubModuleNode source) {
            super.activated(source);
            for (ISubModuleNodeListener next : NavigationTreeObserver.this.getSubModuleNodeListeners()) {
                next.activated(source);
            }
        }

        public void beforeActivated(ISubModuleNode source) {
            super.beforeActivated(source);
            for (ISubModuleNodeListener next : NavigationTreeObserver.this.getSubModuleNodeListeners()) {
                next.beforeActivated(source);
            }
        }

        public void afterActivated(ISubModuleNode source) {
            super.afterActivated(source);
            for (ISubModuleNodeListener next : NavigationTreeObserver.this.getSubModuleNodeListeners()) {
                next.afterActivated(source);
            }
        }

        public void deactivated(ISubModuleNode source) {
            super.deactivated(source);
            for (ISubModuleNodeListener next : NavigationTreeObserver.this.getSubModuleNodeListeners()) {
                next.deactivated(source);
            }
        }

        public void beforeDeactivated(ISubModuleNode source) {
            super.beforeDeactivated(source);
            for (ISubModuleNodeListener next : NavigationTreeObserver.this.getSubModuleNodeListeners()) {
                next.beforeDeactivated(source);
            }
        }

        public void afterDeactivated(ISubModuleNode source) {
            super.afterDeactivated(source);
            for (ISubModuleNodeListener next : NavigationTreeObserver.this.getSubModuleNodeListeners()) {
                next.afterDeactivated(source);
            }
        }

        public void disposed(ISubModuleNode source) {
            super.disposed(source);
            for (ISubModuleNodeListener next : NavigationTreeObserver.this.getSubModuleNodeListeners()) {
                next.disposed(source);
            }
        }

        public void beforeDisposed(ISubModuleNode source) {
            super.beforeDisposed(source);
            for (ISubModuleNodeListener next : NavigationTreeObserver.this.getSubModuleNodeListeners()) {
                next.beforeDisposed(source);
            }
        }

        public void afterDisposed(ISubModuleNode source) {
            super.afterDisposed(source);
            for (ISubModuleNodeListener next : NavigationTreeObserver.this.getSubModuleNodeListeners()) {
                next.afterDisposed(source);
            }
        }

        public void childAdded(ISubModuleNode source, ISubModuleNode childAdded) {
            super.childAdded(source, childAdded);
            NavigationTreeObserver.this.addListenerTo(childAdded);
            for (ISubModuleNodeListener next : NavigationTreeObserver.this.getSubModuleNodeListeners()) {
                next.childAdded(source, childAdded);
            }
        }

        public void childRemoved(ISubModuleNode source, ISubModuleNode childRemoved) {
            super.childRemoved(source, childRemoved);
            NavigationTreeObserver.this.removeListenerFrom(childRemoved);
            for (ISubModuleNodeListener next : NavigationTreeObserver.this.getSubModuleNodeListeners()) {
                next.childRemoved(source, childRemoved);
            }
        }

        public void expandedChanged(ISubModuleNode source) {
            super.expandedChanged(source);
            for (ISubModuleNodeListener next : NavigationTreeObserver.this.getSubModuleNodeListeners()) {
                next.expandedChanged(source);
            }
        }

        public void labelChanged(ISubModuleNode source) {
            super.labelChanged(source);
            for (ISubModuleNodeListener next : NavigationTreeObserver.this.getSubModuleNodeListeners()) {
                next.labelChanged(source);
            }
        }

        public void markerChanged(ISubModuleNode source, IMarker marker) {
            super.markerChanged(source, marker);
            for (ISubModuleNodeListener next : NavigationTreeObserver.this.getSubModuleNodeListeners()) {
                next.markerChanged(source, marker);
            }
        }

        public void parentChanged(ISubModuleNode source) {
            super.parentChanged(source);
            for (ISubModuleNodeListener next : NavigationTreeObserver.this.getSubModuleNodeListeners()) {
                next.parentChanged(source);
            }
        }

        public void presentationChanged(ISubModuleNode source) {
            super.presentationChanged(source);
            for (ISubModuleNodeListener next : NavigationTreeObserver.this.getSubModuleNodeListeners()) {
                next.presentationChanged(source);
            }
        }

        public void selectedChanged(ISubModuleNode source) {
            super.selectedChanged(source);
            for (ISubModuleNodeListener next : NavigationTreeObserver.this.getSubModuleNodeListeners()) {
                next.selectedChanged(source);
            }
        }

        public void stateChanged(ISubModuleNode source, INavigationNode.State oldState, INavigationNode.State newState) {
            super.stateChanged(source, oldState, newState);
            for (ISubModuleNodeListener next : NavigationTreeObserver.this.getSubModuleNodeListeners()) {
                next.stateChanged(source, oldState, newState);
            }
        }

        public void prepared(ISubModuleNode source) {
            super.prepared(source);
            for (ISubModuleNodeListener next : NavigationTreeObserver.this.getSubModuleNodeListeners()) {
                next.prepared(source);
            }
        }

        public void nodeIdChange(ISubModuleNode source, NavigationNodeId oldId, NavigationNodeId newId) {
            super.nodeIdChange(source, oldId, newId);
            for (ISubModuleNodeListener next : NavigationTreeObserver.this.getSubModuleNodeListeners()) {
                next.nodeIdChange(source, oldId, newId);
            }
        }
    }
}

