/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.model;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.riena.core.marker.IMarkable;
import org.eclipse.riena.core.marker.IMarker;
import org.eclipse.riena.core.marker.Markable;
import org.eclipse.riena.navigation.ApplicationNodeManager;
import org.eclipse.riena.navigation.IAction;
import org.eclipse.riena.navigation.IJumpTargetListener;
import org.eclipse.riena.navigation.INavigationContext;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.INavigationNodeController;
import org.eclipse.riena.navigation.INavigationProcessor;
import org.eclipse.riena.navigation.ISimpleNavigationNodeListener;
import org.eclipse.riena.navigation.NavigationArgument;
import org.eclipse.riena.navigation.NavigationNodeId;
import org.eclipse.riena.navigation.common.TypecastingObject;
import org.eclipse.riena.navigation.listener.INavigationNodeListener;
import org.eclipse.riena.navigation.listener.INavigationNodeListenerable;
import org.eclipse.riena.navigation.model.NavigationModelFailure;
import org.eclipse.riena.ui.core.context.IContext;
import org.eclipse.riena.ui.core.marker.DisabledMarker;
import org.eclipse.riena.ui.core.marker.HiddenMarker;
import org.eclipse.riena.ui.filter.IUIFilter;
import org.eclipse.riena.ui.filter.IUIFilterable;
import org.eclipse.riena.ui.filter.impl.UIFilterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NavigationNode<S extends INavigationNode<C>, C extends INavigationNode<?>, L extends INavigationNodeListener<S, C>>
extends TypecastingObject
implements INavigationNode<C>,
INavigationNodeListenerable<S, C, L>,
IContext {
    private NavigationNodeId nodeId;
    private INavigationNode.State state;
    private String label;
    private String icon;
    private boolean expanded;
    private INavigationNodeController navigationNodeController;
    private INavigationProcessor navigationProcessor;
    private final List<C> children;
    private boolean selected;
    private final List<L> listeners;
    private final List<ISimpleNavigationNodeListener> simpleListeners;
    private final IMarkable markable;
    private final IUIFilterable filterable;
    private Map<String, Object> context;
    private final Set<IAction> actions;
    private final PropertyChangeSupport propertyChangeSupport;
    private IMarker hiddenMarker;
    private IMarker disabledMarker;
    private Boolean cachedVisible;
    private Boolean cachedEnabled;
    private boolean isNodeIdChange;
    private INavigationNode<?> parent;
    private boolean blocked;

    public NavigationNode(NavigationNodeId nodeId) {
        this.nodeId = nodeId;
        this.listeners = new LinkedList<L>();
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        this.simpleListeners = new LinkedList<ISimpleNavigationNodeListener>();
        this.children = new LinkedList<C>();
        this.markable = this.createMarkable();
        this.filterable = this.createFilterable();
        this.actions = new LinkedHashSet<IAction>();
        this.state = INavigationNode.State.CREATED;
        this.context = null;
        this.isNodeIdChange = false;
    }

    public NavigationNode(NavigationNodeId nodeId, String pLabel) {
        this(nodeId);
        this.setLabel(pLabel);
    }

    @Override
    public void setNavigationNodeController(INavigationNodeController pNavigationNodeController) {
        this.navigationNodeController = pNavigationNodeController;
        this.notifyControllerChanged();
    }

    private void notifyControllerChanged() {
        for (INavigationNodeListener iNavigationNodeListener : this.getListeners()) {
            iNavigationNodeListener.presentationChanged(this);
        }
        for (ISimpleNavigationNodeListener iSimpleNavigationNodeListener : this.getSimpleListeners()) {
            iSimpleNavigationNodeListener.presentationChanged(this);
        }
    }

    private void notifySelectedChanged() {
        for (INavigationNodeListener iNavigationNodeListener : this.getListeners()) {
            iNavigationNodeListener.selectedChanged(this);
        }
        for (ISimpleNavigationNodeListener iSimpleNavigationNodeListener : this.getSimpleListeners()) {
            iSimpleNavigationNodeListener.selectedChanged(this);
        }
    }

    private void notifyLabelChanged() {
        for (INavigationNodeListener iNavigationNodeListener : this.getListeners()) {
            iNavigationNodeListener.labelChanged(this);
        }
        for (ISimpleNavigationNodeListener iSimpleNavigationNodeListener : this.getSimpleListeners()) {
            iSimpleNavigationNodeListener.labelChanged(this);
        }
    }

    private void notifyIconChanged() {
        for (INavigationNodeListener iNavigationNodeListener : this.getListeners()) {
            iNavigationNodeListener.iconChanged(this);
        }
        for (ISimpleNavigationNodeListener iSimpleNavigationNodeListener : this.getSimpleListeners()) {
            iSimpleNavigationNodeListener.iconChanged(this);
        }
    }

    private void notifyChildAdded(C pChild) {
        for (INavigationNodeListener iNavigationNodeListener : this.getListeners()) {
            iNavigationNodeListener.childAdded(this, pChild);
        }
        for (ISimpleNavigationNodeListener iSimpleNavigationNodeListener : this.getSimpleListeners()) {
            iSimpleNavigationNodeListener.childAdded(this, (INavigationNode<?>)pChild);
        }
    }

    private void notifyPrepared() {
        for (INavigationNodeListener iNavigationNodeListener : this.getListeners()) {
            iNavigationNodeListener.prepared(this);
        }
        for (ISimpleNavigationNodeListener iSimpleNavigationNodeListener : this.getSimpleListeners()) {
            iSimpleNavigationNodeListener.prepared(this);
        }
    }

    private void notifyActivated() {
        for (INavigationNodeListener iNavigationNodeListener : this.getListeners()) {
            iNavigationNodeListener.activated(this);
        }
        for (ISimpleNavigationNodeListener iSimpleNavigationNodeListener : this.getSimpleListeners()) {
            iSimpleNavigationNodeListener.activated(this);
        }
    }

    private void notifyBeforeActivated() {
        for (INavigationNodeListener iNavigationNodeListener : this.getListeners()) {
            iNavigationNodeListener.beforeActivated(this);
        }
        for (ISimpleNavigationNodeListener iSimpleNavigationNodeListener : this.getSimpleListeners()) {
            iSimpleNavigationNodeListener.beforeActivated(this);
        }
    }

    private void notifyAfterActivated() {
        for (INavigationNodeListener iNavigationNodeListener : this.getListeners()) {
            iNavigationNodeListener.afterActivated(this);
        }
        for (ISimpleNavigationNodeListener iSimpleNavigationNodeListener : this.getSimpleListeners()) {
            iSimpleNavigationNodeListener.afterActivated(this);
        }
    }

    private void notifyDeactivated() {
        for (INavigationNodeListener iNavigationNodeListener : this.getListeners()) {
            iNavigationNodeListener.deactivated(this);
        }
        for (ISimpleNavigationNodeListener iSimpleNavigationNodeListener : this.getSimpleListeners()) {
            iSimpleNavigationNodeListener.deactivated(this);
        }
    }

    private void notifyBeforeDeactivated() {
        for (INavigationNodeListener iNavigationNodeListener : this.getListeners()) {
            iNavigationNodeListener.beforeDeactivated(this);
        }
        for (ISimpleNavigationNodeListener iSimpleNavigationNodeListener : this.getSimpleListeners()) {
            iSimpleNavigationNodeListener.beforeDeactivated(this);
        }
    }

    private void notifyAfterDeactivated() {
        for (INavigationNodeListener iNavigationNodeListener : this.getListeners()) {
            iNavigationNodeListener.afterDeactivated(this);
        }
        for (ISimpleNavigationNodeListener iSimpleNavigationNodeListener : this.getSimpleListeners()) {
            iSimpleNavigationNodeListener.afterDeactivated(this);
        }
    }

    private void notifyChildRemoved(C pChild) {
        for (INavigationNodeListener iNavigationNodeListener : this.getListeners()) {
            iNavigationNodeListener.childRemoved(this, pChild);
        }
        for (ISimpleNavigationNodeListener iSimpleNavigationNodeListener : this.getSimpleListeners()) {
            iSimpleNavigationNodeListener.childRemoved(this, (INavigationNode<?>)pChild);
        }
    }

    @Override
    public void setNavigationProcessor(INavigationProcessor pProcessor) {
        this.navigationProcessor = pProcessor;
    }

    protected boolean checkChildClass(Class<?> childClass) {
        Class<?>[] types;
        Assert.isNotNull(childClass);
        Class<?>[] classArray = types = childClass.getInterfaces();
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> type = classArray[n2];
            if (type == this.getValidChildType()) {
                return true;
            }
            if (type == INavigationNode.class) {
                return false;
            }
            ++n2;
        }
        Class<?> superClass = childClass.getSuperclass();
        if (superClass != null) {
            return this.checkChildClass(superClass);
        }
        return false;
    }

    @Override
    public void addChild(C child) {
        this.addChild(this.children.size(), child);
    }

    @Override
    public void addChild(int index, C child) {
        this.checkChild(child);
        ArrayList<C> oldList = new ArrayList<C>(this.children);
        this.children.add(index, child);
        this.fireChildAdded(child, oldList);
        this.addChildParent(child);
    }

    private void fireChildAdded(C child, List<C> oldList) {
        this.propertyChangeSupport.firePropertyChange("children", oldList, this.children);
        this.notifyChildAdded(child);
    }

    private void checkChild(C child) {
        if (child == null) {
            throw new NavigationModelFailure("Cannot add null!");
        }
        if (this.hasChild((INavigationNode<?>)child)) {
            throw new NavigationModelFailure("Child node \"" + child.toString() + "\" is already added!");
        }
        if (child.isDisposed()) {
            throw new NavigationModelFailure("Cannot add disposed child node \"" + child.toString() + "\"!");
        }
        if (child == this) {
            throw new NavigationModelFailure("Cannot add node \"" + child.toString() + "\" to itself!");
        }
        if (!this.checkChildClass(child.getClass())) {
            String msg = "Cannot add \"" + child.toString() + "\" to \"" + this.toString() + "\"!";
            msg = String.valueOf(msg) + " Because node isn't instance of " + this.getValidChildType().toString() + ".";
            throw new NavigationModelFailure(msg);
        }
        if (child.getNodeId() != null) {
            if (child.getNodeId().equals(this.getNodeId())) {
                String msg = "Cannot add \"" + child.toString() + "\" to \"" + this.toString() + "\"!";
                msg = String.valueOf(msg) + " Because both nodes have the same NavigationNodeId.";
                throw new NavigationModelFailure(msg);
            }
            if (this.hasChild(child.getNodeId())) {
                String msg = "Cannot add \"" + child.toString() + "\" to \"" + this.toString() + "\"!";
                msg = String.valueOf(msg) + " Because a child with the same NavigationNodeId already exists.";
                throw new NavigationModelFailure(msg);
            }
        }
    }

    protected boolean hasChild(INavigationNode<?> pChild) {
        return this.children.contains(pChild);
    }

    protected boolean hasChild(NavigationNodeId nodeId) {
        for (INavigationNode child : this.children) {
            if (child.getNodeId() == null || !child.getNodeId().equals(nodeId)) continue;
            return true;
        }
        return false;
    }

    protected void addChildParent(C child) {
        child.setParent(this);
    }

    @Override
    public List<C> getChildren() {
        return this.children;
    }

    @Override
    public void removeChild(INavigationNode<?> child) {
        if (child == null) {
            throw new NavigationModelFailure("Cannot remove null!");
        }
        if (!this.hasChild(child)) {
            throw new NavigationModelFailure("Node \"" + child.toString() + "\" isn't a child of \"" + this.toString() + "\"!");
        }
        if (child.isActivated()) {
            throw new NavigationModelFailure("Cannot remove active child \"" + child.toString() + "\"!");
        }
        ArrayList<C> oldList = new ArrayList<C>(this.children);
        this.children.remove(child);
        child.setParent(null);
        this.propertyChangeSupport.firePropertyChange("children", oldList, this.children);
        this.notifyChildRemoved(child);
    }

    @Override
    public C getChild(int index) {
        if (this.children != null && this.children.size() > index) {
            return (C)((INavigationNode)this.children.get(index));
        }
        return null;
    }

    @Override
    public INavigationNode<?> findNode(NavigationNodeId nodeId) {
        if (this.getNodeId() != null && this.getNodeId().equals(nodeId)) {
            return this;
        }
        for (INavigationNode child : this.children) {
            INavigationNode<?> foundChild = child.findNode(nodeId);
            if (foundChild == null) continue;
            return foundChild;
        }
        return null;
    }

    @Override
    public void activate() {
        this.getNavigationProcessor().activate(this);
    }

    @Override
    public void prepare() {
        ArrayList<C> oldChildren = new ArrayList<C>(this.getChildren());
        this.getNavigationProcessor().prepare(this);
        if (!this.getChildren().isEmpty() && this.getChildren().size() > oldChildren.size()) {
            this.fireChildAdded(this.getChild(0), oldChildren);
        }
    }

    @Override
    public boolean allowsActivate(INavigationContext context) {
        INavigationNodeController localPresentation = this.getNavigationNodeController();
        if (localPresentation != null) {
            return localPresentation.allowsActivate(this, context);
        }
        return true;
    }

    @Override
    public boolean allowsDeactivate(INavigationContext context) {
        INavigationNodeController localPresentation = this.getNavigationNodeController();
        if (localPresentation != null) {
            return localPresentation.allowsDeactivate(this, context);
        }
        return true;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void addListener(L listener) {
        this.listeners.add(listener);
    }

    @Override
    public void addSimpleListener(ISimpleNavigationNodeListener simpleListener) {
        this.simpleListeners.add(simpleListener);
    }

    @Override
    public void removeSimpleListener(ISimpleNavigationNodeListener simpleListener) {
        this.simpleListeners.remove(simpleListener);
    }

    @Override
    public void removeListener(L listener) {
        this.listeners.remove(listener);
    }

    protected List<L> getListeners() {
        return new LinkedList<L>(this.listeners);
    }

    protected List<ISimpleNavigationNodeListener> getSimpleListeners() {
        return new LinkedList<ISimpleNavigationNodeListener>(this.simpleListeners);
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public void setLabel(String label) {
        String old = this.label;
        this.label = label;
        this.propertyChangeSupport.firePropertyChange("label", old, label);
        this.notifyLabelChanged();
    }

    @Override
    public String getIcon() {
        return this.icon;
    }

    @Override
    public void setIcon(String icon) {
        this.icon = icon;
        this.notifyIconChanged();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("NavigationNode [label=").append(this.getLabel()).append(", nodeId=").append(this.getNodeId()).append("]");
        return builder.toString();
    }

    @Override
    public INavigationNode<?> getParent() {
        return this.parent;
    }

    @Override
    public void setParent(INavigationNode<?> pParent) {
        this.parent = pParent;
        this.notifyParentChanged();
    }

    private void notifyParentChanged() {
        for (INavigationNodeListener iNavigationNodeListener : this.getListeners()) {
            iNavigationNodeListener.parentChanged(this);
        }
        for (ISimpleNavigationNodeListener iSimpleNavigationNodeListener : this.getSimpleListeners()) {
            iSimpleNavigationNodeListener.parentChanged(this);
        }
    }

    @Override
    public INavigationProcessor getNavigationProcessor() {
        if (this.navigationProcessor != null) {
            return this.navigationProcessor;
        }
        if (this.getParent() != null) {
            return this.getParent().getNavigationProcessor();
        }
        if (ApplicationNodeManager.getApplicationNode() != null) {
            return ApplicationNodeManager.getApplicationNode().getNavigationProcessor();
        }
        return ApplicationNodeManager.getDefaultNavigationProcessor();
    }

    @Override
    public INavigationNodeController getNavigationNodeController() {
        return this.navigationNodeController;
    }

    @Override
    public INavigationNodeController getNextNavigationNodeController() {
        if (this.navigationNodeController != null) {
            return this.navigationNodeController;
        }
        if (this.getParent() != null) {
            return this.getParent().getNavigationNodeController();
        }
        return null;
    }

    @Override
    public boolean isExpanded() {
        return this.expanded;
    }

    @Override
    public void setExpanded(boolean pExpanded) {
        this.expanded = pExpanded;
        this.notifyExpandedChanged();
    }

    private void notifyExpandedChanged() {
        for (INavigationNodeListener iNavigationNodeListener : this.getListeners()) {
            iNavigationNodeListener.expandedChanged(this);
        }
        for (ISimpleNavigationNodeListener iSimpleNavigationNodeListener : this.getSimpleListeners()) {
            iSimpleNavigationNodeListener.expandedChanged(this);
        }
    }

    @Override
    public boolean isLeaf() {
        return this.getChildren().size() < 1;
    }

    @Override
    public IMarkable getMarkable() {
        return this.markable;
    }

    protected IMarkable createMarkable() {
        return new Markable();
    }

    public Collection<? extends IMarker> getMarkers() {
        return this.getMarkable().getMarkers();
    }

    private void clearCachedValues() {
        this.cachedVisible = null;
        this.cachedEnabled = null;
    }

    public void addMarker(IMarker marker) {
        INavigationProcessor proc = this.getNavigationProcessor();
        if (proc != null) {
            boolean oldEnabled = this.isEnabled();
            boolean oldVisible = this.isVisible();
            proc.addMarker(this, marker);
            if (oldEnabled != this.isEnabled()) {
                this.propertyChangeSupport.firePropertyChange("enabled", oldEnabled, this.isEnabled());
            }
            if (oldVisible != this.isVisible()) {
                this.propertyChangeSupport.firePropertyChange("visible", oldVisible, this.isVisible());
            }
        }
    }

    @Override
    public void addMarker(INavigationContext context, IMarker marker) {
        this.getMarkable().addMarker(marker);
        this.clearCachedValues();
        this.notifyMarkersChanged(marker);
        if (marker instanceof DisabledMarker || marker instanceof HiddenMarker) {
            for (INavigationNode child : this.getChildren()) {
                child.addMarker(marker);
            }
        }
    }

    public <T extends IMarker> Collection<T> getMarkersOfType(Class<T> type) {
        return this.getMarkable().getMarkersOfType(type);
    }

    public void removeAllMarkers() {
        if (this.getMarkable().getMarkers().isEmpty()) {
            return;
        }
        boolean oldEnabled = this.isEnabled();
        boolean oldVisible = this.isVisible();
        while (!this.getMarkable().getMarkers().isEmpty()) {
            IMarker marker = (IMarker)this.getMarkable().getMarkers().iterator().next();
            this.getMarkable().removeMarker(marker);
            this.clearCachedValues();
            this.notifyMarkersChanged(marker);
        }
        if (oldEnabled != this.isEnabled()) {
            this.propertyChangeSupport.firePropertyChange("enabled", oldEnabled, this.isEnabled());
        }
        if (oldVisible != this.isVisible()) {
            this.propertyChangeSupport.firePropertyChange("visible", oldVisible, this.isVisible());
        }
    }

    public boolean removeMarker(IMarker marker) {
        boolean oldEnabled = this.isEnabled();
        boolean oldVisible = this.isVisible();
        boolean removedMarker = this.getMarkable().removeMarker(marker);
        if (!removedMarker) {
            return false;
        }
        this.clearCachedValues();
        if (oldEnabled != this.isEnabled()) {
            this.propertyChangeSupport.firePropertyChange("enabled", oldEnabled, this.isEnabled());
        }
        if (oldVisible != this.isVisible()) {
            this.propertyChangeSupport.firePropertyChange("visible", oldVisible, this.isVisible());
        }
        this.notifyMarkersChanged(marker);
        if (marker instanceof DisabledMarker || marker instanceof HiddenMarker) {
            for (INavigationNode child : this.getChildren()) {
                child.removeMarker(marker);
            }
        }
        return true;
    }

    private void notifyMarkersChanged(IMarker marker) {
        for (INavigationNodeListener iNavigationNodeListener : this.getListeners()) {
            iNavigationNodeListener.markerChanged(this, marker);
        }
        for (ISimpleNavigationNodeListener iSimpleNavigationNodeListener : this.getSimpleListeners()) {
            iSimpleNavigationNodeListener.markerChanged(this, marker);
        }
    }

    @Override
    public Object getContext(String key) {
        if (this.context == null) {
            return null;
        }
        return this.context.get(key);
    }

    @Override
    public void setContext(String key, Object value) {
        if (this.context == null) {
            this.context = new HashMap<String, Object>();
        }
        this.checkForNavigationArgumentUpdate(key, value);
        this.context.put(key, value);
    }

    private void checkForNavigationArgumentUpdate(String key, Object value) {
        NavigationArgument oldArgument;
        if ("riena.navigation.argument".equals(key) && this.getNavigationNodeController() != null && ((oldArgument = (NavigationArgument)this.getContext("riena.navigation.argument")) == null || !oldArgument.equals(value))) {
            this.getNavigationNodeController().navigationArgumentChanged((NavigationArgument)value);
        }
    }

    @Override
    public void removeContext(String key) {
        if (this.context != null) {
            this.context.remove(key);
        }
    }

    @Override
    public void addAction(IAction pAction) {
        this.actions.add(pAction);
    }

    @Override
    public Set<IAction> getActions() {
        return this.actions;
    }

    @Override
    public Set<IAction> getAllActions() {
        HashSet<IAction> allActions = new HashSet<IAction>();
        allActions.addAll(this.getActions());
        if (this.getParent() != null) {
            allActions.addAll(this.getParent().getAllActions());
        }
        return allActions;
    }

    @Override
    public void removeAction(IAction pAction) {
        this.actions.remove(pAction);
    }

    @Override
    public void prepare(INavigationContext context) {
        Assert.isTrue((this.isCreated() || this.isPrepared() ? 1 : 0) != 0);
        this.setState(INavigationNode.State.PREPARED);
        this.notifyPrepared();
    }

    @Override
    public void activate(INavigationContext context) {
        this.setState(INavigationNode.State.ACTIVATED);
        this.notifyActivated();
    }

    @Override
    public void onBeforeActivate(INavigationContext context) {
        this.notifyBeforeActivated();
    }

    @Override
    public void onAfterActivate(INavigationContext context) {
        this.notifyAfterActivated();
    }

    @Override
    public void deactivate(INavigationContext context) {
        this.setState(INavigationNode.State.DEACTIVATED);
        this.notifyDeactivated();
    }

    @Override
    public void onBeforeDeactivate(INavigationContext context) {
        this.notifyBeforeDeactivated();
    }

    @Override
    public void onAfterDeactivate(INavigationContext context) {
        this.notifyAfterDeactivated();
    }

    private void setState(INavigationNode.State pState) {
        if (pState != this.state) {
            INavigationNode.State oldState = this.state;
            this.state = pState;
            this.notifyStateChanged(oldState, this.state);
        }
    }

    private void notifyStateChanged(INavigationNode.State oldState, INavigationNode.State newState) {
        for (INavigationNodeListener iNavigationNodeListener : this.getListeners()) {
            iNavigationNodeListener.stateChanged(this, oldState, newState);
        }
        for (ISimpleNavigationNodeListener iSimpleNavigationNodeListener : this.getSimpleListeners()) {
            iSimpleNavigationNodeListener.stateChanged(this, oldState, newState);
        }
    }

    @Override
    public INavigationNode.State getState() {
        return this.state;
    }

    @Override
    public boolean isActivated() {
        return this.state == INavigationNode.State.ACTIVATED;
    }

    @Override
    public boolean isPrepared() {
        return this.state == INavigationNode.State.PREPARED;
    }

    @Override
    public boolean isCreated() {
        return this.state == INavigationNode.State.CREATED;
    }

    @Override
    public boolean isDeactivated() {
        return this.state == INavigationNode.State.DEACTIVATED;
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    @Override
    public void setSelected(boolean selected) {
        if (selected != this.selected) {
            this.selected = selected;
            this.notifySelectedChanged();
        }
    }

    @Override
    public boolean allowsDispose(INavigationContext context) {
        INavigationNodeController pres = this.getNavigationNodeController();
        if (pres != null) {
            return pres.allowsDispose(this, context);
        }
        return true;
    }

    @Override
    public void dispose() {
        this.getNavigationProcessor().dispose(this);
    }

    private void notifyDisposed() {
        for (INavigationNodeListener iNavigationNodeListener : this.getListeners()) {
            iNavigationNodeListener.disposed(this);
        }
        for (ISimpleNavigationNodeListener iSimpleNavigationNodeListener : this.getSimpleListeners()) {
            iSimpleNavigationNodeListener.disposed(this);
        }
    }

    private void notifyBeforeDisposed() {
        for (INavigationNodeListener iNavigationNodeListener : this.getListeners()) {
            iNavigationNodeListener.beforeDisposed(this);
        }
        for (ISimpleNavigationNodeListener iSimpleNavigationNodeListener : this.getSimpleListeners()) {
            iSimpleNavigationNodeListener.beforeDisposed(this);
        }
    }

    private void notifyAfterDisposed() {
        for (INavigationNodeListener iNavigationNodeListener : this.getListeners()) {
            iNavigationNodeListener.afterDisposed(this);
        }
        for (ISimpleNavigationNodeListener iSimpleNavigationNodeListener : this.getSimpleListeners()) {
            iSimpleNavigationNodeListener.afterDisposed(this);
        }
    }

    @Override
    public void dispose(INavigationContext context) {
        this.setState(INavigationNode.State.DISPOSED);
        this.notifyDisposed();
    }

    @Override
    public void onBeforeDispose(INavigationContext context) {
        this.notifyBeforeDisposed();
    }

    @Override
    public void onAfterDispose(INavigationContext context) {
        this.notifyAfterDisposed();
    }

    @Override
    public boolean isDisposed() {
        return this.getState() == INavigationNode.State.DISPOSED;
    }

    @Override
    public boolean isBlocked() {
        return this.blocked;
    }

    @Override
    public void setBlocked(boolean blocked) {
        boolean changed = this.blocked ^ blocked;
        this.blocked = blocked;
        if (changed) {
            this.notifyBlockedChanged();
        }
        for (INavigationNode child : this.getChildren()) {
            child.setBlocked(blocked);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled(this);
    }

    private boolean isEnabled(NavigationNode<?, ?, ?> node) {
        boolean enabled;
        if (node.cachedEnabled == null) {
            node.cachedEnabled = node.getMarkersOfType(DisabledMarker.class).isEmpty();
        }
        if ((enabled = node.cachedEnabled.booleanValue()) && node.getParent() != null) {
            enabled = this.isEnabled((NavigationNode)node.getParent());
        }
        return enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.disabledMarker == null) {
            this.disabledMarker = new DisabledMarker();
        }
        if (enabled) {
            this.removeMarker(this.disabledMarker);
        } else {
            this.addMarker(this.disabledMarker);
        }
    }

    @Override
    public boolean isVisible() {
        return this.isVisible(this);
    }

    private boolean isVisible(NavigationNode<?, ?, ?> node) {
        boolean visible;
        if (node.cachedVisible == null) {
            node.cachedVisible = node.getMarkersOfType(HiddenMarker.class).isEmpty();
        }
        if ((visible = node.cachedVisible.booleanValue()) && node.getParent() != null) {
            visible = this.isVisible((NavigationNode)node.getParent());
        }
        return visible;
    }

    @Override
    public final void setVisible(boolean visible) {
        if (this.hiddenMarker == null) {
            this.hiddenMarker = new HiddenMarker();
        }
        if (visible) {
            this.removeMarker(this.hiddenMarker);
        } else {
            this.addMarker(this.hiddenMarker);
        }
    }

    private void notifyBlockedChanged() {
        for (INavigationNodeListener iNavigationNodeListener : this.getListeners()) {
            iNavigationNodeListener.block(this, this.isBlocked());
        }
        for (ISimpleNavigationNodeListener iSimpleNavigationNodeListener : this.getSimpleListeners()) {
            iSimpleNavigationNodeListener.block(this, this.isBlocked());
        }
    }

    @Override
    public int getIndexOfChild(INavigationNode<?> child) {
        return this.children.indexOf(child);
    }

    @Override
    public <N extends INavigationNode<?>> N getParentOfType(Class<N> clazz) {
        if (this.getParent() == null) {
            return null;
        }
        if (clazz.isAssignableFrom(this.getParent().getClass())) {
            return (N)this.getParent();
        }
        return this.getParent().getParentOfType(clazz);
    }

    @Override
    public void create(NavigationNodeId targetId) {
        this.getNavigationProcessor().create(this, targetId);
    }

    @Override
    public void create(NavigationNodeId targetId, NavigationArgument argument) {
        this.getNavigationProcessor().create(this, targetId, argument);
    }

    @Override
    public void createAsync(NavigationNodeId targetId, NavigationArgument argument) {
        if (argument == null) {
            argument = new NavigationArgument();
        }
        argument.setCreateNodesAsync(true);
        this.getNavigationProcessor().create(this, targetId, argument);
    }

    @Override
    public void createAsync(NavigationNodeId targetId) {
        this.createAsync(targetId, null);
    }

    @Override
    public void moveTo(NavigationNodeId targetId) {
        throw new UnsupportedOperationException("Only ModuleNodes can be moved to a new target.");
    }

    @Override
    public void navigate(NavigationNodeId targetId) {
        this.navigate(targetId, null);
    }

    @Override
    public void navigate(NavigationNodeId targetId, NavigationArgument argument) {
        this.getNavigationProcessor().navigate(this, targetId, argument);
    }

    @Override
    public void navigateBack() {
        if (this.getNavigationProcessor() != null) {
            this.getNavigationProcessor().navigateBack(this);
        }
    }

    @Override
    public void jump(NavigationNodeId targetId) {
        this.jump(targetId, null);
    }

    @Override
    public void jump(NavigationNodeId targetId, NavigationArgument argument) {
        this.getNavigationProcessor().jump(this, targetId, argument);
    }

    @Override
    public void jumpBack() {
        this.getNavigationProcessor().jumpBack(this);
    }

    @Override
    public boolean isJumpTarget() {
        return this.getNavigationProcessor().isJumpTarget(this);
    }

    @Override
    public void addJumpTargetListener(IJumpTargetListener listener) {
        this.getNavigationProcessor().addJumpTargetListener(this, listener);
    }

    @Override
    public void removeJumpTargetListener(IJumpTargetListener listener) {
        this.getNavigationProcessor().removeJumpTargetListener(this, listener);
    }

    @Override
    public void historyBack() {
        if (this.getNavigationProcessor() != null) {
            this.getNavigationProcessor().historyBack();
        }
    }

    @Override
    public void historyForward() {
        if (this.getNavigationProcessor() != null) {
            this.getNavigationProcessor().historyForward();
        }
    }

    @Override
    public NavigationNodeId getNodeId() {
        return this.nodeId;
    }

    @Override
    public void setNodeId(NavigationNodeId nodeId) {
        if (!this.isNodeIdChange) {
            this.isNodeIdChange = true;
            this.notifyNodeIdChange(nodeId);
            this.isNodeIdChange = false;
        }
        this.nodeId = nodeId;
    }

    protected IUIFilterable createFilterable() {
        return new UIFilterable();
    }

    private IUIFilterable getFilterable() {
        return this.filterable;
    }

    public void addFilter(IUIFilter filter) {
        this.getFilterable().addFilter(filter);
        this.notifyFilterAdded(filter);
    }

    public void removeFilter(IUIFilter filter) {
        this.getFilterable().removeFilter(filter);
        this.notifyFilterRemoved(filter);
    }

    public void removeFilter(String filterID) {
        Collection<IUIFilter> filters = this.getFilters();
        ArrayList<IUIFilter> toRemove = new ArrayList<IUIFilter>();
        for (IUIFilter filter : filters) {
            if (filter.getFilterID() == null || !filter.getFilterID().equals(filterID)) continue;
            toRemove.add(filter);
        }
        for (IUIFilter filter : toRemove) {
            this.removeFilter(filter);
        }
    }

    public void removeAllFilters() {
        ArrayList<IUIFilter> filters = new ArrayList<IUIFilter>(this.getFilters());
        this.getFilterable().removeAllFilters();
        for (IUIFilter filter : filters) {
            this.notifyFilterRemoved(filter);
        }
    }

    public Collection<? extends IUIFilter> getFilters() {
        return this.getFilterable().getFilters();
    }

    private void notifyFilterAdded(IUIFilter filter) {
        for (INavigationNodeListener iNavigationNodeListener : this.getListeners()) {
            iNavigationNodeListener.filterAdded(this, filter);
        }
        for (ISimpleNavigationNodeListener iSimpleNavigationNodeListener : this.getSimpleListeners()) {
            iSimpleNavigationNodeListener.filterAdded(this, filter);
        }
    }

    private void notifyFilterRemoved(IUIFilter filter) {
        for (INavigationNodeListener iNavigationNodeListener : this.getListeners()) {
            iNavigationNodeListener.filterRemoved(this, filter);
        }
        for (ISimpleNavigationNodeListener iSimpleNavigationNodeListener : this.getSimpleListeners()) {
            iSimpleNavigationNodeListener.filterRemoved(this, filter);
        }
    }

    private void notifyNodeIdChange(NavigationNodeId newId) {
        NavigationNodeId oldId = this.getNodeId();
        for (INavigationNodeListener iNavigationNodeListener : this.getListeners()) {
            iNavigationNodeListener.nodeIdChange(this, oldId, newId);
        }
        for (ISimpleNavigationNodeListener iSimpleNavigationNodeListener : this.getSimpleListeners()) {
            iSimpleNavigationNodeListener.nodeIdChange(this, oldId, newId);
        }
    }

    @Override
    public NavigationArgument getNavigationArgument() {
        NavigationArgument navigationArgument = (NavigationArgument)this.getContext("riena.navigation.argument");
        if (navigationArgument != null) {
            return navigationArgument;
        }
        if (this.getParent() != null) {
            return this.getParent().getNavigationArgument();
        }
        return navigationArgument;
    }
}

