/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.internal.core.test.RienaTestCase;
import org.eclipse.riena.internal.core.test.collect.UITestCase;
import org.eclipse.riena.internal.ui.ridgets.swt.CompletionComboRidget;
import org.eclipse.riena.internal.ui.ridgets.swt.DateTextRidget;
import org.eclipse.riena.internal.ui.ridgets.swt.DisabledMarkerVisualizer;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.swt.DefaultRealm;
import org.eclipse.riena.ui.swt.CompletionCombo;
import org.eclipse.riena.ui.swt.DatePickerComposite;
import org.eclipse.riena.ui.swt.utils.UIControlsFactory;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

@UITestCase
public class DisabledMarkerVisualizerTest
extends RienaTestCase {
    private Shell shell;
    private DefaultRealm realm;

    protected void setUp() throws Exception {
        super.setUp();
        this.shell = new Shell();
        this.realm = new DefaultRealm();
    }

    protected void tearDown() throws Exception {
        if (this.shell != null) {
            this.shell.dispose();
            this.shell = null;
        }
        if (this.realm != null) {
            this.realm.dispose();
            this.realm = null;
        }
        super.tearDown();
    }

    public void testGetChildrenFromComposite() {
        Composite parent = new Composite((Composite)this.shell, 0);
        new Label(parent, 0);
        new Text(parent, 0);
        DisabledMarkerVisualizer visualizer = new DisabledMarkerVisualizer(null);
        Control[] result = (Control[])ReflectionUtils.invokeHidden((Object)visualizer, (String)"getChildren", (Object[])new Object[]{parent});
        DisabledMarkerVisualizerTest.assertEquals((int)2, (int)result.length);
        DisabledMarkerVisualizerTest.assertTrue((boolean)(result[0] instanceof Label));
        DisabledMarkerVisualizerTest.assertTrue((boolean)(result[1] instanceof Text));
    }

    public void testGetChildrenFromCCombo() {
        CCombo parent = new CCombo((Composite)this.shell, 0);
        DisabledMarkerVisualizer visualizer = new DisabledMarkerVisualizer(null);
        Control[] result = (Control[])ReflectionUtils.invokeHidden((Object)visualizer, (String)"getChildren", (Object[])new Object[]{parent});
        DisabledMarkerVisualizerTest.assertEquals((int)2, (int)result.length);
        DisabledMarkerVisualizerTest.assertTrue((boolean)(result[0] instanceof Text));
        DisabledMarkerVisualizerTest.assertTrue((boolean)(result[1] instanceof Button));
    }

    public void testVisualizerAndDatePickerEnablement() {
        DateTextRidget ridget = new DateTextRidget();
        DatePickerComposite control = new DatePickerComposite((Composite)this.shell, 0);
        Button pickerButton = (Button)ReflectionUtils.getHidden((Object)control, (String)"pickerButton");
        ridget.setUIControl((Object)control);
        ridget.setOutputOnly(true);
        DisabledMarkerVisualizerTest.assertFalse((boolean)pickerButton.isEnabled());
        DisabledMarkerVisualizer visualizer = new DisabledMarkerVisualizer((IRidget)ridget);
        ReflectionUtils.invokeHidden((Object)visualizer, (String)"updateDisabled", (Object[])new Object[]{control, false});
        DisabledMarkerVisualizerTest.assertFalse((boolean)pickerButton.isEnabled());
        ReflectionUtils.invokeHidden((Object)visualizer, (String)"updateDisabled", (Object[])new Object[]{control, true});
        DisabledMarkerVisualizerTest.assertFalse((boolean)pickerButton.isEnabled());
    }

    public void testVisualizerAndCompletionComboEnablement() {
        CompletionComboRidget ridget = new CompletionComboRidget();
        CompletionCombo control = UIControlsFactory.createCompletionCombo((Composite)this.shell, (int)0);
        Button arrow = (Button)ReflectionUtils.getHidden((Object)control, (String)"arrow");
        ridget.setUIControl((Object)control);
        ridget.setOutputOnly(true);
        DisabledMarkerVisualizerTest.assertFalse((boolean)arrow.isEnabled());
        DisabledMarkerVisualizer visualizer = new DisabledMarkerVisualizer((IRidget)ridget);
        ReflectionUtils.invokeHidden((Object)visualizer, (String)"updateDisabled", (Object[])new Object[]{control, false});
        DisabledMarkerVisualizerTest.assertFalse((boolean)arrow.isEnabled());
        ReflectionUtils.invokeHidden((Object)visualizer, (String)"updateDisabled", (Object[])new Object[]{control, true});
        DisabledMarkerVisualizerTest.assertFalse((boolean)arrow.isEnabled());
    }
}

