/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.objecttransaction.interf.value;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.riena.objecttransaction.AbstractTransactedObject;
import org.eclipse.riena.objecttransaction.IObjectId;
import org.eclipse.riena.objecttransaction.ITransactedObject;
import org.eclipse.riena.objecttransaction.InvalidTransactionFailure;
import org.eclipse.riena.objecttransaction.interf.value.GenericOID;
import org.eclipse.riena.objecttransaction.interf.value.IAddresse;
import org.eclipse.riena.objecttransaction.interf.value.Vertrag;

public class Kunde
extends AbstractTransactedObject {
    private String vorname;
    private String nachname;
    private String kundennr;
    private IAddresse addresse;
    private HashSet<Vertrag> vertraege;

    private Kunde() {
        if (!this.getCurrentObjectTransaction().isCleanModus()) {
            throw new InvalidTransactionFailure("cannot instantiate Kunde with private method if not in clean state");
        }
        this.getCurrentObjectTransaction().register((ITransactedObject)this);
    }

    public Kunde(String kundennr) {
        super((IObjectId)new GenericOID("kunde", "kundennrpk", kundennr), "1");
        if (this.getCurrentObjectTransaction().isCleanModus()) {
            this.getCurrentObjectTransaction().register((ITransactedObject)this);
        } else {
            this.getCurrentObjectTransaction().registerNew((ITransactedObject)this);
        }
        this.setKundennr(kundennr);
        this.vertraege = new HashSet();
    }

    public String getKundennr() {
        return (String)this.getCurrentObjectTransaction().getReference((ITransactedObject)this, "kundennr", (Object)this.kundennr);
    }

    public void setKundennr(String kundennr) {
        if (((GenericOID)this.getObjectId()).getProperties().get("primkey") != null) {
            throw new UnsupportedOperationException("cannot change kundennr (once it is set)");
        }
        if (this.getCurrentObjectTransaction().isCleanModus()) {
            this.kundennr = kundennr;
        } else {
            this.getCurrentObjectTransaction().setReference((ITransactedObject)this, "kundennr", (Object)kundennr);
        }
    }

    public String getNachname() {
        return (String)this.getCurrentObjectTransaction().getReference((ITransactedObject)this, "nachname", (Object)this.nachname);
    }

    public void setNachname(String nachname) {
        if (this.getCurrentObjectTransaction().isCleanModus()) {
            this.nachname = nachname;
        } else {
            this.getCurrentObjectTransaction().setReference((ITransactedObject)this, "nachname", (Object)nachname);
        }
    }

    public String getVorname() {
        return (String)this.getCurrentObjectTransaction().getReference((ITransactedObject)this, "vorname", (Object)this.vorname);
    }

    public void setVorname(String vorname) {
        if (this.getCurrentObjectTransaction().isCleanModus()) {
            this.vorname = vorname;
        } else {
            this.getCurrentObjectTransaction().setReference((ITransactedObject)this, "vorname", (Object)vorname);
        }
    }

    public IAddresse getAddresse() {
        return (IAddresse)this.getCurrentObjectTransaction().getReference((ITransactedObject)this, "addresse", (ITransactedObject)this.addresse);
    }

    public void setAddresse(IAddresse addresse) {
        if (this.getCurrentObjectTransaction().isCleanModus()) {
            this.addresse = addresse;
        } else {
            this.getCurrentObjectTransaction().setReference((ITransactedObject)this, "addresse", (ITransactedObject)addresse);
        }
    }

    public void addVertrag(Vertrag vertrag) {
        if (this.getCurrentObjectTransaction().isCleanModus()) {
            this.vertraege.add(vertrag);
        } else {
            this.getCurrentObjectTransaction().addReference((ITransactedObject)this, "vertrag", (ITransactedObject)vertrag);
        }
    }

    public void removeVertrag(String vertragsNummer) {
        Vertrag tempVertrag = this.getVertrag(vertragsNummer);
        if (this.getCurrentObjectTransaction().isCleanModus()) {
            this.vertraege.remove(this.getVertrag(vertragsNummer));
        } else {
            this.getCurrentObjectTransaction().removeReference((ITransactedObject)this, "vertrag", (ITransactedObject)tempVertrag);
        }
    }

    public void removeVertrag(Vertrag vertrag) {
        if (this.getCurrentObjectTransaction().isCleanModus()) {
            this.vertraege.remove(vertrag);
        } else {
            this.getCurrentObjectTransaction().removeReference((ITransactedObject)this, "vertrag", (ITransactedObject)vertrag);
        }
    }

    public Vertrag getVertrag(String vertragsNummer) {
        Vertrag[] tempVertraege;
        Vertrag[] vertragArray = tempVertraege = this.listVertrag();
        int n = tempVertraege.length;
        int n2 = 0;
        while (n2 < n) {
            Vertrag element = vertragArray[n2];
            if (element.getVertragsNummer().equals(vertragsNummer)) {
                return element;
            }
            ++n2;
        }
        return null;
    }

    public Vertrag[] listVertrag() {
        Set vertraegeSet = this.getCurrentObjectTransaction().listReference((ITransactedObject)this, "vertrag", this.vertraege);
        if (vertraegeSet.size() == 0) {
            return new Vertrag[0];
        }
        return vertraegeSet.toArray(new Vertrag[vertraegeSet.size()]);
    }
}

