/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.core.uiprocess;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.core.runtime.jobs.ProgressProvider;
import org.eclipse.riena.core.exception.IExceptionHandlerManager;
import org.eclipse.riena.core.service.Service;
import org.eclipse.riena.internal.ui.core.Activator;
import org.eclipse.riena.ui.core.uiprocess.IProcessInfoAware;
import org.eclipse.riena.ui.core.uiprocess.IUIMonitor;
import org.eclipse.riena.ui.core.uiprocess.IUIMonitorContainer;
import org.eclipse.riena.ui.core.uiprocess.IUISynchronizer;
import org.eclipse.riena.ui.core.uiprocess.ProcessInfo;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UICallbackDispatcher
extends ProgressProvider
implements IUIMonitorContainer {
    private final IUISynchronizer syncher;
    private final List<IUIMonitor> uiMonitors = Collections.synchronizedList(new ArrayList());
    private final ProcessInfo pInfo;
    private ThreadSwitcher threadSwitcher;
    private JobChangeAdapter jobListener;

    public UICallbackDispatcher(IUISynchronizer syncher) {
        this.syncher = syncher;
        this.pInfo = new ProcessInfo();
    }

    public ProcessInfo getProcessInfo() {
        return this.pInfo;
    }

    @Override
    public void addUIMonitor(IUIMonitor uiMontitor) {
        if (this.uiMonitors.contains(uiMontitor)) {
            return;
        }
        IProcessInfoAware processInfoAware = (IProcessInfoAware)uiMontitor.getAdapter(IProcessInfoAware.class);
        if (processInfoAware != null) {
            processInfoAware.setProcessInfo(this.pInfo);
        }
        this.uiMonitors.add(uiMontitor);
    }

    protected final IUISynchronizer getSyncher() {
        return this.syncher;
    }

    public final IProgressMonitor createMonitor(Job job) {
        this.threadSwitcher = this.createThreadSwitcher();
        this.observeJob(job);
        return this.threadSwitcher;
    }

    public ThreadSwitcher createThreadSwitcher() {
        return new ThreadSwitcher(this.createWrappedMonitor());
    }

    private void observeJob(Job job) {
        if (this.jobListener == null) {
            this.jobListener = new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    super.done(event);
                    UICallbackDispatcher.this.jobDone();
                }
            };
            job.addJobChangeListener((IJobChangeListener)this.jobListener);
        }
    }

    private List<IUIMonitor> getMonitors() {
        return new ArrayList<IUIMonitor>(this.uiMonitors);
    }

    protected IProgressMonitor createWrappedMonitor() {
        return new NullProgressMonitor(){

            public void beginTask(String name, int totalWork) {
                UICallbackDispatcher.this.pInfo.setMaxProgress(totalWork);
                for (IUIMonitor monitor : UICallbackDispatcher.this.getMonitors()) {
                    monitor.initialUpdateUI(totalWork);
                }
            }

            public void worked(int work) {
                for (IUIMonitor monitor : UICallbackDispatcher.this.getMonitors()) {
                    monitor.updateProgress(work);
                }
            }

            public void done() {
            }
        };
    }

    private void jobDone() {
        this.synchronize(new Runnable(){

            public void run() {
                for (IUIMonitor monitor : UICallbackDispatcher.this.getMonitors()) {
                    try {
                        monitor.finalUpdateUI();
                    }
                    catch (Exception e) {
                        ((IExceptionHandlerManager)Service.get((BundleContext)Activator.getDefault().getContext(), IExceptionHandlerManager.class)).handleException((Throwable)e);
                    }
                }
            }
        });
    }

    private void synchronize(Runnable runnable) {
        this.syncher.syncExec(runnable);
    }

    private final class ThreadSwitcher
    extends NullProgressMonitor {
        private final IProgressMonitor delegate;

        public ThreadSwitcher(IProgressMonitor wrappedMonitor) {
            this.delegate = wrappedMonitor;
        }

        public void beginTask(final String name, final int totalWork) {
            UICallbackDispatcher.this.synchronize(new Runnable(){

                public void run() {
                    ThreadSwitcher.this.delegate.beginTask(name, totalWork);
                }
            });
        }

        public void worked(final int work) {
            UICallbackDispatcher.this.synchronize(new Runnable(){

                public void run() {
                    ThreadSwitcher.this.delegate.worked(work);
                }
            });
        }

        public void done() {
        }
    }
}

