/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.swt.facades.internal;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.window.DefaultToolTip;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.riena.ui.swt.lnf.rienadefault.RienaDefaultLnf;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class SubModuleToolTip
extends DefaultToolTip {
    private final Tree tree;
    private final ILabelProvider labelProvider;

    public SubModuleToolTip(Tree parent, ILabelProvider labelProvider) {
        super((Control)parent);
        this.tree = parent;
        Assert.isNotNull((Object)labelProvider);
        this.labelProvider = labelProvider;
        this.setShift(new Point(0, 0));
    }

    public Point getLocation(Point tipSize, Event event) {
        Point location = super.getLocation(tipSize, event);
        TreeItem item = this.getTreeItem(event);
        if (item != null) {
            location = this.tree.toDisplay(item.getBounds().x, item.getBounds().y);
        }
        return location;
    }

    protected Composite createToolTipContentArea(Event event, Composite parent) {
        CLabel label = new CLabel(parent, this.getStyle(event));
        Color fgColor = this.getForegroundColor(event);
        Color bgColor = this.getBackgroundColor(event);
        Font font = this.getFont(event);
        if (fgColor != null) {
            label.setForeground(fgColor);
        }
        if (bgColor != null) {
            label.setBackground(bgColor);
        }
        if (font != null) {
            label.setFont(font);
        }
        label.setText(this.getItemLongText(event));
        return label;
    }

    protected boolean shouldCreateToolTip(Event event) {
        boolean should = super.shouldCreateToolTip(event);
        if (should) {
            this.initLookAndFeel();
            String text = this.getItemText(event);
            String longText = this.getItemLongText(event);
            should = !text.equals(longText);
        }
        return should;
    }

    private String getItemLongText(Event event) {
        String result = "";
        TreeItem item = this.getTreeItem(event);
        if (item != null) {
            Object element = item.getData();
            result = this.labelProvider.getText(element);
        }
        return result;
    }

    private String getItemText(Event event) {
        String text = "";
        TreeItem item = this.getTreeItem(event);
        if (item != null) {
            text = item.getText();
        }
        return text;
    }

    private TreeItem getTreeItem(Event event) {
        Point point = new Point(event.x, event.y);
        return this.tree.getItem(point);
    }

    private void initLookAndFeel() {
        Font font;
        Color color;
        RienaDefaultLnf lnf = LnfManager.getLnf();
        Integer delay = lnf.getIntegerSetting("SubModuleItemToolTip.popupDelay");
        if (delay != null) {
            this.setPopupDelay(delay);
        }
        if ((color = lnf.getColor("SubModuleItemToolTip.foreground")) != null) {
            this.setForegroundColor(color);
        }
        if ((color = lnf.getColor("SubModuleItemToolTip.background")) != null) {
            this.setBackgroundColor(color);
        }
        if ((font = lnf.getFont("SubModuleItemToolTip.font")) != null) {
            this.setFont(font);
        }
    }
}

