/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.log.internal;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.equinox.log.LogFilter;
import org.eclipse.equinox.log.SynchronousLogListener;
import org.eclipse.equinox.log.internal.BasicReadWriteLock;
import org.eclipse.equinox.log.internal.ExtendedLogEntryImpl;
import org.eclipse.equinox.log.internal.ExtendedLogReaderServiceImpl;
import org.eclipse.equinox.log.internal.SerializedTaskQueue;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.log.LogEntry;
import org.osgi.service.log.LogListener;

public class ExtendedLogReaderServiceFactory
implements ServiceFactory {
    private static final Enumeration EMPTY_ENUMERATION = new Enumeration(){

        public boolean hasMoreElements() {
            return false;
        }

        public Object nextElement() {
            return null;
        }
    };
    static final LogFilter NULL_LOGGER_FILTER = new LogFilter(){

        public boolean isLoggable(Bundle b, String loggerName, int logLevel) {
            return true;
        }
    };
    private static final LogFilter[] ALWAYS_LOG = new LogFilter[0];
    private static PrintStream errorStream;
    private Map listeners = new HashMap();
    private LogFilter[] filters = null;
    private BasicReadWriteLock listenersLock = new BasicReadWriteLock();

    static boolean safeIsLoggable(LogFilter filter, Bundle bundle, String name, int level) {
        try {
            return filter.isLoggable(bundle, name, level);
        }
        catch (RuntimeException e) {
            ExtendedLogReaderServiceFactory.getErrorStream().println("LogFilter.isLoggable threw a non-fatal unchecked exception as follows:");
            e.printStackTrace(ExtendedLogReaderServiceFactory.getErrorStream());
        }
        catch (LinkageError e) {
            ExtendedLogReaderServiceFactory.getErrorStream().println("LogFilter.isLoggable threw a non-fatal unchecked exception as follows:");
            e.printStackTrace(ExtendedLogReaderServiceFactory.getErrorStream());
        }
        return false;
    }

    private static synchronized PrintStream getErrorStream() {
        if (errorStream == null) {
            return System.err;
        }
        return errorStream;
    }

    public static synchronized void setErrorStream(PrintStream ps) {
        errorStream = ps;
    }

    static void safeLogged(LogListener listener, LogEntry logEntry) {
        try {
            listener.logged(logEntry);
        }
        catch (RuntimeException e) {
            ExtendedLogReaderServiceFactory.getErrorStream().println("LogListener.logged threw a non-fatal unchecked exception as follows:");
            e.printStackTrace(ExtendedLogReaderServiceFactory.getErrorStream());
        }
        catch (LinkageError e) {
            ExtendedLogReaderServiceFactory.getErrorStream().println("LogListener.logged threw a non-fatal unchecked exception as follows:");
            e.printStackTrace(ExtendedLogReaderServiceFactory.getErrorStream());
        }
    }

    public Object getService(Bundle bundle, ServiceRegistration registration) {
        return new ExtendedLogReaderServiceImpl(this, bundle);
    }

    public void ungetService(Bundle bundle, ServiceRegistration registration, Object service) {
        ExtendedLogReaderServiceImpl readerService = (ExtendedLogReaderServiceImpl)service;
        readerService.shutdown();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean isLoggable(Bundle bundle, String name, int level) {
        block8: {
            block7: {
                this.listenersLock.readLock();
                try {
                    if (this.filters == null) {
                        Object var7_4 = null;
                        this.listenersLock.readUnlock();
                        return false;
                    }
                    if (this.filters == ALWAYS_LOG) {
                        break block7;
                    }
                    int filtersLength = this.filters.length;
                    int i = 0;
                    while (i < filtersLength) {
                        LogFilter filter = this.filters[i];
                        if (!ExtendedLogReaderServiceFactory.safeIsLoggable(filter, bundle, name, level)) {
                            ++i;
                            continue;
                        }
                        break block7;
                    }
                    break block8;
                }
                catch (Throwable throwable) {
                    Object var7_6 = null;
                    this.listenersLock.readUnlock();
                    throw throwable;
                }
            }
            Object var7_5 = null;
            this.listenersLock.readUnlock();
            return true;
        }
        Object var7_7 = null;
        this.listenersLock.readUnlock();
        return false;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void log(Bundle bundle, String name, Object context, int level, String message, Throwable exception) {
        ExtendedLogEntryImpl logEntry = new ExtendedLogEntryImpl(bundle, name, context, level, message, exception);
        this.listenersLock.readLock();
        try {
            Iterator it = this.listeners.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                Object[] listenerObjects = (Object[])entry.getValue();
                LogFilter filter = (LogFilter)listenerObjects[0];
                if (!ExtendedLogReaderServiceFactory.safeIsLoggable(filter, bundle, name, level)) continue;
                LogListener listener = (LogListener)entry.getKey();
                SerializedTaskQueue taskQueue = (SerializedTaskQueue)listenerObjects[1];
                if (taskQueue != null) {
                    taskQueue.put(new LogTask(logEntry, listener));
                    continue;
                }
                ExtendedLogReaderServiceFactory.safeLogged(listener, logEntry);
            }
        }
        catch (Throwable throwable) {
            Object var14_15 = null;
            this.listenersLock.readUnlock();
            throw throwable;
        }
        {
            Object var14_16 = null;
            this.listenersLock.readUnlock();
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void addLogListener(LogListener listener, LogFilter filter) {
        this.listenersLock.writeLock();
        try {
            Object[] listenerObjects = (Object[])this.listeners.get(listener);
            if (listenerObjects == null) {
                SerializedTaskQueue taskQueue = listener instanceof SynchronousLogListener ? null : new SerializedTaskQueue(listener.toString());
                listenerObjects = new Object[]{filter, taskQueue};
            } else if (filter != listenerObjects[0]) {
                listenerObjects[0] = filter;
            }
            this.listeners.put(listener, listenerObjects);
            this.recalculateFilters();
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.listenersLock.writeUnlock();
            throw throwable;
        }
        {
            Object var5_7 = null;
            this.listenersLock.writeUnlock();
            return;
        }
    }

    private void recalculateFilters() {
        ArrayList<LogFilter> filtersList = new ArrayList<LogFilter>();
        Iterator it = this.listeners.values().iterator();
        while (it.hasNext()) {
            Object[] listenerObjects = (Object[])it.next();
            LogFilter filter = (LogFilter)listenerObjects[0];
            if (filter == NULL_LOGGER_FILTER) {
                this.filters = ALWAYS_LOG;
                return;
            }
            filtersList.add(filter);
        }
        if (filtersList.isEmpty()) {
            this.filters = null;
        }
        this.filters = filtersList.toArray(new LogFilter[filtersList.size()]);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void removeLogListener(LogListener listener) {
        this.listenersLock.writeLock();
        try {
            this.listeners.remove(listener);
            this.recalculateFilters();
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.listenersLock.writeUnlock();
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.listenersLock.writeUnlock();
            return;
        }
    }

    Enumeration getLog() {
        return EMPTY_ENUMERATION;
    }

    static final class LogTask
    implements Runnable {
        private final LogEntry logEntry;
        private final LogListener listener;

        LogTask(LogEntry logEntry, LogListener listener) {
            this.logEntry = logEntry;
            this.listener = listener;
        }

        public void run() {
            ExtendedLogReaderServiceFactory.safeLogged(this.listener, this.logEntry);
        }
    }
}

