/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.swt.views;

import java.beans.Beans;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.log.Logger;
import org.eclipse.riena.core.IRienaActivator;
import org.eclipse.riena.core.Log4r;
import org.eclipse.riena.core.util.InvocationTargetFailure;
import org.eclipse.riena.core.util.StringUtils;
import org.eclipse.riena.internal.navigation.ui.swt.Activator;
import org.eclipse.riena.internal.navigation.ui.swt.handlers.NavigationSourceProvider;
import org.eclipse.riena.navigation.ApplicationNodeManager;
import org.eclipse.riena.navigation.IApplicationNode;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.NavigationNodeId;
import org.eclipse.riena.navigation.listener.ISubModuleNodeListener;
import org.eclipse.riena.navigation.listener.NavigationTreeObserver;
import org.eclipse.riena.navigation.listener.SubModuleNodeListener;
import org.eclipse.riena.navigation.model.SubModuleNode;
import org.eclipse.riena.navigation.ui.controllers.SubModuleController;
import org.eclipse.riena.navigation.ui.swt.presentation.SwtViewProvider;
import org.eclipse.riena.navigation.ui.swt.views.IComponentUpdateListener;
import org.eclipse.riena.navigation.ui.swt.views.INavigationNodeView;
import org.eclipse.riena.navigation.ui.swt.views.SWTModuleController;
import org.eclipse.riena.ui.ridgets.IMarkableRidget;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.controller.IController;
import org.eclipse.riena.ui.ridgets.swt.uibinding.AbstractViewBindingDelegate;
import org.eclipse.riena.ui.ridgets.swt.uibinding.DefaultSwtBindingDelegate;
import org.eclipse.riena.ui.swt.EmbeddedTitleBar;
import org.eclipse.riena.ui.swt.facades.SWTFacade;
import org.eclipse.riena.ui.swt.lnf.LnFUpdater;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.riena.ui.swt.utils.SWTBindingPropertyLocator;
import org.eclipse.riena.ui.swt.utils.SWTControlFinder;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.riena.ui.swt.utils.WidgetIdentificationSupport;
import org.eclipse.riena.ui.workarea.IWorkareaDefinition;
import org.eclipse.riena.ui.workarea.WorkareaManager;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.ISourceProvider;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.services.ISourceProviderService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SubModuleView
extends ViewPart
implements INavigationNodeView<SubModuleNode> {
    public static final String SHARED_ID = "shared";
    private static final Logger LOGGER = Log4r.getLogger((IRienaActivator)Activator.getDefault(), SubModuleView.class);
    private final LnFUpdater lnfUpdater = LnFUpdater.getInstance();
    private static final Map<SubModuleView, SubModuleNode> FALLBACK_NODES = new HashMap<SubModuleView, SubModuleNode>();
    private static final String IS_SUB_MODULE_VIEW_COMPOSITE = "isSubModuleViewComposite";
    private final AbstractViewBindingDelegate binding;
    private final FocusListener focusListener;
    private SubModuleController currentController;
    private SubModuleNode rcpSubModuleNode;
    private EmbeddedTitleBar title;
    private Composite parentComposite;
    private Composite contentComposite;
    private boolean isBlocked = false;
    private final Map<Integer, Control> focusControlMap = new HashMap<Integer, Control>(1);
    private NavigationTreeObserver navigationTreeObserver;
    private NavigationSourceProvider navigationSourceProvider;
    private SubModuleNodesListener subModuleNodeListener;
    private Cursor oldCursor;

    public SubModuleView() {
        this.binding = this.createBinding();
        this.focusListener = new FocusListener();
    }

    @Override
    public void addUpdateListener(IComponentUpdateListener listener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void bind(SubModuleNode node) {
        if (this.getNavigationNode() != null && this.getController() == null) {
            this.createViewFacade();
        }
        if (this.currentController != this.getController()) {
            if (this.currentController != null) {
                if (((ISubModuleNode)this.currentController.getNavigationNode()).isDisposed()) {
                    return;
                }
                this.binding.unbind((IController)this.currentController);
            }
            if (this.getController() != null) {
                this.currentController = this.getController();
            }
            this.binding.bind((IController)this.currentController);
            this.currentController.afterBind();
            this.lnfUpdater.updateUIControls(this.getParentComposite(), true);
        } else {
            this.lnfUpdater.updateUIControlsAfterBind(this.getContentComposite());
        }
        this.activeNodeChanged((INavigationNode<?>)this.getNavigationNode());
        this.blockView(node.isBlocked());
    }

    private void activeNodeChanged(INavigationNode<?> node) {
        if (this.navigationSourceProvider == null && this.getSite() != null) {
            this.navigationSourceProvider = this.getNavigationSourceProvider();
        }
        if (this.navigationSourceProvider != null) {
            if (!this.navigationSourceProvider.isDisposed()) {
                this.navigationSourceProvider.activeNodeChanged(node);
            } else {
                this.navigationSourceProvider = null;
            }
        }
    }

    private NavigationSourceProvider getNavigationSourceProvider() {
        ISourceProvider[] sourceProviders;
        ISourceProviderService sourceProviderService = (ISourceProviderService)this.getSite().getService(ISourceProviderService.class);
        if (sourceProviderService == null) {
            return null;
        }
        ISourceProvider[] iSourceProviderArray = sourceProviders = sourceProviderService.getSourceProviders();
        int n = sourceProviders.length;
        int n2 = 0;
        while (n2 < n) {
            ISourceProvider sourceProvider = iSourceProviderArray[n2];
            if (sourceProvider instanceof NavigationSourceProvider) {
                return (NavigationSourceProvider)sourceProvider;
            }
            ++n2;
        }
        return null;
    }

    public void createPartControl(Composite parent) {
        this.parentComposite = parent;
        parent.setData(IS_SUB_MODULE_VIEW_COMPOSITE, (Object)Boolean.TRUE);
        if (!Beans.isDesignTime()) {
            this.observeRoot();
            SubModuleController controller = this.createController((ISubModuleNode)this.getNavigationNode());
            if (controller != null) {
                this.setPartName(((ISubModuleNode)controller.getNavigationNode()).getLabel());
            }
            this.contentComposite = this.createContentComposite(parent);
        } else {
            this.contentComposite = parent;
        }
        this.contentComposite.setData("contentComposite", (Object)true);
        this.createWorkarea(this.contentComposite);
        if (Beans.isDesignTime()) {
            this.lnfUpdater.updateUIControls(this.getParentComposite(), true);
        } else {
            this.registerView();
            this.createViewFacade();
            this.doBinding();
        }
        if (this.getViewSite() != null && this.getViewSite().getSecondaryId() != null) {
            WidgetIdentificationSupport.setIdentification((Widget)this.contentComposite, (String[])new String[]{"subModuleView", this.getViewSite().getId(), this.getViewSite().getSecondaryId()});
        }
        this.contentComposite.getDisplay().addFilter(15, (Listener)this.focusListener);
        this.contentComposite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                event.widget.getDisplay().removeFilter(15, (Listener)SubModuleView.this.focusListener);
            }
        });
    }

    protected void registerView() {
        SwtViewProvider.getInstance().registerView(this.getViewSite().getId(), this);
    }

    public void dispose() {
        IApplicationNode appNode = this.getAppNode();
        if (this.navigationTreeObserver != null && appNode != null) {
            this.navigationTreeObserver.removeListenerFrom(appNode);
        }
        FALLBACK_NODES.remove(this);
        this.destroyView();
    }

    protected void destroyView() {
        String id = this.getViewSite().getId();
        super.dispose();
        SwtViewProvider.getInstance().unregisterView(id);
    }

    public SubModuleController getController() {
        if (this.getNavigationNode() != null && this.getNavigationNode().getNavigationNodeController() instanceof SubModuleController) {
            return (SubModuleController)this.getNavigationNode().getNavigationNodeController();
        }
        return null;
    }

    @Override
    public SubModuleNode getNavigationNode() {
        String secondaryId;
        if (this.getViewSite() == null) {
            return this.getFallbackNavigationNode();
        }
        String viewId = this.getViewSite().getId();
        SubModuleNode result = (SubModuleNode)this.getSubModuleNode(viewId, secondaryId = this.getViewSite().getSecondaryId());
        if (result == null) {
            result = this.getRCPSubModuleNode();
        }
        if (result == null) {
            result = this.getFallbackNavigationNode();
        }
        return result;
    }

    public void setFocus() {
        if (this.canRestoreFocus()) {
            Integer id = this.getControllerId();
            Control lastFocusedControl = this.focusControlMap.get(id);
            lastFocusedControl.setFocus();
        } else if (this.canFocusOnRidget()) {
            this.getFocusRidget().requestFocus();
        } else {
            this.contentComposite.setFocus();
        }
    }

    private boolean canFocusOnRidget() {
        boolean result = false;
        IRidget ridget = this.getFocusRidget();
        if (ridget != null) {
            boolean bl = result = ridget.isFocusable() && ridget.isEnabled() && ridget.isVisible();
            if (ridget instanceof IMarkableRidget) {
                result &= !((IMarkableRidget)ridget).isOutputOnly();
            }
        }
        return result;
    }

    private IRidget getFocusRidget() {
        return this.currentController != null ? this.currentController.getInitialFocus() : null;
    }

    @Override
    public void unbind() {
        SubModuleController controller = this.getController();
        if (controller != null) {
            this.binding.unbind((IController)controller);
        }
    }

    protected void addUIControl(Object uiControl) {
        this.binding.addUIControl(uiControl);
    }

    protected void addUIControl(Object uiControl, String bindingId) {
        this.binding.addUIControl(uiControl, bindingId);
    }

    protected void afterBasicCreatePartControl(Composite parent) {
    }

    protected abstract void basicCreatePartControl(Composite var1);

    protected void blockView(boolean block) {
        if (!this.getParentComposite().isDisposed()) {
            if (block) {
                this.blockView();
            } else {
                this.unBlockView();
            }
        }
    }

    private void unBlockView() {
        this.isBlocked = false;
        this.getParentComposite().setCursor(this.oldCursor);
        this.contentComposite.setEnabled(true);
        this.contentComposite.setRedraw(false);
        this.contentComposite.setRedraw(true);
        if (this.shouldRestoreFocus() && this.canRestoreFocus()) {
            this.setFocus();
        }
        this.oldCursor = null;
        if (this.getController() != null) {
            for (IRidget ridget : this.getController().getRidgets()) {
                if (!(ridget instanceof IMarkableRidget)) continue;
                ((IMarkableRidget)ridget).updateMarkers();
            }
        }
    }

    private void blockView() {
        if (!this.isBlocked) {
            this.oldCursor = this.getParentComposite().getCursor();
            if (this.getController() != null) {
                for (IRidget ridget : this.getController().getRidgets()) {
                    Object uiControl;
                    if (!ridget.hasFocus() || !((uiControl = ridget.getUIControl()) instanceof Control)) continue;
                    this.saveFocus((Control)uiControl);
                }
            }
            this.getParentComposite().setCursor(this.getWaitCursor());
            this.contentComposite.setEnabled(false);
            this.isBlocked = true;
        }
    }

    protected final boolean canRestoreFocus() {
        Integer id = this.getControllerId();
        Control control = this.focusControlMap.get(id);
        return !SwtUtilities.isDisposed((Widget)control);
    }

    protected boolean shouldRestoreFocus() {
        if (this.getController() != null && this.getController().getModuleController() instanceof SWTModuleController) {
            return !((SWTModuleController)this.getController().getModuleController()).getTree().hasFocus();
        }
        return true;
    }

    protected AbstractViewBindingDelegate createBinding() {
        return new DefaultSwtBindingDelegate();
    }

    protected SubModuleController createController(ISubModuleNode node) {
        Assert.isNotNull((Object)node, (String)"navigation node must not be null");
        Assert.isNotNull((Object)node.getNodeId(), (String)"navigation node id must not be null");
        Assert.isNotNull((Object)node.getNodeId().getTypeId(), (String)"navigation node type id must not be null");
        SubModuleController controller = null;
        IWorkareaDefinition def = WorkareaManager.getInstance().getDefinition((Object)node);
        if (def != null) {
            try {
                controller = (SubModuleController)def.createController();
            }
            catch (Exception ex) {
                String message = String.format("cannnot create controller for class %s", def.getControllerClass());
                LOGGER.log(1, message, (Throwable)ex);
                throw new InvocationTargetFailure(message, (Throwable)ex);
            }
        }
        if (controller != null) {
            controller.setNavigationNode(node);
        }
        return controller;
    }

    protected void createViewFacade() {
        this.addUIControls(this.getParentComposite());
        if (this.getController() == null) {
            this.createController((ISubModuleNode)this.getNavigationNode());
        }
        if (this.getController() != null) {
            this.binding.injectRidgets((IController)this.getController());
        }
    }

    protected void createWorkarea(Composite parent) {
        this.basicCreatePartControl(parent);
        this.afterBasicCreatePartControl(parent);
    }

    protected Composite getContentComposite() {
        return this.contentComposite;
    }

    protected Composite getParentComposite() {
        return this.parentComposite;
    }

    protected ISubModuleNode getSubModuleNode(String nodeId, String secondaryId) {
        return SwtViewProvider.getInstance().getNavigationNode(nodeId, secondaryId, ISubModuleNode.class, !SHARED_ID.equals(secondaryId));
    }

    private void addMenuControl(Menu menu) {
        SWTBindingPropertyLocator locator = SWTBindingPropertyLocator.getInstance();
        int i = 0;
        while (i < menu.getItemCount()) {
            MenuItem item = menu.getItem(i);
            String bindingId = locator.locateBindingProperty((Object)item);
            if (StringUtils.isGiven((CharSequence)bindingId)) {
                this.addUIControl(item, bindingId);
            }
            if (item.getMenu() != null) {
                this.addMenuControl(item.getMenu());
            }
            ++i;
        }
    }

    protected void addUIControls(Composite composite) {
        SWTControlFinder finder = new SWTControlFinder(composite){

            public void handleBoundControl(Control control, String bindingProperty) {
                SubModuleView.this.addUIControl(control);
            }

            public void handleControl(Control control) {
                if (control.getMenu() != null) {
                    SubModuleView.this.addMenuControl(control.getMenu());
                }
                super.handleControl(control);
            }
        };
        finder.run();
    }

    private Composite createContentComposite(Composite parent) {
        Color bgColor = LnfManager.getLnf().getColor("SubModule.background");
        parent.setBackground(bgColor);
        parent.setLayout((Layout)new FormLayout());
        if (!this.isRCP()) {
            this.title = new EmbeddedTitleBar(parent, 0);
            this.addUIControl(this.title, "windowRidget");
            this.title.setWindowActive(true);
            FormData formData = new FormData();
            formData.top = new FormAttachment(0, -1);
            formData.left = new FormAttachment(0, -1);
            formData.bottom = new FormAttachment(0, this.title.getSize().y - 1);
            formData.right = new FormAttachment(100, 1);
            this.title.setLayoutData((Object)formData);
            SWTFacade.getDefault().createEmbeddedTitleBarToolTip(this.title);
        }
        Composite composite = new Composite(parent, 0x20000000);
        composite.setBackground(bgColor);
        FormData formData = new FormData();
        formData.top = this.title != null ? new FormAttachment((Control)this.title, 0, 0) : new FormAttachment(0, -1);
        formData.left = new FormAttachment(0, 0);
        formData.bottom = new FormAttachment(100);
        formData.right = new FormAttachment(100);
        composite.setLayoutData((Object)formData);
        return composite;
    }

    private void doBinding() {
        this.bind(this.getNavigationNode());
    }

    protected IApplicationNode getAppNode() {
        return ApplicationNodeManager.getApplicationNode();
    }

    private int getControllerId() {
        SubModuleController controller = this.getController();
        return controller == null ? 0 : controller.hashCode();
    }

    private SubModuleNode getFallbackNavigationNode() {
        SubModuleNode fallbackNode = FALLBACK_NODES.get(this);
        if (fallbackNode == null) {
            fallbackNode = new SubModuleNode(new NavigationNodeId(String.valueOf(this.getClass().getName()) + FALLBACK_NODES.size()));
            FALLBACK_NODES.put(this, fallbackNode);
        }
        return fallbackNode;
    }

    private SubModuleNode getRCPSubModuleNode() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = registry.getConfigurationElementsFor("org.eclipse.riena.navigation.assemblies");
        String viewId = this.getViewSite().getId();
        return this.getRCPSubModuleNode(viewId, elements);
    }

    private SubModuleNode getRCPSubModuleNode(String viewId, IConfigurationElement[] elements) {
        int i = 0;
        while (this.rcpSubModuleNode == null && i < elements.length) {
            IConfigurationElement element = elements[i];
            if ("submodule".equals(element.getName())) {
                String typeId;
                String view = element.getAttribute("view");
                if (viewId.equals(view) && (typeId = element.getAttribute("typeId")) != null) {
                    this.rcpSubModuleNode = new SubModuleNode(new NavigationNodeId(typeId), this.getPartName());
                }
            } else if (element.getChildren().length > 0) {
                this.rcpSubModuleNode = this.getRCPSubModuleNode(viewId, element.getChildren());
            }
            ++i;
        }
        return this.rcpSubModuleNode;
    }

    private Cursor getWaitCursor() {
        return this.contentComposite.getDisplay().getSystemCursor(1);
    }

    private boolean isRCP() {
        this.getNavigationNode();
        return this.rcpSubModuleNode != null;
    }

    private void observeRoot() {
        IApplicationNode appNode = this.getAppNode();
        if (appNode != null) {
            Assert.isLegal((this.navigationTreeObserver == null ? 1 : 0) != 0);
            this.navigationTreeObserver = new NavigationTreeObserver();
            this.subModuleNodeListener = new SubModuleNodesListener();
            this.navigationTreeObserver.addListener((ISubModuleNodeListener)this.subModuleNodeListener);
            this.navigationTreeObserver.addListenerTo(appNode);
        }
    }

    private void saveFocus(Control control) {
        int id = this.getControllerId();
        if (id != 0) {
            this.focusControlMap.put(id, control);
        }
    }

    protected String getSecondaryId() {
        return this.getViewSite().getSecondaryId();
    }

    protected void unbindActiveController() {
        this.binding.unbind((IController)this.currentController);
        this.currentController = null;
    }

    public void prepareNode(SubModuleNode node) {
        this.binding.injectRidgets((IController)this.createController((ISubModuleNode)node));
    }

    private final class FocusListener
    implements Listener {
        private FocusListener() {
        }

        public void handleEvent(Event event) {
            if (SubModuleView.this.contentComposite.isVisible() && event.widget instanceof Control) {
                Control control = (Control)event.widget;
                if (this.contains(SubModuleView.this.contentComposite, control)) {
                    SubModuleView.this.saveFocus(control);
                }
            }
        }

        private boolean contains(Composite container, Control control) {
            boolean result = false;
            Composite parent = control.getParent();
            while (!result && parent != null) {
                result = container == parent;
                parent = parent.getParent();
            }
            return result;
        }
    }

    private final class SubModuleNodesListener
    extends SubModuleNodeListener {
        private SubModuleNodesListener() {
        }

        public void activated(ISubModuleNode source) {
            if (source.equals(SubModuleView.this.getNavigationNode())) {
                SubModuleView.this.doBinding();
            }
        }

        public void beforeDisposed(ISubModuleNode source) {
            if (SubModuleView.this.getViewSite() != null && this.disposingBoundNode(source)) {
                SubModuleView.this.unbindActiveController();
            }
        }

        protected boolean disposingBoundNode(ISubModuleNode source) {
            return SubModuleView.this.getSecondaryId().equals(SubModuleView.SHARED_ID) && SubModuleView.this.currentController != null && source.equals(SubModuleView.this.currentController.getNavigationNode());
        }

        public void block(ISubModuleNode source, boolean block) {
            if (source.equals(SubModuleView.this.getNavigationNode())) {
                SubModuleView.this.blockView(block);
            }
        }

        public void nodeIdChange(ISubModuleNode source, NavigationNodeId oldId, NavigationNodeId newId) {
            if (source.equals(SubModuleView.this.getNavigationNode())) {
                SwtViewProvider.getInstance().replaceNavigationNodeId((INavigationNode<?>)source, oldId, newId);
            }
        }
    }
}

