/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.toolbox.previewer.ui;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.riena.toolbox.previewer.IPreviewCustomizer;
import org.eclipse.riena.toolbox.previewer.WorkspaceClassLoader;
import org.eclipse.riena.toolbox.previewer.model.ViewPartInfo;
import org.eclipse.riena.toolbox.previewer.ui.ReflectionUtil;
import org.eclipse.riena.toolbox.previewer.ui.WorkbenchUtil;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class Preview
extends ViewPart {
    private static final String VIEW_TITLE = "Previewer";
    public static final String ID = "org.eclipse.riena.toolbox.previewer.ui.Preview";
    private Composite parent;
    private CompResourceChangeListener changeListener;

    public void createPartControl(Composite parent) {
        this.parent = parent;
        parent.setLayout((Layout)new FillLayout());
        this.setPartName(VIEW_TITLE);
        this.getViewSite().getActionBars().getToolBarManager().add((IContributionItem)new ViewSizeToolBar(parent));
        this.changeListener = new CompResourceChangeListener(parent.getDisplay());
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.changeListener, 1);
    }

    public void showView(ViewPartInfo viewPart) {
        this.updateView(viewPart);
        this.changeListener.setViewPart(viewPart);
    }

    private void updateView(ViewPartInfo viewPart) {
        IPreviewCustomizer contribution;
        Object instance;
        if (this.parent.isDisposed()) {
            return;
        }
        Control[] controlArray = this.parent.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.dispose();
            ++n2;
        }
        this.parent.layout(true);
        this.parent.redraw();
        this.setPartName(viewPart.getName());
        if (ViewPart.class.isAssignableFrom(viewPart.getType())) {
            instance = ReflectionUtil.loadClass(viewPart);
            if (!ReflectionUtil.invokeMethod("createPartControl", instance, this.parent)) {
                this.setPartName(VIEW_TITLE);
                return;
            }
        } else {
            instance = (Control)ReflectionUtil.newInstance(viewPart.getType(), this.parent);
            if (instance == null) {
                MessageDialog.openWarning((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Warning", (String)("Can not instantiate Composite " + viewPart.getType().getName() + "\nNo valid SWT-style constructor found"));
                return;
            }
        }
        if ((contribution = WorkspaceClassLoader.getInstance().getContributedPreviewCustomizer()) != null) {
            contribution.afterCreation(this.parent);
        }
        this.parent.layout(true);
        this.parent.redraw();
    }

    public void setFocus() {
        this.parent.setFocus();
    }

    private class CompResourceChangeListener
    implements IResourceChangeListener {
        private ViewPartInfo viewPart;
        private final Display display;

        public CompResourceChangeListener(Display display) {
            this.display = display;
        }

        public void resourceChanged(IResourceChangeEvent event) {
            if (this.viewPart == null) {
                return;
            }
            CompilationUnitVisitor pluginXmlVisitor = new CompilationUnitVisitor(this.viewPart);
            try {
                event.getDelta().accept((IResourceDeltaVisitor)pluginXmlVisitor);
                if (pluginXmlVisitor.isCompilationUnitChanged()) {
                    this.display.syncExec(new Runnable(){

                        public void run() {
                            Preview.this.updateView(WorkspaceClassLoader.getInstance().loadClass(CompResourceChangeListener.this.viewPart.getCompilationUnit()));
                        }
                    });
                }
            }
            catch (CoreException e) {
                WorkbenchUtil.handleException(e);
                throw new RuntimeException(e);
            }
        }

        public void setViewPart(ViewPartInfo viewPart) {
            this.viewPart = viewPart;
        }
    }

    private static class CompilationUnitVisitor
    implements IResourceDeltaVisitor {
        private final ViewPartInfo compilationUnitClassName;
        private boolean compilationUnitChanged = false;

        public CompilationUnitVisitor(ViewPartInfo compilationUnitClassName) {
            this.compilationUnitClassName = compilationUnitClassName;
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource res = delta.getResource();
            if (res.getType() == 1 && (String.valueOf(this.compilationUnitClassName.getType().getSimpleName()) + ".class").equals(res.getName())) {
                this.compilationUnitChanged = true;
                return false;
            }
            return true;
        }

        public boolean isCompilationUnitChanged() {
            return this.compilationUnitChanged;
        }
    }

    private class ViewSizeToolBar
    extends ContributionItem {
        private final Composite viewParent;

        public ViewSizeToolBar(Composite viewParent) {
            this.viewParent = viewParent;
        }

        public void fill(ToolBar parent, int index) {
            final Text txtSize = this.createText(parent);
            this.viewParent.addListener(11, new Listener(){

                public void handleEvent(Event e) {
                    txtSize.setText(String.valueOf(((ViewSizeToolBar)ViewSizeToolBar.this).viewParent.getSize().x) + "x" + ((ViewSizeToolBar)ViewSizeToolBar.this).viewParent.getSize().y);
                }
            });
        }

        private Text createText(ToolBar parent) {
            ToolItem tool = new ToolItem(parent, 2);
            Text text = new Text((Composite)parent, 2048);
            tool.setWidth(80);
            text.setEditable(false);
            tool.setControl((Control)text);
            return text;
        }
    }
}

