/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.toolbox.previewer.ui;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.riena.toolbox.internal.previewer.Activator;
import org.eclipse.riena.toolbox.previewer.model.ViewPartInfo;
import org.eclipse.riena.toolbox.previewer.ui.Preview;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public final class WorkbenchUtil {
    public static void showView(ViewPartInfo info) {
        if (info == null) {
            return;
        }
        try {
            IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            Preview previewer = (Preview)activePage.showView("org.eclipse.riena.toolbox.previewer.ui.Preview");
            previewer.showView(info);
            previewer.setFocus();
        }
        catch (PartInitException e) {
            WorkbenchUtil.handleException(e);
        }
    }

    public static void handleException(Throwable e) {
        WorkbenchUtil.handleException(e, null);
    }

    public static void handleException(Throwable e, String message) {
        Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.riena.toolbox.previewer", e.getMessage(), e));
        if (message != null) {
            MessageDialog.openWarning((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Warning", (String)message);
        }
        throw new RuntimeException(e);
    }

    private WorkbenchUtil() {
    }
}

