/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.riena.core.RienaStatus;
import org.eclipse.riena.ui.ridgets.IActionRidget;
import org.eclipse.riena.ui.ridgets.IDefaultActionManager;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.IWindowRidget;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public final class DefaultActionManager
implements IDefaultActionManager,
Listener {
    private final IWindowRidget windowRidget;
    private final Map<IRidget, IActionRidget> ridget2button;
    private Map<Control, Button> control2button;
    private Shell shell;
    private Display display;

    public DefaultActionManager(IWindowRidget windowRidget) {
        Assert.isNotNull((Object)windowRidget);
        this.windowRidget = windowRidget;
        this.ridget2button = new HashMap<IRidget, IActionRidget>(1);
    }

    public void addAction(IRidget focusRidget, IActionRidget actionRidget) {
        Assert.isNotNull((Object)focusRidget);
        Assert.isNotNull((Object)actionRidget);
        this.ridget2button.put(focusRidget, actionRidget);
    }

    public void activate() {
        if (this.control2button == null && !RienaStatus.isTest()) {
            this.shell = ((Control)this.windowRidget.getUIControl()).getShell();
            this.display = this.shell.getDisplay();
            this.control2button = new HashMap<Control, Button>();
            for (Map.Entry<IRidget, IActionRidget> entry : this.ridget2button.entrySet()) {
                Control control = (Control)entry.getKey().getUIControl();
                Assert.isNotNull((Object)control);
                Button button = (Button)entry.getValue().getUIControl();
                Assert.isNotNull((Object)button);
                this.control2button.put(control, button);
            }
            this.updateDefaultButton(this.display.getFocusControl());
            this.display.removeFilter(15, (Listener)this);
            this.display.addFilter(15, (Listener)this);
        }
    }

    public void deactivate() {
        if (this.display != null) {
            this.display.removeFilter(15, (Listener)this);
            this.display = null;
        }
        if (this.shell != null) {
            this.clearDefaultButton(this.shell);
            this.shell = null;
        }
        this.control2button = null;
    }

    public void dispose() {
        this.deactivate();
        this.ridget2button.clear();
    }

    public void handleEvent(Event event) {
        if (15 == event.type && event.widget instanceof Control) {
            Control control = (Control)event.widget;
            this.updateDefaultButton(control);
        }
    }

    private void clearDefaultButton(Shell shell) {
        if (!SwtUtilities.isDisposed((Widget)shell)) {
            shell.setDefaultButton(null);
            shell.setDefaultButton(null);
        }
    }

    private Button findDefaultButton(Control start) {
        Button result = null;
        Control control = start;
        while (result == null && control != null) {
            result = this.control2button.get(control);
            control = control.getParent();
        }
        return result;
    }

    private void updateDefaultButton(Control control) {
        Button button = this.findDefaultButton(control);
        if (SwtUtilities.isDisposed((Widget)button)) {
            this.clearDefaultButton(this.shell);
            return;
        }
        if (button != this.shell.getDefaultButton()) {
            this.shell.setDefaultButton(button);
        }
    }
}

