/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets.swt;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.BindingException;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateListStrategy;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.riena.core.marker.IMarker;
import org.eclipse.riena.core.util.ListenerList;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.core.util.StringUtils;
import org.eclipse.riena.ui.core.marker.ErrorMarker;
import org.eclipse.riena.ui.core.marker.ErrorMessageMarker;
import org.eclipse.riena.ui.ridgets.IColumnFormatter;
import org.eclipse.riena.ui.ridgets.IComboRidget;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.listener.ISelectionListener;
import org.eclipse.riena.ui.ridgets.swt.AbstractSWTRidget;
import org.eclipse.riena.ui.ridgets.swt.AbstractSWTWidgetRidget;
import org.eclipse.riena.ui.ridgets.swt.MarkerSupport;
import org.eclipse.riena.ui.ridgets.swt.nls.Messages;
import org.eclipse.riena.ui.swt.CompletionCombo;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractComboRidget
extends AbstractSWTRidget
implements IComboRidget {
    protected final IObservableList rowObservables = new WritableList();
    protected final IObservableValue selectionObservable = new WritableValue();
    private final SelectionBindingValidator selectionValidator;
    private final SelectionEnforcer selectionEnforcer;
    private final IValueChangeListener valueChangeNotifier;
    private ListenerList<ISelectionListener> selectionListeners;
    private Object emptySelection;
    private IObservableList optionValues;
    private Class<? extends Object> rowClass = null;
    private IObservableValue selectionValue;
    private IColumnFormatter formatter;
    private String renderingMethod;
    private IConverter objToStrConverter = new ObjectToStringConverter();
    private IConverter strToObjConverter = new StringToObjectConverter();
    private List<String> items;
    private Binding listBindingExternal;
    private Binding selectionBindingInternal;
    private Binding selectionBindingExternal;
    private boolean markSelectionMismatch;
    private ErrorMarker selectionMismatchMarker;
    private String text = "";

    public AbstractComboRidget() {
        this.selectionValidator = new SelectionBindingValidator();
        this.selectionEnforcer = new SelectionEnforcer();
        this.valueChangeNotifier = new ValueChangeNotifier();
        this.addPropertyChangeListener("enabled", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                AbstractComboRidget.this.applyEnabled();
            }
        });
        this.addPropertyChangeListener("output", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (AbstractComboRidget.this.getUIControl() != null) {
                    AbstractComboRidget.this.updateEditable();
                }
            }
        });
    }

    @Override
    protected void bindUIControl() {
        if (this.getUIControl() != null) {
            this.applyText();
            this.addTextModifyListener();
            this.addSelectionListener((SelectionListener)this.selectionEnforcer);
            this.updateEditable();
        }
        if (this.optionValues != null) {
            DataBindingContext dbc = new DataBindingContext();
            if (this.getUIControl() != null) {
                this.applyEnabled();
            }
            this.listBindingExternal = dbc.bindList(this.rowObservables, this.optionValues, new UpdateListStrategy(UpdateListStrategy.POLICY_ON_REQUEST), new UpdateListStrategy(UpdateListStrategy.POLICY_ON_REQUEST));
            this.selectionBindingExternal = dbc.bindValue(this.selectionObservable, this.selectionValue, new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE).setAfterGetValidator((IValidator)this.selectionValidator), new UpdateValueStrategy(UpdateValueStrategy.POLICY_ON_REQUEST));
            this.selectionObservable.removeValueChangeListener(this.valueChangeNotifier);
            this.selectionObservable.addValueChangeListener(this.valueChangeNotifier);
        }
        this.selectionEnforcer.saveSelection();
    }

    @Override
    protected void unbindUIControl() {
        super.unbindUIControl();
        if (this.getUIControl() != null) {
            this.removeTextModifyListener();
            this.removeSelectionListener((SelectionListener)this.selectionEnforcer);
        }
        this.disposeBinding(this.listBindingExternal);
        this.listBindingExternal = null;
        this.disposeBinding(this.selectionBindingInternal);
        this.selectionBindingInternal = null;
        this.disposeBinding(this.selectionBindingExternal);
        this.selectionBindingExternal = null;
    }

    protected final IColumnFormatter getColumnFormatter() {
        return this.formatter;
    }

    public void addSelectionListener(ISelectionListener selectionListener) {
        Assert.isNotNull((Object)selectionListener, (String)"selectionListener is null");
        if (this.selectionListeners == null) {
            this.selectionListeners = new ListenerList(ISelectionListener.class);
            this.addPropertyChangeListener("selection", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    AbstractComboRidget.this.notifySelectionListeners(evt.getOldValue(), evt.getNewValue());
                }
            });
        }
        this.selectionListeners.add((Object)selectionListener);
    }

    public void removeSelectionListener(ISelectionListener selectionListener) {
        if (this.selectionListeners != null) {
            this.selectionListeners.remove((Object)selectionListener);
        }
    }

    public void bindToModel(IObservableList optionValues, Class<? extends Object> rowClass, String renderingMethod, IObservableValue selectionValue) {
        this.unbindUIControl();
        this.optionValues = optionValues;
        this.rowClass = rowClass;
        this.renderingMethod = renderingMethod;
        this.selectionValue = selectionValue;
        this.bindUIControl();
    }

    public void bindToModel(Object listHolder, String listPropertyName, Class<? extends Object> rowClass, String renderingMethod, Object selectionHolder, String selectionPropertyName) {
        IObservableList listObservableValue = AbstractSWTWidgetRidget.isBean(rowClass) ? BeansObservables.observeList((Object)listHolder, (String)listPropertyName) : PojoObservables.observeList((Object)listHolder, (String)listPropertyName);
        IObservableValue selectionObservableValue = AbstractSWTWidgetRidget.isBean(selectionHolder.getClass()) ? BeansObservables.observeValue((Object)selectionHolder, (String)selectionPropertyName) : PojoObservables.observeValue((Object)selectionHolder, (String)selectionPropertyName);
        this.bindToModel(listObservableValue, rowClass, renderingMethod, selectionObservableValue);
    }

    public Object getEmptySelectionItem() {
        return this.emptySelection;
    }

    public IObservableList getObservableList() {
        return this.rowObservables;
    }

    public String getText() {
        return this.text;
    }

    public Object getSelection() {
        Object selection = this.selectionObservable.getValue();
        return selection == this.emptySelection ? null : selection;
    }

    public int getSelectionIndex() {
        int result = -1;
        Object selection = this.selectionObservable.getValue();
        if (this.emptySelection != selection) {
            result = this.rowObservables.indexOf(selection);
        }
        return result;
    }

    @Override
    public boolean isDisableMandatoryMarker() {
        return this.hasInput();
    }

    public boolean isMarkSelectionMismatch() {
        return this.markSelectionMismatch;
    }

    public void setColumnFormatter(IColumnFormatter formatter) {
        this.formatter = formatter;
    }

    public void setEmptySelectionItem(Object emptySelection) {
        this.emptySelection = emptySelection;
    }

    public void setMarkSelectionMismatch(boolean mark) {
        if (mark != this.markSelectionMismatch) {
            if (mark && this.selectionMismatchMarker == null) {
                this.selectionMismatchMarker = new ErrorMessageMarker(Messages.AbstractComboRidget_markerMessage_selectionMismatch);
            }
            this.markSelectionMismatch = mark;
            this.applyMarkSelectionMismatch();
        }
    }

    public void setSelection(Object newSelection) {
        this.assertIsBoundToModel();
        Object oldSelection = this.selectionObservable.getValue();
        if (oldSelection != newSelection) {
            if (!(newSelection != null && this.rowObservables.contains(newSelection) || this.getUIControl() == null)) {
                this.clearUIControlListSelection();
            }
            this.selectionObservable.setValue(newSelection);
            this.selectionEnforcer.saveSelection();
        }
    }

    public void setSelection(int index) {
        if (index == -1) {
            this.setSelection(null);
        } else {
            Object newSelection = this.rowObservables.get(index);
            this.setSelection(newSelection);
        }
    }

    public void setText(String text) {
        Assert.isNotNull((Object)text);
        if (!StringUtils.equals((CharSequence)text, (CharSequence)this.text)) {
            String oldText = this.text;
            this.text = text;
            this.firePropertyChange("text", oldText, this.text);
            this.applyText();
        }
    }

    public void setModelToUIControlConverter(IConverter converter) {
        this.objToStrConverter = converter != null ? converter : new ObjectToStringConverter();
    }

    public void setUIControlToModelConverter(IConverter converter) {
        this.strToObjConverter = converter != null ? converter : new StringToObjectConverter();
    }

    public void updateFromModel() {
        if (this.optionValues == null) {
            return;
        }
        this.assertIsBoundToModel();
        super.updateFromModel();
        this.selectionValidator.enableBinding(false);
        try {
            this.listBindingExternal.updateModelToTarget();
            this.items = new ArrayList<String>();
            this.updateValueToItem();
        }
        finally {
            this.selectionValidator.enableBinding(true);
        }
        this.selectionBindingExternal.updateModelToTarget();
        if (this.selectionBindingInternal != null) {
            this.selectionBindingInternal.updateModelToTarget();
        }
        this.applyMarkSelectionMismatch();
        this.selectionEnforcer.saveSelection();
    }

    protected void assertIsBoundToModel() {
        if (this.optionValues == null) {
            String msg = String.format("ridget with ID '%s' is not bound to  a model", this.getID());
            throw new BindingException(msg);
        }
    }

    protected abstract void addSelectionListener(SelectionListener var1);

    protected abstract void addTextModifyListener();

    protected abstract void clearUIControlListSelection();

    protected abstract String[] getUIControlItems();

    protected abstract IObservableList getUIControlItemsObservable();

    protected abstract ISWTObservableValue getUIControlSelectionObservable();

    protected abstract String getUIControlText();

    protected abstract void selectInUIControl(int var1);

    protected abstract int indexOfInUIControl(String var1);

    protected abstract void removeAllFromUIControl();

    protected abstract void removeSelectionListener(SelectionListener var1);

    protected abstract void removeTextModifyListener();

    protected abstract void setItemsToControl(String[] var1);

    protected abstract void setTextToControl(String var1);

    protected abstract void updateEditable();

    private void applyEnabled() {
        if (super.isEnabled()) {
            this.bindControlToSelectionAndUpdate();
        } else {
            this.unbindControlFromSelectionAndClear();
        }
    }

    private void applyText() {
        if (this.getUIControl() != null && !StringUtils.equals((CharSequence)this.text, (CharSequence)this.getUIControlText())) {
            this.setTextToControl(this.text);
        }
    }

    private void applyMarkSelectionMismatch() {
        Object selection = this.selectionObservable.getValue();
        if (this.markSelectionMismatch && selection != null && !this.rowObservables.contains(selection)) {
            Assert.isNotNull((Object)this.markSelectionMismatch);
            this.addMarker((IMarker)this.selectionMismatchMarker);
        } else if (this.selectionMismatchMarker != null) {
            this.removeMarker((IMarker)this.selectionMismatchMarker);
        }
    }

    private void bindControlToSelectionAndUpdate() {
        if (this.getUIControl() != null) {
            this.updateValueToItem();
            ISWTObservableValue controlSelection = this.getUIControlSelectionObservable();
            UpdateValueStrategy controlSelectionBindingStrategy = new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE);
            controlSelectionBindingStrategy.setConverter(this.strToObjConverter).setAfterGetValidator((IValidator)this.selectionValidator);
            controlSelectionBindingStrategy.setBeforeSetValidator(new IValidator(){

                public IStatus validate(Object value) {
                    if (AbstractComboRidget.this.isOutputOnly()) {
                        return Status.CANCEL_STATUS;
                    }
                    return Status.OK_STATUS;
                }
            });
            DataBindingContext dbc = new DataBindingContext();
            this.selectionBindingInternal = dbc.bindValue((IObservableValue)controlSelection, this.selectionObservable, controlSelectionBindingStrategy, new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE).setConverter(this.objToStrConverter));
            this.selectionBindingInternal.updateModelToTarget();
        }
    }

    private void disposeBinding(Binding binding) {
        if (binding != null && !binding.isDisposed()) {
            binding.dispose();
        }
    }

    private String getItemFromValue(Object value) {
        Object valueObject = value;
        if (valueObject != null && this.formatter != null) {
            valueObject = this.formatter.getText(value);
        }
        if (valueObject != null && this.renderingMethod != null) {
            valueObject = ReflectionUtils.invoke((Object)value, (String)this.renderingMethod, null);
        }
        String result = valueObject == null || valueObject.toString() == null ? "" : valueObject.toString();
        return result;
    }

    private Object getValueFromItem(String item) {
        String[] uiItems = this.getUIControlItems();
        int i = 0;
        while (i < uiItems.length) {
            if (uiItems[i].equals(item)) {
                return this.rowObservables.get(i);
            }
            ++i;
        }
        if (this.rowClass == String.class) {
            return "";
        }
        return null;
    }

    private boolean hasInput() {
        Object selection = this.selectionObservable.getValue();
        return selection != null && selection != this.emptySelection;
    }

    private void notifySelectionListeners(Object oldValue, Object newValue) {
        if (this.selectionListeners != null) {
            ArrayList<Object> oldSelectionList = new ArrayList<Object>();
            if (oldValue != null) {
                oldSelectionList.add(oldValue);
            }
            ArrayList<Object> newSelectionList = new ArrayList<Object>();
            if (newValue != null) {
                newSelectionList.add(newValue);
            }
            org.eclipse.riena.ui.ridgets.listener.SelectionEvent event = new org.eclipse.riena.ui.ridgets.listener.SelectionEvent((IRidget)this, oldSelectionList, newSelectionList);
            ISelectionListener[] iSelectionListenerArray = (ISelectionListener[])this.selectionListeners.getListeners();
            int n = iSelectionListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                ISelectionListener listener = iSelectionListenerArray[n2];
                listener.ridgetSelected(event);
                ++n2;
            }
        }
    }

    private void unbindControlFromSelectionAndClear() {
        if (this.getUIControl() != null && !super.isEnabled()) {
            this.disposeBinding(this.selectionBindingInternal);
            this.selectionBindingInternal = null;
            if (MarkerSupport.isHideDisabledRidgetContent()) {
                this.removeAllFromUIControl();
            }
        }
    }

    private void updateValueToItem() {
        if (this.items != null) {
            this.items.clear();
            try {
                for (Object value : this.rowObservables) {
                    if (value == null || value.toString() == null) {
                        throw new NullPointerException("The item value for a model element is null");
                    }
                    String item = (String)this.objToStrConverter.convert(value);
                    this.items.add(item);
                }
            }
            finally {
                if (this.getUIControl() != null) {
                    String[] arrItems = this.items.toArray(new String[this.items.size()]);
                    this.setItemsToControl(arrItems);
                }
            }
        }
    }

    private final class ObjectToStringConverter
    extends Converter {
        public ObjectToStringConverter() {
            super(Object.class, String.class);
        }

        public Object convert(Object fromObject) {
            return AbstractComboRidget.this.getItemFromValue(fromObject);
        }
    }

    private final class SelectionBindingValidator
    implements IValidator {
        private boolean isEnabled = true;

        private SelectionBindingValidator() {
        }

        public IStatus validate(Object value) {
            IStatus result = Status.OK_STATUS;
            if (!this.isEnabled) {
                result = Status.CANCEL_STATUS;
            }
            return result;
        }

        void enableBinding(boolean isEnabled) {
            this.isEnabled = isEnabled;
        }
    }

    private final class SelectionEnforcer
    extends SelectionAdapter {
        private int selectionIndex;

        private SelectionEnforcer() {
        }

        public void widgetSelected(SelectionEvent e) {
            if (AbstractComboRidget.this.getUIControl() != null && AbstractComboRidget.this.isOutputOnly()) {
                Widget uiControl = e.widget;
                this.resetSelection(uiControl);
            }
        }

        public void saveSelection() {
            if (this.isBound()) {
                this.selectionIndex = AbstractComboRidget.this.getSelectionIndex();
            }
        }

        private boolean isBound() {
            return AbstractComboRidget.this.listBindingExternal != null && AbstractComboRidget.this.selectionBindingExternal != null;
        }

        private void resetSelection(Widget uiControl) {
            if (uiControl instanceof CCombo) {
                if (this.selectionIndex == -1) {
                    ((CCombo)uiControl).deselectAll();
                } else {
                    ((CCombo)uiControl).select(this.selectionIndex);
                }
            } else if (uiControl instanceof Combo) {
                if (this.selectionIndex == -1) {
                    ((Combo)uiControl).deselectAll();
                } else {
                    ((Combo)uiControl).select(this.selectionIndex);
                }
            } else if (uiControl instanceof CompletionCombo) {
                if (this.selectionIndex == -1) {
                    ((CompletionCombo)uiControl).deselectAll();
                } else {
                    ((CompletionCombo)uiControl).select(this.selectionIndex);
                }
            }
        }
    }

    private final class StringToObjectConverter
    extends Converter {
        public StringToObjectConverter() {
            super(String.class, Object.class);
        }

        public Object convert(Object fromObject) {
            return AbstractComboRidget.this.getValueFromItem((String)fromObject);
        }
    }

    private final class ValueChangeNotifier
    implements IValueChangeListener {
        private ValueChangeNotifier() {
        }

        public void handleValueChange(ValueChangeEvent event) {
            Object oldValue = event.diff.getOldValue();
            Object newValue = event.diff.getNewValue();
            try {
                AbstractComboRidget.this.firePropertyChange("selection", oldValue, newValue);
            }
            finally {
                AbstractComboRidget.this.disableMandatoryMarkers(AbstractComboRidget.this.hasInput());
                AbstractComboRidget.this.applyMarkSelectionMismatch();
            }
        }
    }
}

