/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets.swt;

import org.eclipse.core.runtime.Assert;
import org.eclipse.riena.ui.ridgets.IMarkableRidget;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.swt.AbstractSWTRidget;
import org.eclipse.riena.ui.swt.ChoiceComposite;
import org.eclipse.riena.ui.swt.CompletionCombo;
import org.eclipse.riena.ui.swt.utils.SWTBindingPropertyLocator;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public final class FocusManager
extends MouseAdapter
implements FocusListener {
    private final AbstractSWTRidget ridget;
    private boolean clickToFocus;

    FocusManager(AbstractSWTRidget ridget) {
        Assert.isNotNull((Object)((Object)ridget));
        this.ridget = ridget;
    }

    public void addListeners(Control control) {
        control.addFocusListener((FocusListener)this);
        control.addMouseListener((MouseListener)this);
    }

    public void focusGained(FocusEvent e) {
        if (this.isFocusable()) {
            this.ridget.fireFocusGained();
        } else {
            Control target = this.findFocusTarget((Control)e.widget);
            if (target != null) {
                target.setFocus();
            } else {
                Composite topControl = this.findTopContentComposite((Control)e.widget);
                target = this.findFocusTarget(null, topControl);
                if (target != null) {
                    target.setFocus();
                }
            }
        }
    }

    private Composite findTopContentComposite(Control startControl) {
        Shell result = null;
        Composite start = startControl instanceof Composite ? (Composite)startControl : startControl.getParent();
        while (start != null && result == null) {
            if (start.getData("contentComposite") != null) {
                result = start;
            }
            start = start.getParent();
        }
        if (result == null) {
            result = startControl.getShell();
        }
        return result;
    }

    public boolean isClickToFocus() {
        return this.clickToFocus;
    }

    public void focusLost(FocusEvent e) {
        if (this.isFocusable()) {
            this.clickToFocus = false;
            this.ridget.fireFocusLost();
        }
    }

    public void mouseDown(MouseEvent e) {
        if (this.ridget.isFocusable() && this.ridget.isOutputOnly()) {
            this.clickToFocus = true;
            ((Control)e.widget).setFocus();
        }
    }

    public void removeListeners(Control control) {
        if (!control.isDisposed()) {
            control.removeFocusListener((FocusListener)this);
            control.removeMouseListener((MouseListener)this);
        }
    }

    private boolean canGetFocus(Control control) {
        if (!control.isEnabled() || !control.isVisible()) {
            return false;
        }
        if (SwtUtilities.hasStyle((Widget)control, (int)8)) {
            return false;
        }
        if (control instanceof Text && !((Text)control).getEditable()) {
            return false;
        }
        if (control instanceof ChoiceComposite && !((ChoiceComposite)control).getEditable()) {
            return false;
        }
        if (control instanceof CompletionCombo && !((CompletionCombo)control).getEditable()) {
            return false;
        }
        String bindingId = SWTBindingPropertyLocator.getInstance().locateBindingProperty((Object)control);
        if (bindingId != null) {
            IRidget controlsRidget = this.ridget.getController().getRidget(bindingId);
            if (controlsRidget instanceof IMarkableRidget) {
                IMarkableRidget markableRidget = (IMarkableRidget)controlsRidget;
                return markableRidget.isFocusable() && !markableRidget.isOutputOnly();
            }
            if (controlsRidget instanceof AbstractSWTRidget) {
                return this.isFocusable((AbstractSWTRidget)controlsRidget);
            }
        }
        if (control instanceof Composite) {
            return this.findFocusTarget(null, (Composite)control) != null;
        }
        return true;
    }

    private Control findFocusTarget(Control startControl) {
        Control result = null;
        Control start = startControl;
        while (start.getParent() != null && result == null) {
            Composite parent = start.getParent();
            result = this.findFocusTarget(start, parent);
            start = parent;
        }
        return result;
    }

    private Control findFocusTarget(Control start, Composite parent) {
        Control result = null;
        Control[] siblings = parent.getTabList();
        int myIndex = -1;
        int i = 0;
        while (myIndex == -1 && i < siblings.length) {
            if (siblings[i] == start) {
                myIndex = i;
            }
            ++i;
        }
        i = myIndex + 1;
        while (result == null && i < siblings.length) {
            Control candidate = siblings[i];
            if (this.canGetFocus(candidate)) {
                result = candidate;
            }
            ++i;
        }
        return result;
    }

    private boolean isFocusable() {
        return this.isFocusable(this.ridget);
    }

    private boolean isFocusable(AbstractSWTRidget ridget) {
        return ridget.isFocusable() && !ridget.isOutputOnly() || ridget.getFocusManager().isClickToFocus();
    }

    private void trace(String format, Object ... args) {
        System.out.println(String.format(format, args));
    }
}

