/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.communication.core.hooks;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.riena.communication.core.RemoteServiceDescription;
import org.eclipse.riena.communication.core.hooks.ICallMessageContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CallContext {
    private final RemoteServiceDescription rsd;
    private final String methodName;
    private HashMap<String, String> properties;
    private final ICallMessageContext messageContext;
    private boolean hasRemoteFailure;

    public CallContext(RemoteServiceDescription rsd, String methodName, ICallMessageContext messageContext) {
        this.rsd = rsd;
        this.methodName = methodName;
        this.messageContext = messageContext;
    }

    public String getInterfaceName() {
        return this.rsd.getServiceInterfaceClassName();
    }

    public Class<?> getInterfaceClass() {
        return this.rsd.getServiceInterfaceClass();
    }

    public String getMethodName() {
        return this.methodName;
    }

    public Method getMethod() {
        Class<?> interf = this.getInterfaceClass();
        Method[] methods = interf.getMethods();
        Method foundMethod = null;
        Method[] methodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.getName().equals(this.methodName)) {
                if (foundMethod == null) {
                    foundMethod = method;
                } else {
                    throw new UnsupportedOperationException("More than one method with the same name '" + this.methodName + "' found.");
                }
            }
            ++n2;
        }
        return foundMethod;
    }

    public void setProperty(String name, String value) {
        if (this.properties == null) {
            this.properties = new HashMap();
        }
        this.properties.put(name, value);
    }

    public String getProperty(String name) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(name);
    }

    public ICallMessageContext getMessageContext() {
        return this.messageContext;
    }

    public void setCookie(String name, String value) {
        this.messageContext.addRequestHeader("Cookie", String.valueOf(name) + "=" + value);
    }

    public Map<String, String> getSetCookies() {
        Map<String, List<String>> respHeaders = this.messageContext.listResponseHeaders();
        if (respHeaders == null) {
            return null;
        }
        List<String> listSetCookies = respHeaders.get("Set-Cookie");
        if (listSetCookies == null) {
            return null;
        }
        HashMap<String, String> setCookies = new HashMap<String, String>();
        for (String temp : listSetCookies) {
            setCookies.put(temp.substring(0, temp.indexOf("=")), temp.substring(temp.indexOf("=") + 1));
        }
        return setCookies;
    }

    public boolean hasRemoteFailure() {
        return this.hasRemoteFailure;
    }

    public void setRemoteFailure(boolean hasRemoteFailure) {
        this.hasRemoteFailure = hasRemoteFailure;
    }
}

