/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.communication.publisher;

import org.eclipse.core.runtime.Assert;
import org.eclipse.riena.communication.core.publisher.IServicePublishBinder;
import org.eclipse.riena.core.injector.Inject;
import org.eclipse.riena.internal.communication.publisher.Activator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

public class SingleServicePublisher {
    private final String serviceName;
    private String filter;
    private BundleContext context;
    private String path;
    private String protocol;
    private IServicePublishBinder binder;

    public SingleServicePublisher(String name) {
        this.serviceName = name;
        Inject.service(IServicePublishBinder.class).useRanking().into((Object)this).andStart(Activator.getDefault().getContext());
    }

    public SingleServicePublisher useFilter(String filter) {
        Assert.isNotNull((Object)filter);
        this.filter = filter;
        return this;
    }

    public SingleServicePublisher usingPath(String path) {
        Assert.isNotNull((Object)path);
        this.path = path;
        return this;
    }

    public SingleServicePublisher withProtocol(String protocol) {
        Assert.isNotNull((Object)protocol);
        this.protocol = protocol;
        return this;
    }

    public void andStart(BundleContext context) {
        this.context = context;
        Assert.isNotNull((Object)this.path);
        Assert.isNotNull((Object)this.protocol);
        try {
            ServiceReference[] refs = this.context.getServiceReferences(this.serviceName, this.filter);
            if (refs != null) {
                ServiceReference[] serviceReferenceArray = refs;
                int n = refs.length;
                int n2 = 0;
                while (n2 < n) {
                    ServiceReference ref = serviceReferenceArray[n2];
                    this.publish(ref);
                    ++n2;
                }
            }
        }
        catch (InvalidSyntaxException e1) {
            e1.printStackTrace();
        }
        ServiceListener listener = new ServiceListener(){

            public void serviceChanged(ServiceEvent event) {
                String[] serviceInterfaces;
                String[] stringArray = serviceInterfaces = (String[])event.getServiceReference().getProperty("objectClass");
                int n = serviceInterfaces.length;
                int n2 = 0;
                while (n2 < n) {
                    String serviceInterf = stringArray[n2];
                    if (serviceInterf.equals(SingleServicePublisher.this.serviceName)) {
                        if (event.getType() == 1) {
                            SingleServicePublisher.this.publish(event.getServiceReference());
                        } else if (event.getType() == 4) {
                            SingleServicePublisher.this.unpublish(event.getServiceReference());
                        }
                    }
                    ++n2;
                }
            }
        };
        try {
            Activator.getDefault().getContext().addServiceListener(listener, this.filter);
        }
        catch (InvalidSyntaxException e) {
            e.printStackTrace();
        }
    }

    public void bind(IServicePublishBinder binder) {
        this.binder = binder;
    }

    public void unbind(IServicePublishBinder binder) {
        this.binder = null;
    }

    private void publish(ServiceReference serviceReference) {
        this.binder.publish(serviceReference, this.path, this.protocol);
    }

    private void unpublish(ServiceReference serviceReference) {
        this.binder.unpublish(serviceReference);
    }
}

