/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core.ping;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.eclipse.riena.core.ping.IPingable;
import org.eclipse.riena.core.ping.PingFingerprint;
import org.eclipse.riena.core.ping.PingMethodAdapter;
import org.eclipse.riena.core.ping.PingResult;
import org.eclipse.riena.core.ping.UnavailablePingable;
import org.eclipse.riena.core.util.Nop;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PingVisitor {
    protected final List<PingFingerprint> cycleDectector = new ArrayList<PingFingerprint>();
    protected final List<PingResult> pingResultList = new ArrayList<PingResult>();
    protected final Stack<PingResult> resultStack = new Stack();
    private final String name = "PingVisitor#" + System.identityHashCode(this);

    public String toString() {
        return this.name;
    }

    public List<PingResult> getPingResults() {
        return this.pingResultList;
    }

    public PingVisitor visit(IPingable pingable) {
        PingVisitor visitor = this;
        PingFingerprint fingerprint = null;
        fingerprint = pingable.getPingFingerprint();
        if (this.cycleDectector.contains(fingerprint)) {
            return visitor;
        }
        this.cycleDectector.add(fingerprint);
        if (pingable instanceof PingMethodAdapter) {
            return visitor;
        }
        try {
            Collection<IPingable> children = this.getChildPingablesOf(pingable);
            for (IPingable child : children) {
                visitor = visitor.ping(child);
            }
        }
        finally {
            visitor.cycleDectector.remove(fingerprint);
        }
        return visitor;
    }

    public PingVisitor ping(IPingable pingable) {
        PingVisitor visitor = this;
        PingResult pingResult = new PingResult(PingVisitor.getPingableName(pingable));
        if (this.resultStack.isEmpty()) {
            this.pingResultList.add(pingResult);
        } else {
            PingResult parent = this.resultStack.peek();
            parent.addNestedResult(pingResult);
        }
        this.resultStack.push(pingResult);
        Exception caughtException = null;
        try {
            try {
                visitor = pingable.ping(visitor);
            }
            catch (Exception e) {
                caughtException = e;
                pingResult = visitor.resultStack.pop();
                pingResult.setPingFailure(caughtException);
            }
        }
        finally {
            pingResult = visitor.resultStack.pop();
            pingResult.setPingFailure(caughtException);
        }
        return visitor;
    }

    public Collection<IPingable> getChildPingablesOf(IPingable pingable) {
        HashSet<IPingable> pingableList = new HashSet<IPingable>();
        this.collectPingableMembers(pingable, pingableList);
        this.collectPingMethods(pingable, pingableList);
        this.collectAdditionalPingables(pingable, pingableList);
        return pingableList;
    }

    public void collectPingMethods(IPingable pingable, Set<IPingable> pingableList) {
        this.collectPingMethods(pingable.getClass(), pingable, pingableList);
    }

    private void collectPingMethods(Class<?> clazz, IPingable pingable, Set<IPingable> pingableList) {
        Method[] methods;
        Method[] methodArray = methods = clazz.getDeclaredMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (PingVisitor.isPingMethod(pingable, method)) {
                this.setAccessible(method);
                pingableList.add(new PingMethodAdapter(pingable, method));
            }
            ++n2;
        }
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != null) {
            this.collectPingMethods(superClass, pingable, pingableList);
        }
    }

    public void collectPingableMembers(IPingable pingable, Set<IPingable> pingableList) {
        Field[] fields;
        Field[] fieldArray = fields = pingable.getClass().getDeclaredFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (IPingable.class.isAssignableFrom(field.getType())) {
                try {
                    this.setAccessible(field);
                    if (field.get(pingable) != null) {
                        pingableList.add((IPingable)field.get(pingable));
                    }
                }
                catch (Exception e) {
                    pingableList.add(new UnavailablePingable(field.getName(), "Pingable member " + field.getName() + " not accessible: " + e.getMessage()));
                }
            }
            ++n2;
        }
    }

    public void collectAdditionalPingables(IPingable pingable, Set<IPingable> pingableList) {
        this.collectAdditionalPingables(pingable.getClass(), pingable, pingableList);
    }

    private void collectAdditionalPingables(Class<?> clazz, IPingable pingable, Set<IPingable> pingableList) {
        Class<?> superClass;
        try {
            Method method = clazz.getDeclaredMethod("getAdditionalPingables", new Class[0]);
            this.setAccessible(method);
            Type returnType = method.getGenericReturnType();
            if (this.isIterableOfPingables(returnType)) {
                Iterable pingables = (Iterable)method.invoke((Object)pingable, new Object[0]);
                for (IPingable additionalPingable : pingables) {
                    pingableList.add(additionalPingable);
                }
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Nop.reason("no getAdditionalPingables() method");
        }
        catch (Exception e) {
            pingableList.add(new UnavailablePingable("getAdditionalPingables", "Method getAdditionalPingables() not accessible: " + e.getMessage()));
        }
        if ((superClass = clazz.getSuperclass()) != null) {
            this.collectAdditionalPingables(superClass, pingable, pingableList);
        }
    }

    private void setAccessible(Method method) {
        try {
            method.setAccessible(true);
        }
        catch (SecurityException securityException) {
            Nop.reason("security restriction, hopefully it's public :-|");
        }
    }

    private void setAccessible(Field field) {
        try {
            field.setAccessible(true);
        }
        catch (SecurityException securityException) {
            Nop.reason("security restriction, hopefully it's public :-|");
        }
    }

    private boolean isIterableOfPingables(Type returnType) {
        if (!(returnType instanceof ParameterizedType)) {
            return false;
        }
        ParameterizedType parameterizedType = (ParameterizedType)returnType;
        if (parameterizedType.getRawType() != Iterable.class) {
            return false;
        }
        Type[] types = parameterizedType.getActualTypeArguments();
        if (types.length != 1) {
            return false;
        }
        Type type = types[0];
        if (type instanceof WildcardType) {
            types = ((WildcardType)type).getUpperBounds();
            if (types.length != 1) {
                return false;
            }
            type = types[0];
        }
        return type instanceof Class && ((Class)type).getName().equals(IPingable.class.getName());
    }

    protected static boolean isPingMethod(IPingable pingable, Method method) {
        if (!method.getName().startsWith("ping")) {
            return false;
        }
        if (method.getName().length() <= 4) {
            return false;
        }
        if (!Character.isUpperCase(method.getName().charAt(4))) {
            return false;
        }
        if (method.getParameterTypes().length != 0) {
            return false;
        }
        return method.getReturnType() == Void.TYPE;
    }

    private static String getPingableName(IPingable pingable) {
        try {
            return pingable.getPingFingerprint().getName();
        }
        catch (Exception exception) {
            return pingable.toString();
        }
    }
}

