/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core.util;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.equinox.log.Logger;
import org.eclipse.riena.core.Log4r;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeakRef<T> {
    private final Reference<T> ref;
    private static final ReferenceQueue<? super Object> REF_QUEUE = new ReferenceQueue();
    private static final Map<Reference<?>, Runnable> REMOVE_ACTIONS = new HashMap();
    private static final Logger LOGGER;

    static {
        new Remover();
        LOGGER = Log4r.getLogger(WeakRef.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WeakRef(T referent, Runnable runnable) {
        this.ref = new WeakReference<Object>(referent, REF_QUEUE);
        Map<Reference<?>, Runnable> map = REMOVE_ACTIONS;
        synchronized (map) {
            REMOVE_ACTIONS.put(this.ref, runnable);
        }
    }

    public T get() {
        return this.ref.get();
    }

    private static class Remover
    extends Thread {
        public Remover() {
            super("WeakRef remover");
            this.setDaemon(true);
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                while (true) {
                    Runnable runnable;
                    Reference removed = REF_QUEUE.remove();
                    Map map = REMOVE_ACTIONS;
                    synchronized (map) {
                        runnable = (Runnable)REMOVE_ACTIONS.remove(removed);
                    }
                    if (runnable == null) continue;
                    try {
                        runnable.run();
                    }
                    catch (Throwable t) {
                        LOGGER.log(1, "Got exception executing remove notification.", t);
                    }
                }
            }
            catch (InterruptedException e) {
                LOGGER.log(1, "WeakRef remover has been interrupted.", (Throwable)e);
                Thread.currentThread().interrupt();
                return;
            }
        }
    }
}

