/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.example.client.controllers;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.riena.internal.navigation.ui.filter.UIFilterRuleMenuItemDisabledMarker;
import org.eclipse.riena.internal.navigation.ui.filter.UIFilterRuleMenuItemHiddenMarker;
import org.eclipse.riena.navigation.ISubApplicationNode;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.ui.controllers.SubModuleController;
import org.eclipse.riena.ui.core.marker.DisabledMarker;
import org.eclipse.riena.ui.core.marker.HiddenMarker;
import org.eclipse.riena.ui.filter.IUIFilter;
import org.eclipse.riena.ui.filter.IUIFilterRule;
import org.eclipse.riena.ui.filter.impl.UIFilter;
import org.eclipse.riena.ui.ridgets.IActionListener;
import org.eclipse.riena.ui.ridgets.IActionRidget;
import org.eclipse.riena.ui.ridgets.IComboRidget;
import org.eclipse.riena.ui.ridgets.ISingleChoiceRidget;
import org.eclipse.riena.ui.ridgets.ITextRidget;

public class FilterActionSubModuleController
extends SubModuleController {
    private IActionRidget addFilter;
    private IComboRidget filterTypeValues;
    private FilterModel filterModel;

    public void afterBind() {
        super.afterBind();
        this.initNavigationFilterGroup();
        this.rebindFilterTypeValues(this.filterModel, this.filterTypeValues, this.addFilter);
    }

    public void configureRidgets() {
        super.configureRidgets();
        this.filterModel = new FilterModel();
        ISingleChoiceRidget filterType = (ISingleChoiceRidget)this.getRidget("filterType");
        filterType.addPropertyChangeListener((PropertyChangeListener)new FilterTypeChangeListener());
        filterType.bindToModel((Object)this.filterModel, "types", (Object)this.filterModel, "selectedType");
        filterType.updateFromModel();
    }

    private void initNavigationFilterGroup() {
        ITextRidget itemId = (ITextRidget)this.getRidget("itemId");
        itemId.bindToModel((Object)this.filterModel, "itemId");
        itemId.updateFromModel();
        this.filterTypeValues = (IComboRidget)this.getRidget("filterTypeValues");
        this.filterTypeValues.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (FilterActionSubModuleController.this.addFilter != null) {
                    FilterActionSubModuleController.this.addFilter.setEnabled(evt.getNewValue() != null);
                }
            }
        });
        this.addFilter = (IActionRidget)this.getRidget("addFilter");
        this.addFilter.addListener(new IActionListener(){

            public void callback() {
                FilterActionSubModuleController.this.doAddFilter();
            }
        });
        IActionRidget removeFilters = (IActionRidget)this.getRidget("removeFilters");
        removeFilters.addListener(new IActionListener(){

            public void callback() {
                FilterActionSubModuleController.this.doRemoveFilters();
            }
        });
    }

    private void rebindFilterTypeValues(FilterModel model, IComboRidget typeValues, IActionRidget add) {
        if (model == null) {
            return;
        }
        model.setSelectedFilterTypeValue(null);
        if (typeValues != null) {
            typeValues.bindToModel((IObservableList)new WritableList(Arrays.asList(model.getSelectedType().getArgs()), Object.class), FilterModel.class, null, PojoObservables.observeValue((Object)model, (String)"selectedFilterTypeValue"));
            typeValues.updateFromModel();
        }
        if (add != null) {
            add.setEnabled(model.getSelectedFilterTypeValue() != null);
        }
    }

    private void doAddFilter() {
        ISubApplicationNode subApp = (ISubApplicationNode)((ISubModuleNode)this.getNavigationNode()).getParentOfType(ISubApplicationNode.class);
        ArrayList<IUIFilterRule> attributes = new ArrayList<IUIFilterRule>(1);
        attributes.add(this.createFilterAttribute(this.filterModel));
        UIFilter filter = new UIFilter(attributes);
        subApp.addFilter((IUIFilter)filter);
    }

    private void doRemoveFilters() {
        ISubApplicationNode subApp = (ISubApplicationNode)((ISubModuleNode)this.getNavigationNode()).getParentOfType(ISubApplicationNode.class);
        subApp.removeAllFilters();
    }

    private IUIFilterRule createFilterAttribute(FilterModel model) {
        UIFilterRuleMenuItemDisabledMarker attribute = null;
        Object filterValue = model.getSelectedFilterTypeValue();
        FilterType type = model.getSelectedType();
        if (type == FilterType.MARKER) {
            if (filterValue instanceof DisabledMarker) {
                attribute = new UIFilterRuleMenuItemDisabledMarker(model.getItemId());
            } else if (filterValue instanceof HiddenMarker) {
                attribute = new UIFilterRuleMenuItemHiddenMarker(model.getItemId());
            }
        }
        return attribute;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FilterModel {
        private String itemId;
        private List<FilterType> types;
        private FilterType selectedType;
        private Object selectedFilterTypeValue;

        public FilterModel() {
            this.setItemId("");
        }

        public List<FilterType> getTypes() {
            if (this.types == null) {
                this.types = new ArrayList<FilterType>();
                this.types.add(FilterType.MARKER);
            }
            return this.types;
        }

        public void setSelectedType(FilterType selectedType) {
            this.selectedType = selectedType;
        }

        public FilterType getSelectedType() {
            if (this.selectedType == null) {
                this.selectedType = this.getTypes().get(0);
            }
            return this.selectedType;
        }

        public void setSelectedFilterTypeValue(Object selectedFilterTypeValue) {
            this.selectedFilterTypeValue = selectedFilterTypeValue;
        }

        public Object getSelectedFilterTypeValue() {
            return this.selectedFilterTypeValue;
        }

        public void setItemId(String itemId) {
            this.itemId = itemId;
        }

        public String getItemId() {
            return this.itemId;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum FilterType {
        MARKER("Marker", new DisabledMarker(), new HiddenMarker());

        private final String text;
        private final Object[] args;

        private FilterType(String text, Object ... args) {
            this.text = text;
            this.args = args;
        }

        public String toString() {
            return this.text;
        }

        public Object[] getArgs() {
            return this.args;
        }
    }

    private class FilterTypeChangeListener
    implements PropertyChangeListener {
        private FilterTypeChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            FilterActionSubModuleController.this.rebindFilterTypeValues(FilterActionSubModuleController.this.filterModel, FilterActionSubModuleController.this.filterTypeValues, FilterActionSubModuleController.this.addFilter);
        }
    }
}

