/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.monitor.client;

import java.io.Serializable;
import org.eclipse.core.runtime.Assert;
import org.eclipse.riena.monitor.client.Category;
import org.eclipse.riena.monitor.client.IAggregator;
import org.eclipse.riena.monitor.client.IClientInfoProvider;
import org.eclipse.riena.monitor.client.ICollector;
import org.eclipse.riena.monitor.common.Collectible;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCollector
implements ICollector {
    private IAggregator aggregator;
    private Category category;
    private IClientInfoProvider clientInfoProvider;
    private boolean started;

    @Override
    public Category getCategory() {
        return this.category;
    }

    @Override
    public void start(IAggregator aggregator, Category category, IClientInfoProvider clientInfoProvider) {
        if (this.started) {
            return;
        }
        Assert.isLegal((aggregator != null ? 1 : 0) != 0, (String)"aggregator must not be null.");
        Assert.isLegal((category != null ? 1 : 0) != 0, (String)"category must not be null.");
        this.aggregator = aggregator;
        this.category = category;
        this.clientInfoProvider = clientInfoProvider;
        this.doStart();
        this.started = true;
    }

    protected void doStart() {
    }

    protected boolean isReady() {
        return this.aggregator != null && this.category != null && this.started;
    }

    @Override
    public void stop() {
        if (!this.started) {
            return;
        }
        this.doStop();
        this.started = false;
    }

    protected void doStop() {
    }

    protected <T extends Serializable> void collect(T payload) {
        if (!this.isReady()) {
            return;
        }
        this.aggregator.collect(new Collectible(this.clientInfoProvider == null ? null : this.clientInfoProvider.getClientInfo(), this.category.getName(), payload));
    }

    protected void triggerTransfer() {
        this.aggregator.triggerTransfer(this.category.getName());
    }
}

