/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.model;

import org.eclipse.riena.navigation.IModuleNode;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.NavigationNodeId;
import org.eclipse.riena.navigation.listener.IModuleNodeListener;
import org.eclipse.riena.navigation.listener.INavigationNodeListener;
import org.eclipse.riena.navigation.model.NavigationNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleNode
extends NavigationNode<IModuleNode, ISubModuleNode, IModuleNodeListener>
implements IModuleNode {
    private boolean presentSingleSubModule;
    private boolean closable;

    public ModuleNode() {
        super(null);
        this.initialize();
    }

    @Override
    public Class<ISubModuleNode> getValidChildType() {
        return ISubModuleNode.class;
    }

    public ModuleNode(NavigationNodeId nodeId) {
        super(nodeId);
        this.initialize();
    }

    public ModuleNode(NavigationNodeId nodeId, String label) {
        super(nodeId, label);
        this.initialize();
    }

    public ModuleNode(String label) {
        this(null, label);
    }

    private void initialize() {
        this.presentSingleSubModule = false;
        this.closable = true;
    }

    @Override
    public void moveTo(NavigationNodeId targetId) {
        this.getNavigationProcessor().move(this, targetId);
    }

    @Override
    public boolean isPresentSingleSubModule() {
        return this.presentSingleSubModule;
    }

    @Override
    public void setPresentSingleSubModule(boolean presentSingleSubModule) {
        this.presentSingleSubModule = presentSingleSubModule;
        this.notifyPresentSingleSubModuleChanged();
    }

    private void notifyPresentSingleSubModuleChanged() {
        for (INavigationNodeListener next : this.getListeners()) {
            if (!(next instanceof IModuleNodeListener)) continue;
            IModuleNodeListener moduleNodeListener = (IModuleNodeListener)next;
            moduleNodeListener.presentSingleSubModuleChanged(this);
        }
    }

    @Override
    public boolean isPresentSubModules() {
        return this.isPresentSingleSubModule() || this.getVisibleChildCount(this) > 1 || this.hasSingleChildWithChildren();
    }

    private boolean hasSingleChildWithChildren() {
        if (this.getVisibleChildCount(this) == 1) {
            for (INavigationNode child : this.getChildren()) {
                if (!child.isVisible() || child.getChildren().isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    private int getVisibleChildCount(INavigationNode<?> node) {
        int result = 0;
        for (INavigationNode child : node.getChildren()) {
            if (!child.isVisible()) continue;
            ++result;
        }
        return result;
    }

    @Override
    public int calcDepth() {
        if (!this.isPresentSubModules()) {
            return 0;
        }
        return this.calcDepth(this);
    }

    private int calcDepth(INavigationNode<?> node) {
        int depth = 0;
        if (node == this || node.isExpanded()) {
            for (INavigationNode child : node.getChildren()) {
                if (!child.isVisible()) continue;
                ++depth;
                depth += this.calcDepth(child);
            }
        }
        return depth;
    }

    @Override
    public boolean isClosable() {
        return this.closable;
    }

    @Override
    public void setClosable(boolean closeable) {
        this.closable = closeable;
    }
}

