/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.sample.snippets;

import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.riena.beans.common.Person;
import org.eclipse.riena.beans.common.PersonFactory;
import org.eclipse.riena.ui.core.marker.ValidationTime;
import org.eclipse.riena.ui.ridgets.AbstractMasterDetailsDelegate;
import org.eclipse.riena.ui.ridgets.IMasterDetailsDelegate;
import org.eclipse.riena.ui.ridgets.IMasterDetailsRidget;
import org.eclipse.riena.ui.ridgets.IRidgetContainer;
import org.eclipse.riena.ui.ridgets.ITextRidget;
import org.eclipse.riena.ui.ridgets.swt.SwtRidgetFactory;
import org.eclipse.riena.ui.ridgets.validation.NotEmpty;
import org.eclipse.riena.ui.swt.MasterDetailsComposite;
import org.eclipse.riena.ui.swt.utils.UIControlsFactory;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public final class SnippetMasterDetailsRidget009 {
    private SnippetMasterDetailsRidget009() {
    }

    public static void main(String[] args) {
        Display display = Display.getDefault();
        Shell shell = new Shell(display);
        shell.setText(SnippetMasterDetailsRidget009.class.getSimpleName());
        shell.setLayout((Layout)new FillLayout());
        PersonMasterDetails details = new PersonMasterDetails((Composite)shell, 0);
        IMasterDetailsRidget ridget = (IMasterDetailsRidget)SwtRidgetFactory.createRidget((Object)((Object)details));
        ridget.setDelegate((IMasterDetailsDelegate)new PersonDelegate());
        WritableList input = new WritableList(PersonFactory.createPersonList(), Person.class);
        String[] properties = new String[]{"lastname", "firstname"};
        String[] headers = new String[]{"Last Name", "First Name"};
        ridget.bindToModel((IObservableList)input, Person.class, properties, headers);
        ridget.updateFromModel();
        shell.pack();
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    private static final class PersonDelegate
    extends AbstractMasterDetailsDelegate {
        private final SimplePerson workingCopy = this.createWorkingCopy();

        private PersonDelegate() {
        }

        public void configureRidgets(IRidgetContainer container) {
            ITextRidget txtLast = (ITextRidget)container.getRidget("txtLast");
            txtLast.bindToModel((Object)this.workingCopy, "last");
            txtLast.addValidationRule((IValidator)new NotEmpty(), ValidationTime.ON_UI_CONTROL_EDIT);
            txtLast.updateFromModel();
            ITextRidget txtFirst = (ITextRidget)container.getRidget("txtFirst");
            txtFirst.bindToModel((Object)this.workingCopy, "first");
            txtFirst.updateFromModel();
        }

        public Object copyBean(Object source, Object target) {
            return null;
        }

        public Object copyMasterEntry(Object source, Object workingCopy) {
            Person from = (Person)source;
            SimplePerson to = (SimplePerson)workingCopy;
            to.setFirst(from.getFirstname());
            to.setLast(from.getLastname());
            return workingCopy;
        }

        public Object copyWorkingCopy(Object workingCopy, Object source) {
            SimplePerson from = (SimplePerson)workingCopy;
            Person to = (Person)source;
            to.setFirstname(from.getFirst());
            to.setLastname(from.getLast());
            return source;
        }

        public Object createMasterEntry() {
            return new Person("", "");
        }

        public SimplePerson createWorkingCopy() {
            return new SimplePerson();
        }

        public SimplePerson getWorkingCopy() {
            return this.workingCopy;
        }

        public boolean isChanged(Object source, Object target) {
            Person p1 = (Person)source;
            SimplePerson p2 = (SimplePerson)target;
            boolean equal = p1.getFirstname().equals(p2.getFirst()) && p1.getLastname().equals(p2.getLast());
            return !equal;
        }

        public String isValid(IRidgetContainer container) {
            ITextRidget txtLast = (ITextRidget)container.getRidget("txtLast");
            if (txtLast.isErrorMarked()) {
                return "'Last Name' is not valid.";
            }
            return null;
        }
    }

    private static final class PersonMasterDetails
    extends MasterDetailsComposite {
        PersonMasterDetails(Composite parent, int style) {
            super(parent, style, 1024);
            this.setMargins(5, 5);
        }

        protected void createDetails(Composite parent) {
            GridLayoutFactory.fillDefaults().numColumns(2).margins(20, 20).spacing(10, 10).equalWidth(false).applyTo(parent);
            GridDataFactory hFill = GridDataFactory.fillDefaults().grab(true, false);
            UIControlsFactory.createLabel((Composite)parent, (String)"Last Name:");
            Text txtLast = UIControlsFactory.createText((Composite)parent);
            hFill.applyTo((Control)txtLast);
            this.addUIControl(txtLast, "txtLast");
            UIControlsFactory.createLabel((Composite)parent, (String)"First Name:");
            Text txtFirst = UIControlsFactory.createText((Composite)parent);
            hFill.applyTo((Control)txtFirst);
            this.addUIControl(txtFirst, "txtFirst");
        }

        protected int getDetailsStyle() {
            return 2048;
        }
    }

    private static final class SimplePerson {
        private String first = "";
        private String last = "";

        private SimplePerson() {
        }

        public String getFirst() {
            return this.first;
        }

        public void setFirst(String first) {
            this.first = first;
        }

        public String getLast() {
            return this.last;
        }

        public void setLast(String last) {
            this.last = last;
        }
    }
}

