/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.eclipse.riena.core.util.WeakRef;
import org.eclipse.riena.internal.core.test.RienaTestCase;
import org.eclipse.riena.internal.core.test.collect.NonUITestCase;

@NonUITestCase
public class WeakRefTest
extends RienaTestCase {
    private static boolean gotNotified;

    public void testNotRemovedByOfGarbageCollectorBecauseStillReferences() throws IOException {
        gotNotified = false;
        StringBuffer bob = new StringBuffer("go away");
        WeakRef ref = new WeakRef((Object)bob, new Runnable(){

            public void run() {
                gotNotified = true;
            }
        });
        this.runOutOfMemory();
        WeakRefTest.assertNotNull((Object)ref.get());
        WeakRefTest.assertFalse((boolean)gotNotified);
    }

    public void testRemoveOfGarbageCollectedInstance() throws IOException {
        gotNotified = false;
        StringBuffer bob = new StringBuffer("go away");
        WeakRef ref = new WeakRef((Object)bob, new Runnable(){

            public void run() {
                gotNotified = true;
            }
        });
        bob = null;
        this.runOutOfMemory();
        WeakRefTest.assertNull((Object)ref.get());
        WeakRefTest.assertTrue((boolean)gotNotified);
    }

    private void runOutOfMemory() throws IOException {
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            while (true) {
                os.write(new byte[0x100000]);
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            System.gc();
            return;
        }
    }
}

