/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.navigation.ui.swt.workarea;

import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.internal.core.test.RienaTestCase;
import org.eclipse.riena.internal.core.test.collect.NonUITestCase;
import org.eclipse.riena.internal.navigation.ui.swt.workarea.SwtExtensionWorkareaDefinitionRegistry;
import org.eclipse.riena.navigation.ApplicationModelFailure;
import org.eclipse.riena.navigation.extension.IModuleGroupNode2Extension;
import org.eclipse.riena.navigation.extension.IModuleNode2Extension;
import org.eclipse.riena.navigation.extension.INode2Extension;
import org.eclipse.riena.navigation.extension.ISubApplicationNode2Extension;
import org.eclipse.riena.navigation.extension.ISubModuleNode2Extension;
import org.eclipse.riena.navigation.extension.ModuleGroupNode2Extension;
import org.eclipse.riena.navigation.extension.ModuleNode2Extension;
import org.eclipse.riena.navigation.extension.NavigationAssembly2Extension;
import org.eclipse.riena.navigation.extension.SubApplicationNode2Extension;
import org.eclipse.riena.navigation.extension.SubModuleNode2Extension;
import org.eclipse.riena.navigation.ui.controllers.SubModuleController;
import org.eclipse.riena.ui.workarea.IWorkareaDefinition;
import org.eclipse.riena.ui.workarea.WorkareaDefinition;

@NonUITestCase
public class SwtExtensionWorkareaDefinitionRegistryTest
extends RienaTestCase {
    private static final String TEST_TYPE_ID = "TestTypeId";
    private static final String OTHER_TEST_TYPE_ID = "OtherTestTypeId";
    private static final String TEST_VIEW_ID = "TestViewId";
    private static final String OTHER_TEST_VIEW_ID = "OtherTestViewId";
    private MySwtExtensionWorkareaDefinitionRegistry workareaDefinitionRegistry;
    private IWorkareaDefinition workareaDefinition;

    protected void setUp() throws Exception {
        super.setUp();
        this.workareaDefinitionRegistry = new MySwtExtensionWorkareaDefinitionRegistry();
        this.workareaDefinition = new WorkareaDefinition(TestSubModuleController.class, (Object)TEST_VIEW_ID);
    }

    public void testRegisterDefinition() throws Exception {
        this.workareaDefinitionRegistry.register(TEST_TYPE_ID, this.workareaDefinition);
        SwtExtensionWorkareaDefinitionRegistryTest.assertSame((Object)this.workareaDefinition, (Object)this.workareaDefinitionRegistry.getDefinition(TEST_TYPE_ID));
    }

    public void testRegisterSameDefinitionDifferentTypeId() throws Exception {
        this.workareaDefinitionRegistry.register(TEST_TYPE_ID, this.workareaDefinition);
        WorkareaDefinition otherWorkareaDefinition = new WorkareaDefinition(TestSubModuleController.class, (Object)TEST_VIEW_ID);
        this.workareaDefinitionRegistry.register(OTHER_TEST_TYPE_ID, (IWorkareaDefinition)otherWorkareaDefinition);
        SwtExtensionWorkareaDefinitionRegistryTest.assertSame((Object)this.workareaDefinition, (Object)this.workareaDefinitionRegistry.getDefinition(TEST_TYPE_ID));
        SwtExtensionWorkareaDefinitionRegistryTest.assertSame((Object)otherWorkareaDefinition, (Object)this.workareaDefinitionRegistry.getDefinition(OTHER_TEST_TYPE_ID));
    }

    public void testRegisterSameDefinitionSameTypeId() throws Exception {
        this.workareaDefinitionRegistry.register(TEST_TYPE_ID, this.workareaDefinition);
        WorkareaDefinition otherWorkareaDefinition = new WorkareaDefinition(TestSubModuleController.class, (Object)TEST_VIEW_ID);
        this.workareaDefinitionRegistry.register(TEST_TYPE_ID, (IWorkareaDefinition)otherWorkareaDefinition);
        SwtExtensionWorkareaDefinitionRegistryTest.assertSame((Object)this.workareaDefinition, (Object)this.workareaDefinitionRegistry.getDefinition(TEST_TYPE_ID));
        SwtExtensionWorkareaDefinitionRegistryTest.assertNotSame((Object)otherWorkareaDefinition, (Object)this.workareaDefinitionRegistry.getDefinition(TEST_TYPE_ID));
    }

    public void testRegisterDifferentDefinitionSameTypeId() throws Exception {
        this.workareaDefinitionRegistry.register(TEST_TYPE_ID, this.workareaDefinition);
        WorkareaDefinition otherWorkareaDefinition = null;
        try {
            otherWorkareaDefinition = new WorkareaDefinition(OtherTestSubModuleController.class, (Object)TEST_VIEW_ID);
            this.workareaDefinitionRegistry.register(TEST_TYPE_ID, (IWorkareaDefinition)otherWorkareaDefinition);
            SwtExtensionWorkareaDefinitionRegistryTest.fail((String)"ApplicationModelFailure expected");
        }
        catch (ApplicationModelFailure applicationModelFailure) {
            this.ok("ApplicationModelFailure expected");
        }
        try {
            otherWorkareaDefinition = new WorkareaDefinition(TestSubModuleController.class, (Object)OTHER_TEST_VIEW_ID);
            this.workareaDefinitionRegistry.register(TEST_TYPE_ID, (IWorkareaDefinition)otherWorkareaDefinition);
            SwtExtensionWorkareaDefinitionRegistryTest.fail((String)"ApplicationModelFailure expected");
        }
        catch (ApplicationModelFailure applicationModelFailure) {
            this.ok("ApplicationModelFailure expected");
        }
    }

    public void testRegisterINavigationAssembly2Extension() {
        NavigationAssembly2Extension assembly = new NavigationAssembly2Extension();
        SubModuleNode2Extension sub1 = new SubModuleNode2Extension();
        sub1.setNodeId("sub1");
        sub1.setViewId("v1");
        ISubModuleNode2Extension[] subMods = new ISubModuleNode2Extension[]{sub1};
        assembly.setSubModules(subMods);
        ReflectionUtils.invokeHidden((Object)((Object)this.workareaDefinitionRegistry), (String)"register", (Object[])new Object[]{assembly});
        IWorkareaDefinition def = this.workareaDefinitionRegistry.getDefinition("sub1");
        SwtExtensionWorkareaDefinitionRegistryTest.assertNotNull((Object)def);
        SwtExtensionWorkareaDefinitionRegistryTest.assertEquals((Object)"v1", (Object)def.getViewId());
        this.workareaDefinitionRegistry = new MySwtExtensionWorkareaDefinitionRegistry();
        ModuleNode2Extension m1 = new ModuleNode2Extension();
        m1.setNodeId("m1");
        IModuleNode2Extension[] mods = new IModuleNode2Extension[]{m1};
        assembly.setModules(mods);
        ReflectionUtils.invokeHidden((Object)((Object)this.workareaDefinitionRegistry), (String)"register", (Object[])new Object[]{assembly});
        def = this.workareaDefinitionRegistry.getDefinition("m1");
        SwtExtensionWorkareaDefinitionRegistryTest.assertNull((Object)def);
        def = this.workareaDefinitionRegistry.getDefinition("sub1");
        SwtExtensionWorkareaDefinitionRegistryTest.assertNull((Object)def);
        this.workareaDefinitionRegistry = new MySwtExtensionWorkareaDefinitionRegistry();
        ModuleGroupNode2Extension mg1 = new ModuleGroupNode2Extension();
        m1.setNodeId("mg1");
        IModuleGroupNode2Extension[] groups = new IModuleGroupNode2Extension[]{mg1};
        assembly.setModuleGroups(groups);
        ReflectionUtils.invokeHidden((Object)((Object)this.workareaDefinitionRegistry), (String)"register", (Object[])new Object[]{assembly});
        def = this.workareaDefinitionRegistry.getDefinition("mg1");
        SwtExtensionWorkareaDefinitionRegistryTest.assertNull((Object)def);
        def = this.workareaDefinitionRegistry.getDefinition("m1");
        SwtExtensionWorkareaDefinitionRegistryTest.assertNull((Object)def);
        def = this.workareaDefinitionRegistry.getDefinition("sub1");
        SwtExtensionWorkareaDefinitionRegistryTest.assertNull((Object)def);
        this.workareaDefinitionRegistry = new MySwtExtensionWorkareaDefinitionRegistry();
        SubApplicationNode2Extension subApp1 = new SubApplicationNode2Extension();
        subApp1.setNodeId("sa1");
        subApp1.setPerspectiveId("p1");
        SubApplicationNode2Extension subApp2 = new SubApplicationNode2Extension();
        subApp2.setNodeId("sa2");
        subApp2.setPerspectiveId("p2");
        ISubApplicationNode2Extension[] subApps = new ISubApplicationNode2Extension[]{subApp1, subApp2};
        assembly.setSubApplications(subApps);
        ReflectionUtils.invokeHidden((Object)((Object)this.workareaDefinitionRegistry), (String)"register", (Object[])new Object[]{assembly});
        def = this.workareaDefinitionRegistry.getDefinition("sa1");
        SwtExtensionWorkareaDefinitionRegistryTest.assertNotNull((Object)def);
        SwtExtensionWorkareaDefinitionRegistryTest.assertEquals((Object)"p1", (Object)def.getViewId());
        def = this.workareaDefinitionRegistry.getDefinition("sa2");
        SwtExtensionWorkareaDefinitionRegistryTest.assertNotNull((Object)def);
        SwtExtensionWorkareaDefinitionRegistryTest.assertEquals((Object)"p2", (Object)def.getViewId());
        def = this.workareaDefinitionRegistry.getDefinition("sub1");
        SwtExtensionWorkareaDefinitionRegistryTest.assertNull((Object)def);
    }

    public void testRegisterISubApplicationNode2Extension() {
        SubApplicationNode2Extension subApp12 = new SubApplicationNode2Extension();
        subApp12.setNodeId("sa12");
        subApp12.setPerspectiveId("p12");
        this.workareaDefinitionRegistry.register((ISubApplicationNode2Extension)subApp12);
        IWorkareaDefinition def = this.workareaDefinitionRegistry.getDefinition("sa12");
        SwtExtensionWorkareaDefinitionRegistryTest.assertNotNull((Object)def);
        SwtExtensionWorkareaDefinitionRegistryTest.assertEquals((Object)"p12", (Object)def.getViewId());
    }

    public void testRegisterISubModuleNode2Extension() {
        SubModuleNode2Extension subMod13 = new SubModuleNode2Extension();
        subMod13.setNodeId("sub13");
        subMod13.setViewId("v13");
        SubModuleNode2Extension subMod123 = new SubModuleNode2Extension();
        subMod123.setNodeId("sub123");
        subMod123.setViewId("v123");
        subMod123.setRequiresPreparation(true);
        subMod123.setSharedView(true);
        subMod13.setChildNodes((INode2Extension[])new ISubModuleNode2Extension[]{subMod123});
        this.workareaDefinitionRegistry.register((ISubModuleNode2Extension)subMod13);
        IWorkareaDefinition def = this.workareaDefinitionRegistry.getDefinition("sub13");
        SwtExtensionWorkareaDefinitionRegistryTest.assertNotNull((Object)def);
        SwtExtensionWorkareaDefinitionRegistryTest.assertEquals((Object)"v13", (Object)def.getViewId());
        SwtExtensionWorkareaDefinitionRegistryTest.assertFalse((boolean)def.isRequiredPreparation());
        SwtExtensionWorkareaDefinitionRegistryTest.assertFalse((boolean)def.isRequiredPreparation());
        def = this.workareaDefinitionRegistry.getDefinition("sub123");
        SwtExtensionWorkareaDefinitionRegistryTest.assertNotNull((Object)def);
        SwtExtensionWorkareaDefinitionRegistryTest.assertEquals((Object)"v123", (Object)def.getViewId());
        SwtExtensionWorkareaDefinitionRegistryTest.assertTrue((boolean)def.isRequiredPreparation());
        SwtExtensionWorkareaDefinitionRegistryTest.assertTrue((boolean)def.isRequiredPreparation());
    }

    private class MySwtExtensionWorkareaDefinitionRegistry
    extends SwtExtensionWorkareaDefinitionRegistry {
        private MySwtExtensionWorkareaDefinitionRegistry() {
        }

        public void register(ISubApplicationNode2Extension subAppicationExt) {
            super.register(subAppicationExt);
        }

        public void register(ISubModuleNode2Extension subModuleExt) {
            super.register(subModuleExt);
        }
    }

    private static class OtherTestSubModuleController
    extends SubModuleController {
        private OtherTestSubModuleController() {
        }
    }

    private static class TestSubModuleController
    extends SubModuleController {
        private TestSubModuleController() {
        }
    }
}

