/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.internal.ui.ridgets.swt.AbstractSWTRidgetTest;
import org.eclipse.riena.internal.ui.ridgets.swt.DateTextRidget;
import org.eclipse.riena.internal.ui.swt.test.UITestHelper;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.swt.DatePickerComposite;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class DateTextRidgetWithDatePickerCompositeTest
extends AbstractSWTRidgetTest {
    protected IRidget createRidget() {
        DateTextRidget result = new DateTextRidget();
        result.setFormat("dd.MM.yyyy");
        return result;
    }

    protected DateTextRidget getRidget() {
        return (DateTextRidget)super.getRidget();
    }

    protected Control createWidget(Composite parent) {
        DatePickerComposite result = new DatePickerComposite((Composite)this.getShell(), 131076);
        result.setData("type", (Object)"date");
        result.setLayoutData((Object)new RowData(100, -1));
        return result;
    }

    protected DatePickerComposite getWidget() {
        return (DatePickerComposite)super.getWidget();
    }

    public void testUIControlVsTextWidgetDistinction() {
        DateTextRidget ridget = this.getRidget();
        DateTextRidgetWithDatePickerCompositeTest.assertTrue((boolean)(ridget.getUIControl() instanceof DatePickerComposite));
        Object textWidget = ReflectionUtils.invokeHidden((Object)ridget, (String)"getTextWidget", null);
        DateTextRidgetWithDatePickerCompositeTest.assertTrue((boolean)(textWidget instanceof Text));
    }

    public void testVisibility() {
        DateTextRidget ridget = this.getRidget();
        Text text = (Text)ReflectionUtils.invokeHidden((Object)ridget, (String)"getTextWidget", null);
        DateTextRidgetWithDatePickerCompositeTest.assertTrue((boolean)text.isVisible());
        ridget.setVisible(false);
        DateTextRidgetWithDatePickerCompositeTest.assertFalse((boolean)ridget.isVisible());
        DateTextRidgetWithDatePickerCompositeTest.assertFalse((boolean)text.getParent().isVisible());
        DateTextRidgetWithDatePickerCompositeTest.assertFalse((boolean)text.isVisible());
        DateTextRidgetWithDatePickerCompositeTest.assertTrue((boolean)text.getVisible());
        ridget.setVisible(true);
        DateTextRidgetWithDatePickerCompositeTest.assertTrue((boolean)ridget.isVisible());
        DateTextRidgetWithDatePickerCompositeTest.assertTrue((boolean)text.isVisible());
        DateTextRidgetWithDatePickerCompositeTest.assertTrue((boolean)text.getParent().isVisible());
    }

    public void testPickerButtonDisabledWhenOutputOnly() {
        DateTextRidget ridget = this.getRidget();
        DatePickerComposite control = this.getWidget();
        Button pickerButton = (Button)ReflectionUtils.getHidden((Object)control, (String)"pickerButton");
        DateTextRidgetWithDatePickerCompositeTest.assertTrue((boolean)ridget.isEnabled());
        DateTextRidgetWithDatePickerCompositeTest.assertFalse((boolean)ridget.isOutputOnly());
        DateTextRidgetWithDatePickerCompositeTest.assertTrue((boolean)control.isEnabled());
        DateTextRidgetWithDatePickerCompositeTest.assertTrue((boolean)pickerButton.isEnabled());
        ridget.setOutputOnly(true);
        DateTextRidgetWithDatePickerCompositeTest.assertTrue((boolean)control.isEnabled());
        DateTextRidgetWithDatePickerCompositeTest.assertFalse((boolean)pickerButton.isEnabled());
        ridget.setOutputOnly(false);
        DateTextRidgetWithDatePickerCompositeTest.assertTrue((boolean)control.isEnabled());
        DateTextRidgetWithDatePickerCompositeTest.assertTrue((boolean)pickerButton.isEnabled());
        ridget.setEnabled(false);
        DateTextRidgetWithDatePickerCompositeTest.assertFalse((boolean)control.isEnabled());
        DateTextRidgetWithDatePickerCompositeTest.assertFalse((boolean)pickerButton.isEnabled());
        ridget.setEnabled(true);
        DateTextRidgetWithDatePickerCompositeTest.assertTrue((boolean)control.isEnabled());
        DateTextRidgetWithDatePickerCompositeTest.assertTrue((boolean)pickerButton.isEnabled());
        ridget.setOutputOnly(true);
        ridget.setEnabled(false);
        ridget.setEnabled(true);
        UITestHelper.readAndDispatch((Widget)control);
        DateTextRidgetWithDatePickerCompositeTest.assertTrue((boolean)control.isEnabled());
        DateTextRidgetWithDatePickerCompositeTest.assertFalse((boolean)pickerButton.isEnabled());
        ridget.setOutputOnly(false);
        ridget.setEnabled(false);
        ridget.setOutputOnly(true);
        ridget.setOutputOnly(false);
        UITestHelper.readAndDispatch((Widget)control);
        DateTextRidgetWithDatePickerCompositeTest.assertFalse((boolean)control.isEnabled());
        DateTextRidgetWithDatePickerCompositeTest.assertFalse((boolean)pickerButton.isEnabled());
    }
}

