/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.swt.lnf.renderer;

import java.util.HashSet;
import junit.framework.TestCase;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.internal.core.test.collect.NonUITestCase;
import org.eclipse.riena.navigation.ui.swt.lnf.renderer.EmbeddedBorderRenderer;
import org.eclipse.riena.ui.core.marker.DisabledMarker;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Rectangle;

@NonUITestCase
public class EmbeddedBorderRendererTest
extends TestCase {
    public void testComputeInnerBounds() throws Exception {
        Rectangle outerBounds = new Rectangle(12, 24, 36, 48);
        EmbeddedBorderRenderer renderer = new EmbeddedBorderRenderer();
        Rectangle innerBounds = renderer.computeInnerBounds(outerBounds);
        int width = renderer.getBorderWidth();
        EmbeddedBorderRendererTest.assertEquals((int)(outerBounds.x + width), (int)innerBounds.x);
        EmbeddedBorderRendererTest.assertEquals((int)(outerBounds.y + width), (int)innerBounds.y);
        EmbeddedBorderRendererTest.assertEquals((int)(outerBounds.width - width * 2), (int)innerBounds.width);
        EmbeddedBorderRendererTest.assertEquals((int)(outerBounds.height - width * 2), (int)innerBounds.height);
    }

    public void testGetBorderColor() {
        EmbeddedBorderRenderer renderer = new EmbeddedBorderRenderer();
        renderer.setActive(true);
        Color borderColor = (Color)ReflectionUtils.invokeHidden((Object)renderer, (String)"getBorderColor", (Object[])new Object[0]);
        Color expectedColor = LnfManager.getLnf().getColor("EmbeddedTitlebar.activeBorderColor");
        EmbeddedBorderRendererTest.assertSame((Object)expectedColor, (Object)borderColor);
        renderer.setActive(false);
        borderColor = (Color)ReflectionUtils.invokeHidden((Object)renderer, (String)"getBorderColor", (Object[])new Object[0]);
        expectedColor = LnfManager.getLnf().getColor("EmbeddedTitlebar.passiveBorderColor");
        EmbeddedBorderRendererTest.assertSame((Object)expectedColor, (Object)borderColor);
        renderer.setActive(true);
        HashSet<DisabledMarker> markers = new HashSet<DisabledMarker>();
        DisabledMarker newMarker = new DisabledMarker();
        markers.add(newMarker);
        renderer.setMarkers(markers);
        borderColor = (Color)ReflectionUtils.invokeHidden((Object)renderer, (String)"getBorderColor", (Object[])new Object[0]);
        expectedColor = LnfManager.getLnf().getColor("EmbeddedTitlebar.disabledBorderColor");
        EmbeddedBorderRendererTest.assertSame((Object)expectedColor, (Object)borderColor);
    }
}

