/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.swt.views;

import java.util.Collection;
import java.util.Map;
import org.eclipse.riena.core.marker.AbstractMarker;
import org.eclipse.riena.core.marker.IMarker;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.internal.core.test.RienaTestCase;
import org.eclipse.riena.internal.core.test.collect.UITestCase;
import org.eclipse.riena.navigation.IModuleNode;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.INavigationNodeController;
import org.eclipse.riena.navigation.INavigationProcessor;
import org.eclipse.riena.navigation.model.ModuleGroupNode;
import org.eclipse.riena.navigation.model.ModuleNode;
import org.eclipse.riena.navigation.model.NavigationProcessor;
import org.eclipse.riena.navigation.model.SubModuleNode;
import org.eclipse.riena.navigation.ui.swt.lnf.renderer.SubModuleTreeItemMarkerRenderer;
import org.eclipse.riena.navigation.ui.swt.views.ModuleView;
import org.eclipse.riena.navigation.ui.swt.views.SWTModuleController;
import org.eclipse.riena.ui.core.marker.AttentionMarker;
import org.eclipse.riena.ui.core.marker.ErrorMarker;
import org.eclipse.riena.ui.core.marker.MandatoryMarker;
import org.eclipse.riena.ui.ridgets.swt.DefaultRealm;
import org.eclipse.riena.ui.swt.EmbeddedTitleBar;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.riena.ui.swt.lnf.rienadefault.RienaDefaultLnf;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

@UITestCase
public class ModuleViewTest
extends RienaTestCase {
    private MyModuleView view;
    private ModuleNode node;
    private SubModuleNode subNode;
    private SubModuleNode subSubNode;
    private SubModuleNode subSubSubNode;
    private Shell shell;
    private RienaDefaultLnf currentLnf;
    private DisabledSubModuleTreeBackgroundPainterMock backgroundPainterMock;

    protected void setUp() throws Exception {
        super.setUp();
        new DefaultRealm();
        this.backgroundPainterMock = new DisabledSubModuleTreeBackgroundPainterMock();
        this.currentLnf = new RienaDefaultLnf();
        LnfManager.setLnf((RienaDefaultLnf)this.currentLnf);
        this.shell = new Shell();
        NavigationProcessor navigationProcessor = new NavigationProcessor();
        this.node = new ModuleNode();
        this.node.setNavigationNodeController((INavigationNodeController)new SWTModuleController((IModuleNode)this.node));
        this.view = new MyModuleView((Composite)this.shell);
        ModuleGroupNode moduleGroupNode = new ModuleGroupNode();
        moduleGroupNode.addChild((INavigationNode)this.node);
        this.view.setModuleGroupNode(moduleGroupNode);
        this.node.setNavigationProcessor((INavigationProcessor)navigationProcessor);
        this.subNode = new SubModuleNode();
        this.subNode.setNavigationProcessor((INavigationProcessor)navigationProcessor);
        this.node.addChild((INavigationNode)this.subNode);
        this.subSubNode = new SubModuleNode();
        this.subSubNode.setNavigationProcessor((INavigationProcessor)navigationProcessor);
        this.subNode.addChild((INavigationNode)this.subSubNode);
        this.subSubSubNode = new SubModuleNode();
        this.subSubSubNode.setNavigationProcessor((INavigationProcessor)navigationProcessor);
        this.subSubNode.addChild((INavigationNode)this.subSubSubNode);
        this.view.bind(this.node);
    }

    protected void tearDown() throws Exception {
        this.view.dispose();
        SwtUtilities.dispose((Widget)this.shell);
        this.node = null;
        super.tearDown();
    }

    public void testSetActivatedSubModuleExpanded() throws Exception {
        this.subNode.activate();
        ModuleViewTest.assertTrue((boolean)this.node.isActivated());
        ModuleViewTest.assertTrue((boolean)this.subNode.isActivated());
        ModuleViewTest.assertFalse((boolean)this.subSubNode.isActivated());
        ModuleViewTest.assertFalse((boolean)this.subSubSubNode.isActivated());
        ModuleViewTest.assertFalse((boolean)this.subNode.isExpanded());
        ModuleViewTest.assertFalse((boolean)this.subSubNode.isExpanded());
        this.subSubSubNode.activate();
        ModuleViewTest.assertTrue((boolean)this.node.isActivated());
        ModuleViewTest.assertFalse((boolean)this.subNode.isActivated());
        ModuleViewTest.assertFalse((boolean)this.subSubNode.isActivated());
        ModuleViewTest.assertTrue((boolean)this.subSubSubNode.isActivated());
        ModuleViewTest.assertTrue((boolean)this.subNode.isExpanded());
        ModuleViewTest.assertTrue((boolean)this.subSubNode.isExpanded());
    }

    public void testBlocking() {
        EmbeddedTitleBar title = (EmbeddedTitleBar)ReflectionUtils.invokeHidden((Object)((Object)this.view), (String)"getTitle", (Object[])new Object[0]);
        Composite body = (Composite)ReflectionUtils.invokeHidden((Object)((Object)this.view), (String)"getBody", (Object[])new Object[0]);
        Tree tree = this.view.getTree();
        Cursor waitCursor = title.getDisplay().getSystemCursor(1);
        this.node.setBlocked(true);
        Event event = new Event();
        event.type = 40;
        event.widget = this.view.getTree();
        this.view.getTree().notifyListeners(40, event);
        ModuleViewTest.assertTrue((boolean)this.backgroundPainterMock.handleEraseCalled);
        this.assertBlockedState(title, body, tree, waitCursor);
        this.node.setBlocked(false);
        this.assertUnBlockedState(title, body, tree, waitCursor);
        this.node.setBlocked(true);
        this.node.setBlocked(true);
        this.assertBlockedState(title, body, tree, waitCursor);
        this.node.setBlocked(false);
        this.assertUnBlockedState(title, body, tree, waitCursor);
    }

    private void assertUnBlockedState(EmbeddedTitleBar title, Composite body, Tree tree, Cursor waitCursor) {
        ModuleViewTest.assertNotSame((Object)waitCursor, (Object)title.getCursor());
        ModuleViewTest.assertTrue((boolean)title.isCloseable());
        ModuleViewTest.assertNotSame((Object)waitCursor, (Object)body.getCursor());
        ModuleViewTest.assertTrue((boolean)tree.getEnabled());
    }

    private void assertBlockedState(EmbeddedTitleBar title, Composite body, Tree tree, Cursor waitCursor) {
        ModuleViewTest.assertSame((Object)waitCursor, (Object)title.getCursor());
        ModuleViewTest.assertSame((Object)waitCursor, (Object)body.getCursor());
        ModuleViewTest.assertFalse((boolean)title.isCloseable());
        ModuleViewTest.assertFalse((boolean)tree.getEnabled());
    }

    public void testGetAllMarkers() {
        ErrorMarker em1 = new ErrorMarker();
        this.subNode.addMarker((IMarker)em1);
        MandatoryMarker mm2 = new MandatoryMarker();
        this.subSubNode.addMarker((IMarker)mm2);
        AttentionMarker am3 = new AttentionMarker();
        this.subSubSubNode.addMarker((IMarker)am3);
        MyMarker mym4 = new MyMarker();
        this.subSubSubNode.addMarker((IMarker)mym4);
        Collection markers = (Collection)ReflectionUtils.invokeHidden((Object)((Object)this.view), (String)"getAllMarkers", (Object[])new Object[]{this.subNode, false});
        ModuleViewTest.assertEquals((int)1, (int)markers.size());
        ModuleViewTest.assertTrue((boolean)markers.contains(em1));
        markers = (Collection)ReflectionUtils.invokeHidden((Object)((Object)this.view), (String)"getAllMarkers", (Object[])new Object[]{this.subNode, true});
        ModuleViewTest.assertEquals((int)3, (int)markers.size());
        ModuleViewTest.assertTrue((boolean)markers.contains(em1));
        ModuleViewTest.assertTrue((boolean)markers.contains(mm2));
        ModuleViewTest.assertTrue((boolean)markers.contains(am3));
        ModuleViewTest.assertFalse((boolean)markers.contains((Object)mym4));
        markers = (Collection)ReflectionUtils.invokeHidden((Object)((Object)this.view), (String)"getAllMarkers", (Object[])new Object[]{this.subSubNode, true});
        ModuleViewTest.assertEquals((int)2, (int)markers.size());
        ModuleViewTest.assertFalse((boolean)markers.contains(em1));
        ModuleViewTest.assertTrue((boolean)markers.contains(mm2));
        ModuleViewTest.assertTrue((boolean)markers.contains(am3));
        ModuleViewTest.assertFalse((boolean)markers.contains((Object)mym4));
        this.subSubSubNode.setVisible(false);
        markers = (Collection)ReflectionUtils.invokeHidden((Object)((Object)this.view), (String)"getAllMarkers", (Object[])new Object[]{this.subNode, true});
        ModuleViewTest.assertEquals((int)2, (int)markers.size());
        ModuleViewTest.assertTrue((boolean)markers.contains(em1));
        ModuleViewTest.assertTrue((boolean)markers.contains(mm2));
        ModuleViewTest.assertFalse((boolean)markers.contains(am3));
        ModuleViewTest.assertFalse((boolean)markers.contains((Object)mym4));
        this.subSubNode.setVisible(false);
        this.subSubSubNode.setVisible(true);
        markers = (Collection)ReflectionUtils.invokeHidden((Object)((Object)this.view), (String)"getAllMarkers", (Object[])new Object[]{this.subNode, true});
        ModuleViewTest.assertEquals((int)1, (int)markers.size());
        ModuleViewTest.assertTrue((boolean)markers.contains(em1));
        ModuleViewTest.assertFalse((boolean)markers.contains(mm2));
        ModuleViewTest.assertFalse((boolean)markers.contains(am3));
        ModuleViewTest.assertFalse((boolean)markers.contains((Object)mym4));
        this.subSubNode.setVisible(true);
        this.subSubSubNode.setEnabled(false);
        markers = (Collection)ReflectionUtils.invokeHidden((Object)((Object)this.view), (String)"getAllMarkers", (Object[])new Object[]{this.subNode, true});
        ModuleViewTest.assertEquals((int)3, (int)markers.size());
        ModuleViewTest.assertTrue((boolean)markers.contains(em1));
        ModuleViewTest.assertTrue((boolean)markers.contains(mm2));
        ModuleViewTest.assertTrue((boolean)markers.contains(am3));
        ModuleViewTest.assertFalse((boolean)markers.contains((Object)mym4));
    }

    public void testPaintTreeItem() {
        SubModuleTreeItemMarkerRenderer renderer = new SubModuleTreeItemMarkerRenderer();
        Map rendererTable = (Map)ReflectionUtils.getHidden((Object)this.currentLnf, (String)"rendererTable");
        rendererTable.put("SubModuleTreeItemMarker.renderer", renderer);
        ErrorMarker em1 = new ErrorMarker();
        this.subNode.addMarker((IMarker)em1);
        MandatoryMarker mm2 = new MandatoryMarker();
        this.subSubNode.addMarker((IMarker)mm2);
        AttentionMarker am3 = new AttentionMarker();
        this.subSubSubNode.addMarker((IMarker)am3);
        Tree tree = this.view.getTree();
        TreeItem item = new TreeItem(tree, 0);
        item.setData((Object)this.subNode);
        TreeItem item2 = new TreeItem(item, 0);
        item2.setData((Object)this.subSubNode);
        TreeItem item3 = new TreeItem(item2, 0);
        item3.setData((Object)this.subSubSubNode);
        Event event = new Event();
        event.item = item;
        event.x = 11;
        event.y = 22;
        event.width = 123;
        event.height = 456;
        event.gc = new GC((Drawable)tree);
        ReflectionUtils.invokeHidden((Object)((Object)this.view), (String)"paintTreeItem", (Object[])new Object[]{event});
        Collection markers = renderer.getMarkers();
        ModuleViewTest.assertEquals((int)3, (int)markers.size());
        ModuleViewTest.assertTrue((boolean)markers.contains(em1));
        ModuleViewTest.assertTrue((boolean)markers.contains(mm2));
        ModuleViewTest.assertTrue((boolean)markers.contains(am3));
        ModuleViewTest.assertEquals((int)event.x, (int)renderer.getBounds().x);
        ModuleViewTest.assertEquals((int)event.y, (int)renderer.getBounds().y);
        ModuleViewTest.assertEquals((int)event.width, (int)renderer.getBounds().width);
        ModuleViewTest.assertEquals((int)event.height, (int)renderer.getBounds().height);
        item.setExpanded(true);
        ReflectionUtils.invokeHidden((Object)((Object)this.view), (String)"paintTreeItem", (Object[])new Object[]{event});
        markers = renderer.getMarkers();
        ModuleViewTest.assertEquals((int)1, (int)markers.size());
        ModuleViewTest.assertTrue((boolean)markers.contains(em1));
        ModuleViewTest.assertFalse((boolean)markers.contains(mm2));
        ModuleViewTest.assertFalse((boolean)markers.contains(am3));
        event.gc.dispose();
    }

    public void testClipSubModuleText() {
        this.subNode.setLabel("This is a very long text. Text text will be clipped");
        Tree tree = this.view.getTree();
        TreeItem item = tree.getItem(0);
        ModuleViewTest.assertEquals((String)"This is a very long text. Text text will be clipped", (String)item.getText());
        GC gc = new GC((Drawable)tree);
        tree.setSize(10, 100);
        boolean ret = (Boolean)ReflectionUtils.invokeHidden((Object)((Object)this.view), (String)"clipSubModuleText", (Object[])new Object[]{gc, item});
        ModuleViewTest.assertTrue((boolean)ret);
        ModuleViewTest.assertEquals((String)"...", (String)item.getText());
        tree.setSize(10000, 100);
        ret = (Boolean)ReflectionUtils.invokeHidden((Object)((Object)this.view), (String)"clipSubModuleText", (Object[])new Object[]{gc, item});
        ModuleViewTest.assertTrue((boolean)ret);
        ModuleViewTest.assertEquals((String)"This is a very long text. Text text will be clipped", (String)item.getText());
        ret = (Boolean)ReflectionUtils.invokeHidden((Object)((Object)this.view), (String)"clipSubModuleText", (Object[])new Object[]{gc, item});
        ModuleViewTest.assertFalse((boolean)ret);
        ModuleViewTest.assertEquals((String)"This is a very long text. Text text will be clipped", (String)item.getText());
        gc.dispose();
    }

    public void testGetItemText() {
        this.subNode.setLabel("Text of Node");
        Tree tree = this.view.getTree();
        TreeItem item = tree.getItem(0);
        String retText = (String)ReflectionUtils.invokeHidden((Object)((Object)this.view), (String)"getItemText", (Object[])new Object[]{item});
        ModuleViewTest.assertEquals((String)"Text of Node", (String)retText);
        item.setText("Text of Item");
        retText = (String)ReflectionUtils.invokeHidden((Object)((Object)this.view), (String)"getItemText", (Object[])new Object[]{item});
        ModuleViewTest.assertEquals((String)"Text of Node", (String)retText);
        TreeItem simpleItem = new TreeItem(tree, 0);
        simpleItem.setText("Text of Item");
        retText = (String)ReflectionUtils.invokeHidden((Object)((Object)this.view), (String)"getItemText", (Object[])new Object[]{simpleItem});
        ModuleViewTest.assertEquals((String)"Text of Item", (String)retText);
    }

    public void testFindItem() throws Exception {
        Tree tree = this.view.getTree();
        TreeItem item1 = new TreeItem(tree, 0);
        SubModuleNode s1 = new SubModuleNode("s1");
        item1.setData((Object)s1);
        TreeItem foundItem = (TreeItem)ReflectionUtils.invokeHidden((Object)((Object)this.view), (String)"findItem", (Object[])new Object[]{tree.getItems(), s1});
        ModuleViewTest.assertSame((Object)item1, (Object)foundItem);
        SubModuleNode s2 = new SubModuleNode("s2");
        foundItem = (TreeItem)ReflectionUtils.invokeHidden((Object)((Object)this.view), (String)"findItem", (Object[])new Object[]{tree.getItems(), s2});
        ModuleViewTest.assertNull((Object)foundItem);
        s1.addChild((INavigationNode)s2);
        foundItem = (TreeItem)ReflectionUtils.invokeHidden((Object)((Object)this.view), (String)"findItem", (Object[])new Object[]{tree.getItems(), s2});
        ModuleViewTest.assertNull((Object)foundItem);
        TreeItem item2 = new TreeItem(item1, 0);
        item2.setData((Object)s2);
        foundItem = (TreeItem)ReflectionUtils.invokeHidden((Object)((Object)this.view), (String)"findItem", (Object[])new Object[]{tree.getItems(), s2});
        ModuleViewTest.assertSame((Object)item2, (Object)foundItem);
    }

    private class DisabledSubModuleTreeBackgroundPainterMock
    implements Listener {
        private boolean handleEraseCalled = false;

        private DisabledSubModuleTreeBackgroundPainterMock() {
        }

        public void handleEvent(Event event) {
            if (40 == event.type) {
                this.handleEraseCalled = true;
            }
        }
    }

    private class MyMarker
    extends AbstractMarker {
        private MyMarker() {
        }
    }

    private class MyModuleView
    extends ModuleView {
        public MyModuleView(Composite parent) {
            super(parent);
        }

        public Tree getTree() {
            return super.getTree();
        }

        protected Listener createDisabledSubModuleTreeBackgroundPainter(Color disabledBackgroundColor) {
            return ModuleViewTest.this.backgroundPainterMock;
        }
    }
}

