/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.core.resource;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.riena.ui.core.resource.IIconManager;
import org.eclipse.riena.ui.core.resource.IconSize;
import org.eclipse.riena.ui.core.resource.IconState;

public class IconManager
implements IIconManager {
    private static final char EXTENSION_SEPARATOR = '.';
    private final Map<String, Icon> icons = new HashMap<String, Icon>();

    public String getIconID(String name, IconSize size) {
        return this.getIconID(name, size, IconState.NORMAL);
    }

    public String getIconID(String name, IconSize size, IconState state) {
        if (name == null) {
            return null;
        }
        Icon icon = this.createIcon(name, size, state);
        String iconID = icon.getID();
        this.icons.put(iconID, icon);
        return iconID;
    }

    protected Icon createIcon(String name, IconSize size, IconState state) {
        return new Icon(name, size, state);
    }

    public String getName(String iconID) {
        Icon icon = this.icons.get(iconID);
        if (icon != null) {
            return icon.getName();
        }
        return null;
    }

    public IconSize getSize(String iconID) {
        Icon icon = this.icons.get(iconID);
        if (icon != null) {
            return icon.getSize();
        }
        return null;
    }

    public IconState getState(String iconID) {
        Icon icon = this.icons.get(iconID);
        if (icon != null) {
            return icon.getState();
        }
        return null;
    }

    public boolean hasExtension(String iconID) {
        return iconID.indexOf(46) > 0;
    }

    public class Icon {
        private final String name;
        private final IconSize size;
        private final IconState state;

        public Icon(String name, IconSize size, IconState state) {
            this.name = name;
            this.size = size;
            this.state = state;
        }

        public String getID() {
            String id = this.name;
            if (this.state != null) {
                id = String.valueOf(id) + this.state.getDefaultMapping();
            }
            if (this.size != null) {
                id = String.valueOf(id) + this.size.getDefaultMapping();
            }
            return id;
        }

        public String getName() {
            return this.name;
        }

        public IconSize getSize() {
            return this.size;
        }

        public IconState getState() {
            return this.state;
        }
    }
}

