/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.core.uiprocess;

import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.riena.core.util.Nop;
import org.eclipse.riena.ui.core.uiprocess.UIProcess;
import org.eclipse.riena.ui.core.uiprocess.UISynchronizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UIExecutor {
    private UIExecutor() {
        Nop.reason((String)"Utility");
    }

    public static <T> T executeLively(Callable<T> callable) {
        return UIExecutor.executeLively(callable, false);
    }

    public static <T> T executeLively(Callable<T> callable, boolean user) {
        final BackgroundProcess<T> process = new BackgroundProcess<T>(callable, user);
        process.start();
        UISynchronizer.createSynchronizer().readAndDispatch(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return process.isFinished();
            }
        });
        if (((BackgroundProcess)process).getError() != null) {
            throw new RuntimeException("Exception while executing callable.", ((BackgroundProcess)process).getError());
        }
        return (T)((BackgroundProcess)process).getResult();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BackgroundProcess<T>
    extends UIProcess {
        private final AtomicBoolean finished = new AtomicBoolean(false);
        private final Callable<T> callable;
        private T result;
        private Throwable error;

        public BackgroundProcess(Callable<T> callable, boolean user) {
            super("UIExecutor", user);
            this.callable = callable;
        }

        @Override
        public boolean runJob(IProgressMonitor monitor) {
            try {
                try {
                    this.result = this.callable.call();
                }
                catch (Throwable e) {
                    this.error = e;
                    this.finished.set(true);
                }
            }
            finally {
                this.finished.set(true);
            }
            return true;
        }

        private boolean isFinished() {
            return this.finished.get();
        }

        private T getResult() {
            return this.result;
        }

        private Throwable getError() {
            return this.error;
        }
    }
}

