/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import java.util.Arrays;
import java.util.Collections;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.riena.core.util.ListenerList;
import org.eclipse.riena.core.util.StringUtils;
import org.eclipse.riena.internal.ui.ridgets.swt.AbstractObserver;
import org.eclipse.riena.ui.ridgets.AbstractMarkerSupport;
import org.eclipse.riena.ui.ridgets.ILinkRidget;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.listener.ISelectionListener;
import org.eclipse.riena.ui.ridgets.listener.SelectionEvent;
import org.eclipse.riena.ui.ridgets.swt.AbstractSWTRidget;
import org.eclipse.riena.ui.ridgets.swt.AbstractValueRidget;
import org.eclipse.riena.ui.ridgets.swt.BasicMarkerSupport;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Link;

public class LinkRidget
extends AbstractValueRidget
implements ILinkRidget {
    private static final String PROPERTY_TEXT_INTERNAL = "textInternal";
    private final LinkSelectionObserver selectionObserver = new LinkSelectionObserver((IRidget)this);
    private String text;
    private boolean textAlreadyInitialized;

    protected void checkUIControl(Object uiControl) {
        AbstractSWTRidget.assertType(uiControl, Link.class);
    }

    protected void bindUIControl() {
        Link control = this.getUIControl();
        if (control != null) {
            control.addSelectionListener((SelectionListener)this.selectionObserver);
            this.initText();
            this.updateUIText();
        }
    }

    protected void unbindUIControl() {
        super.unbindUIControl();
        Link control = this.getUIControl();
        if (control != null) {
            control.removeSelectionListener((SelectionListener)this.selectionObserver);
        }
    }

    protected AbstractMarkerSupport createMarkerSupport() {
        return new BasicMarkerSupport(this, this.propertyChangeSupport);
    }

    protected IObservableValue getRidgetObservable() {
        return BeansObservables.observeValue((Object)((Object)this), (String)PROPERTY_TEXT_INTERNAL);
    }

    public void addSelectionListener(ISelectionListener listener) {
        this.selectionObserver.addListener(listener);
    }

    public Link getUIControl() {
        return (Link)super.getUIControl();
    }

    public String getText() {
        return this.text;
    }

    public final String getTextInternal() {
        return this.getText();
    }

    public boolean isDisableMandatoryMarker() {
        return true;
    }

    public void removeSelectionListener(ISelectionListener listener) {
        this.selectionObserver.removeListener(listener);
    }

    public void setText(String text) {
        String oldText = this.text;
        this.text = text;
        this.updateUIText();
        this.firePropertyChange(PROPERTY_TEXT_INTERNAL, oldText, this.text);
        this.firePropertyChange("text", oldText, this.text);
    }

    public void setText(String text, String link) {
        String mergedText = StringUtils.isDeepEmpty((String)text) && StringUtils.isDeepEmpty((String)link) ? "" : (StringUtils.isDeepEmpty((String)link) ? String.format("<a>%s</a>", this.convertNullToEmpty(text)) : String.format("<a href=\"%s\">%s</a>", this.convertNullToEmpty(link), this.convertNullToEmpty(text)));
        this.setText(mergedText);
    }

    public final void setTextInternal(String text) {
        this.setText(text);
    }

    private String convertNullToEmpty(String value) {
        return StringUtils.isDeepEmpty((String)value) ? "" : value;
    }

    private void updateUIText() {
        Link control = this.getUIControl();
        if (control != null) {
            control.setText(this.convertNullToEmpty(this.text));
        }
    }

    private void initText() {
        Link control;
        if (this.text == null && !this.textAlreadyInitialized && (control = this.getUIControl()) != null && !control.isDisposed()) {
            this.text = control.getText();
            this.textAlreadyInitialized = true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class LinkSelectionObserver
    extends AbstractObserver<ISelectionListener> {
        public LinkSelectionObserver(IRidget source) {
            super(source);
        }

        @Override
        protected ListenerList<ISelectionListener> createList() {
            return new ListenerList(ISelectionListener.class);
        }

        @Override
        protected void fireAction(org.eclipse.swt.events.SelectionEvent evt) {
            ListenerList listeners = this.getListeners();
            if (listeners != null) {
                SelectionEvent event = new SelectionEvent(this.getSource(), Collections.EMPTY_LIST, Arrays.asList(evt.text));
                ISelectionListener[] iSelectionListenerArray = (ISelectionListener[])listeners.getListeners();
                int n = iSelectionListenerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ISelectionListener listener = iSelectionListenerArray[n2];
                    listener.ridgetSelected(event);
                    ++n2;
                }
            }
        }
    }
}

