/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.swt;

import org.eclipse.riena.ui.swt.AbstractStatuslineComposite;
import org.eclipse.riena.ui.swt.NumberLabel;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Widget;

public class StatuslineNumber
extends AbstractStatuslineComposite {
    private NumberLabel numberLabel;

    public StatuslineNumber(Composite parent, int style) {
        super(parent, style | 0x80000);
    }

    protected void createContents() {
        this.numberLabel = new NumberLabel(this, 16384);
        this.numberLabel.setFixWidth(this.getFixWidthLabel());
        this.numberLabel.setText("0000000");
        this.numberLabel.setBackground(LnfManager.getLnf().getColor("statusline.background"));
    }

    protected int getFixWidthLabel() {
        return 0;
    }

    public void dispose() {
        super.dispose();
        SwtUtilities.dispose((Widget)this.numberLabel);
    }

    public void setNumber(int number) {
        String numberStrg = "";
        if (number > 0) {
            numberStrg = Integer.toString(number);
            StringBuilder sb = new StringBuilder(numberStrg);
            while (sb.length() < 7) {
                sb.insert(0, '0');
            }
            numberStrg = sb.toString();
        }
        this.setNumber(numberStrg);
    }

    public void setNumber(String number) {
        if (number != null) {
            this.numberLabel.setText(number);
        } else {
            this.numberLabel.setText("");
        }
    }
}

