/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.communication.core;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.riena.communication.core.RemoteFailure;
import org.eclipse.riena.communication.core.ServiceClassLoader;
import org.eclipse.riena.communication.core.util.CommunicationUtil;
import org.eclipse.riena.core.util.VariableManagerUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteServiceDescription {
    private final Class<?> serviceInterfaceClass;
    private final Bundle serviceBundle;
    private final String serviceInterfaceClassName;
    private final String protocol;
    private final ServiceReference serviceRef;
    private final String path;
    private final ClassLoader serviceClassLoader;
    private State state = State.REGISTERED;
    private Object service;
    private String url;

    public RemoteServiceDescription(Class<?> interfaceClass, String url, String protocol, Bundle bundle) {
        this.serviceInterfaceClass = interfaceClass;
        this.serviceInterfaceClassName = interfaceClass.getName();
        this.url = url;
        this.protocol = protocol;
        this.serviceBundle = bundle;
        this.path = null;
        this.serviceRef = null;
        this.serviceClassLoader = new ServiceClassLoader(this.serviceBundle);
    }

    public RemoteServiceDescription(String interfaceName, ServiceReference serviceRef, String path, String protocol) throws ClassNotFoundException {
        this.serviceInterfaceClassName = interfaceName;
        this.serviceRef = serviceRef;
        this.serviceBundle = serviceRef.getBundle();
        this.service = this.serviceBundle.getBundleContext().getService(serviceRef);
        this.path = CommunicationUtil.accessProperty(serviceRef.getProperty("riena.remote.path"), path);
        this.protocol = CommunicationUtil.accessProperty(serviceRef.getProperty("riena.remote.protocol"), protocol);
        this.serviceInterfaceClass = this.serviceBundle.loadClass(interfaceName);
        this.serviceClassLoader = new ServiceClassLoader(this.serviceBundle);
    }

    public ClassLoader getServiceClassLoader() {
        return this.serviceClassLoader;
    }

    public void dispose() {
        this.service = null;
        this.url = null;
        this.state = State.UNREGISTERED;
    }

    public Bundle getBundle() {
        return this.serviceBundle;
    }

    public String getPath() {
        return this.path;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public Object getService() {
        return this.service;
    }

    public Class<?> getServiceInterfaceClass() {
        return this.serviceInterfaceClass;
    }

    public String getServiceInterfaceClassName() {
        return this.serviceInterfaceClassName;
    }

    public ServiceReference getServiceRef() {
        return this.serviceRef;
    }

    public State getState() {
        return this.state;
    }

    public String getURL() {
        try {
            return VariableManagerUtil.substitute((String)this.url);
        }
        catch (CoreException coreException) {
            return this.url;
        }
    }

    public void setService(Object service) {
        this.service = service;
    }

    public void setURL(String url) {
        this.url = url;
    }

    public String toString() {
        return "RemoteServiceDescription [serviceInterfaceClassName=" + this.serviceInterfaceClassName + ", protocol=" + this.protocol + ", url=" + this.url + "]";
    }

    private void assertServiceConstraints() {
        if (this.serviceInterfaceClass != null) {
            Method[] methods = this.serviceInterfaceClass.getMethods();
            HashSet<String> names = new HashSet<String>();
            Method[] methodArray = methods;
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                if (!Modifier.isVolatile(method.getModifiers()) && !names.add(method.getName())) {
                    throw new RemoteFailure("Can not use interface " + this.serviceInterfaceClass.getName() + " as service interface because at least one method (" + method.getName() + ") is overloaded, i.e. methods exists with the same name but different signatures.");
                }
                ++n2;
            }
        }
        if (this.service != null && this.serviceInterfaceClass != null && !this.serviceInterfaceClass.isAssignableFrom(this.service.getClass())) {
            throw new RemoteFailure("Service class " + this.service.getClass().getName() + " and service interface class " + this.serviceInterfaceClass.getName() + " do not match, i.e. service can not be assigend to service interface.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        REGISTERED,
        UNREGISTERED;

    }
}

