/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.communication.sample.pingpong.client;

import org.eclipse.riena.communication.sample.pingpong.common.IPingPong;
import org.eclipse.riena.communication.sample.pingpong.common.Ping;
import org.eclipse.riena.communication.sample.pingpong.common.Pong;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

public class Activator
implements BundleActivator {
    private BundleContext context;

    public void start(BundleContext context) throws Exception {
        this.context = context;
        ServiceReference pingPongRef = context.getServiceReference(IPingPong.class.getName());
        if (pingPongRef != null) {
            new PingClient().sendPing(pingPongRef);
        } else {
            context.addServiceListener((ServiceListener)new PingClient(), "(objectClass=" + IPingPong.class.getName() + ")");
        }
    }

    public void stop(BundleContext context) throws Exception {
        this.context = null;
    }

    class PingClient
    implements ServiceListener {
        PingClient() {
        }

        public void serviceChanged(ServiceEvent event) {
            ServiceReference pingPongRef = event.getServiceReference();
            this.sendPing(pingPongRef);
        }

        void sendPing(ServiceReference pingPongRef) {
            IPingPong pingPong = (IPingPong)Activator.this.context.getService(pingPongRef);
            if (pingPong == null) {
                return;
            }
            Ping ping = new Ping();
            ping.setText("I ping you and you pong me");
            Pong pong = pingPong.ping(ping);
            System.out.println("PingPong::Client:: " + pong);
        }
    }
}

