/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core.ping;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PingResult {
    private final String pingableName;
    private String failureMessage;
    private List<PingResult> nestedResults;

    public PingResult(String pingableName) {
        this.pingableName = pingableName;
    }

    public String getPingableName() {
        return this.pingableName;
    }

    public void addNestedResult(PingResult nested) {
        if (this.nestedResults == null) {
            this.nestedResults = new ArrayList<PingResult>();
        }
        this.nestedResults.add(nested);
    }

    public Iterable<PingResult> getNestedResults() {
        if (this.nestedResults == null) {
            return Collections.emptyList();
        }
        return this.nestedResults;
    }

    public void setPingFailure(Exception exception) {
        this.setPingFailure(this.toString(exception));
    }

    public void setPingFailure(String message) {
        this.failureMessage = message;
    }

    public String getPingFailure() {
        return this.failureMessage;
    }

    public boolean hasPingFailed() {
        return this.getPingFailure() != null;
    }

    public String toString() {
        StringBuilder bob = new StringBuilder("PingResult[");
        bob.append("name=");
        bob.append(this.getPingableName());
        bob.append(", failure=");
        bob.append(this.getPingFailure());
        bob.append(", nested=");
        bob.append(this.getNestedResults());
        bob.append("]");
        return bob.toString();
    }

    public int hashCode() {
        return this.getPingableName().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PingResult other = (PingResult)obj;
        if (this.pingableName == null ? other.pingableName != null : !this.pingableName.equals(other.pingableName)) {
            return false;
        }
        if (this.failureMessage == null ? other.failureMessage != null : !this.failureMessage.equals(other.failureMessage)) {
            return false;
        }
        return !(this.nestedResults == null ? other.nestedResults != null : !this.nestedResults.equals(other.nestedResults));
    }

    private String toString(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }
}

