/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core.singleton;

import org.eclipse.riena.core.singleton.ISingletonInitializer;
import org.eclipse.riena.internal.core.singleton.RCPSingletonProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingletonProvider<S> {
    protected final Class<S> singletonClass;
    protected final ISingletonInitializer<S> initializer;
    private volatile S singleton;

    public SingletonProvider(Class<S> singletonClass) {
        this(singletonClass, null);
    }

    public SingletonProvider(Class<S> singletonClass, ISingletonInitializer<S> initializer) {
        this.singletonClass = singletonClass;
        this.initializer = initializer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public S getInstance() {
        S result = this.singleton;
        if (result == null) {
            SingletonProvider singletonProvider = this;
            synchronized (singletonProvider) {
                result = this.singleton;
                if (result == null) {
                    this.singleton = result = RCPSingletonProvider.getInstance(this.singletonClass, this.initializer);
                }
            }
        }
        return result;
    }
}

