/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.core.singleton;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.riena.core.singleton.ISingletonInitializer;
import org.eclipse.riena.core.singleton.SingletonFailure;
import org.eclipse.riena.core.util.Nop;
import org.eclipse.riena.core.util.RAPDetector;
import org.eclipse.riena.core.wire.Wire;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RAPSingletonProvider {
    private static final boolean IS_AVAILABLE;
    private static Class<?> sessionSingletonBaseClass;
    private static Method getInstanceMethod;
    private static final Map<Object, Boolean> WIRED_RAP_SINGLETONS;
    private static final String SESSION_SINGLETON_BASE = "org.eclipse.rwt.SessionSingletonBase";
    private static final String GET_INSTANCE = "getInstance";

    static {
        WIRED_RAP_SINGLETONS = new WeakHashMap<Object, Boolean>();
        IS_AVAILABLE = RAPDetector.isRAPavailable() && RAPSingletonProvider.loadSessionSingletonBase();
    }

    private RAPSingletonProvider() {
        Nop.reason("utility");
    }

    private static boolean loadSessionSingletonBase() {
        Bundle rapBundle = RAPDetector.getRWTBundle();
        try {
            sessionSingletonBaseClass = rapBundle.loadClass(SESSION_SINGLETON_BASE);
            getInstanceMethod = sessionSingletonBaseClass.getMethod(GET_INSTANCE, Class.class);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isAvailable() {
        return IS_AVAILABLE;
    }

    public static <S> S getInstance(Class<S> singletonClass) {
        return RAPSingletonProvider.getInstance(singletonClass, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <S> S getInstance(Class<S> singletonClass, ISingletonInitializer<S> initializer) {
        try {
            Object rapSingleton = getInstanceMethod.invoke(sessionSingletonBaseClass, singletonClass);
            Map<Object, Boolean> map = WIRED_RAP_SINGLETONS;
            synchronized (map) {
                if (WIRED_RAP_SINGLETONS.put(rapSingleton, Boolean.TRUE) == null) {
                    if (initializer != null) {
                        initializer.init(rapSingleton);
                    }
                    Wire.instance(rapSingleton).andStart();
                }
            }
            return (S)rapSingleton;
        }
        catch (Exception e) {
            throw new SingletonFailure("Could not instantiate RAP controlled singleton.", e);
        }
    }
}

